/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.managerAPI;

import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.asteriskjava.live.ManagerCommunicationException;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.pbx.AsteriskSettings;
import org.asteriskjava.pbx.CallerID;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.NewChannelListener;
import org.asteriskjava.pbx.PBX;
import org.asteriskjava.pbx.PBXException;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.asterisk.wrap.actions.OriginateAction;
import org.asteriskjava.pbx.asterisk.wrap.events.BridgeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.DialBeginEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.DialEndEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.HangupEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.LinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.OriginateResponseEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.UnlinkEvent;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.pbx.internal.managerAPI.EventListenerBaseClass;
import org.asteriskjava.pbx.internal.managerAPI.OriginateResult;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class OriginateBaseClass
extends EventListenerBaseClass {
    protected static final Log logger = LogFactory.getLog(OriginateBaseClass.class);
    private volatile String originateID;
    private volatile boolean originateSuccess;
    private final Channel monitorChannel1;
    private boolean hungup = false;
    private Channel newChannel;
    private final Channel monitorChannel2;
    private final OriginateResult result;
    Exception ex = new Exception("Created here");
    private boolean originateSeen = false;
    private boolean channelSeen = false;
    private final NewChannelListener listener;
    private final CountDownLatch originateLatch = new CountDownLatch(1);
    private final AsteriskPBX pbx;
    private String channelId;
    private final AtomicInteger managerEventsSeen = new AtomicInteger();
    private static final AtomicLong originateSeed = new AtomicLong();

    protected OriginateBaseClass(NewChannelListener listener, Channel monitor, Channel monitor2) {
        super("NewOrginateClass", PBXFactory.getActivePBX());
        this.pbx = (AsteriskPBX)PBXFactory.getActivePBX();
        this.listener = listener;
        this.monitorChannel1 = monitor;
        this.monitorChannel2 = monitor2;
        this.result = new OriginateResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OriginateResult originate(EndPoint local, EndPoint target, HashMap<String, String> myVars, CallerID callerID, Integer timeout, boolean hideCallerId, String context) {
        logger.info("originate called");
        this.originateSeen = false;
        this.channelSeen = false;
        if (this.hungup) {
            return null;
        }
        logger.info("originate connection endPoint \n" + local + " to endPoint " + target + " vars " + myVars);
        ManagerResponse response = null;
        AsteriskSettings settings = PBXFactory.getActiveProfile();
        OriginateAction originate = new OriginateAction();
        this.originateID = originate.getActionId();
        this.channelId = "" + System.currentTimeMillis() / 1000L + ".AJ" + originateSeed.incrementAndGet();
        originate.setChannelId(this.channelId);
        Integer localTimeout = timeout;
        if (timeout == null) {
            localTimeout = 30000;
            try {
                localTimeout = settings.getDialTimeout() * 1000;
            }
            catch (Exception e) {
                logger.error("Invalid dial timeout value");
            }
        }
        if (local.isLocal()) {
            originate.setEndPoint(local);
            originate.setOption("/n");
        } else {
            originate.setEndPoint(local);
        }
        originate.setContext(context);
        originate.setExten(target);
        originate.setPriority(1);
        if (hideCallerId) {
            originate.setCallingPres(32);
        } else {
            originate.setCallerId(callerID);
        }
        originate.setVariables(myVars);
        originate.setAsync(true);
        originate.setTimeout(localTimeout.intValue());
        try {
            this.startListener();
            response = this.pbx.sendAction(originate, localTimeout);
            logger.info("Originate.sendAction completed");
            if (response.getResponse().compareToIgnoreCase("Success") != 0) {
                logger.error("Error Originating call" + originate.toString() + " : " + response.getMessage());
                throw new ManagerCommunicationException(response.getMessage(), null);
            }
            if (!this.originateLatch.await(localTimeout + 1000, TimeUnit.MILLISECONDS)) {
                logger.error("Originate Latch timed out");
            }
        }
        catch (InterruptedException e) {
            logger.debug(e, e);
        }
        catch (Exception e) {
            logger.error(e, e);
        }
        finally {
            this.close();
        }
        if (this.originateSuccess) {
            this.result.setSuccess(true);
            this.result.setChannelData(this.newChannel);
            logger.info("new channel ok: " + this.newChannel);
        } else {
            logger.warn("originate failed to connect endPoint: " + local + " to ext " + target);
            if (this.newChannel != null) {
                try {
                    logger.warn("Hanging up");
                    this.pbx.hangup(this.newChannel);
                }
                catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                    logger.error(e, e);
                }
            }
        }
        return this.result;
    }

    void abort(String reason) {
        logger.warn("Aborting originate ");
        this.originateSuccess = false;
        this.result.setAbortReason(reason);
        this.hungup = true;
        if (this.newChannel != null) {
            logger.warn("Aborted, Hangup up on the way out");
            this.result.setChannelHungup(true);
            PBX pbx = PBXFactory.getActivePBX();
            try {
                pbx.hangup(this.newChannel);
            }
            catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                logger.error(e, e);
            }
        }
        this.originateLatch.countDown();
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(OriginateResponseEvent.class);
        required.add(BridgeEvent.class);
        required.add(LinkEvent.class);
        required.add(UnlinkEvent.class);
        required.add(HangupEvent.class);
        required.add(NewChannelEvent.class);
        required.add(DialEndEvent.class);
        required.add(DialBeginEvent.class);
        return required;
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        try (Locker.LockCloser closer = this.withLock();){
            String forward;
            Channel channel;
            NewChannelEvent newState;
            this.managerEventsSeen.getAndIncrement();
            if (event instanceof HangupEvent) {
                PBX pbx;
                HangupEvent hangupEvt = (HangupEvent)event;
                Channel hangupChannel = hangupEvt.getChannel();
                if (this.channelId.equals(hangupEvt.getUniqueId())) {
                    this.originateSuccess = false;
                    logger.warn("Dest channel " + this.newChannel + " hungup");
                    this.originateLatch.countDown();
                }
                if (this.monitorChannel1 != null && hangupChannel.isSame(this.monitorChannel1)) {
                    this.originateSuccess = false;
                    this.hungup = true;
                    if (this.newChannel != null) {
                        logger.warn("hanging up " + this.newChannel);
                        this.result.setChannelHungup(true);
                        pbx = PBXFactory.getActivePBX();
                        try {
                            logger.warn("Hanging up");
                            pbx.hangup(this.newChannel);
                        }
                        catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                            logger.error(e, e);
                        }
                    }
                    logger.warn("notify channel 1 hungup");
                    this.originateLatch.countDown();
                }
                if (this.monitorChannel2 != null && hangupChannel.isSame(this.monitorChannel2)) {
                    this.originateSuccess = false;
                    this.hungup = true;
                    if (this.newChannel != null) {
                        logger.warn("Hanging up channel " + this.newChannel);
                        this.result.setChannelHungup(true);
                        pbx = PBXFactory.getActivePBX();
                        try {
                            pbx.hangup(this.newChannel);
                        }
                        catch (IllegalArgumentException | IllegalStateException | PBXException e) {
                            logger.error(e, e);
                        }
                    }
                    logger.warn("Notify channel 2 (" + this.monitorChannel2 + ") hungup");
                    this.originateLatch.countDown();
                }
            }
            if (event instanceof OriginateResponseEvent) {
                logger.debug("response : " + this.newChannel);
                OriginateResponseEvent response = (OriginateResponseEvent)event;
                logger.debug("OriginateResponseEvent: channel=" + (response.isChannel() ? response.getChannel() : response.getEndPoint()) + " originateID:" + this.originateID);
                logger.debug("{" + response.getReason() + ":" + response.getResponse() + "}");
                if (this.originateID != null) {
                    if (this.originateID.compareToIgnoreCase(response.getActionId()) == 0) {
                        this.originateSuccess = response.isSuccess();
                        logger.info("OriginateResponse: matched actionId, success=" + this.originateSuccess + " channelSeen=" + this.channelSeen);
                        this.originateSeen = true;
                        if (this.originateSuccess) {
                            if (this.newChannel == null) {
                                this.newChannel = response.getChannel();
                            }
                            boolean bl = this.channelSeen = this.newChannel != null;
                            if (this.channelSeen) {
                                logger.info("notify originate response event " + this.originateSuccess);
                                this.originateLatch.countDown();
                            } else {
                                logger.error("Originate Response didn't contain the channel");
                            }
                        }
                    }
                } else {
                    logger.warn("actionid is null");
                }
            }
            if (event instanceof NewChannelEvent && this.channelId.equalsIgnoreCase((newState = (NewChannelEvent)event).getChannel().getUniqueId())) {
                channel = newState.getChannel();
                logger.info("new channel event :" + channel + " context = " + newState.getContext() + " state =" + newState.getChannelStateDesc() + " state =" + (Object)((Object)newState.getChannelState()));
                this.handleId(channel);
            }
            if (event instanceof BridgeEvent && ((BridgeEvent)event).isLink()) {
                BridgeEvent bridgeEvent = (BridgeEvent)event;
                channel = bridgeEvent.getChannel1();
                if (bridgeEvent.getChannel1().isLocal()) {
                    channel = bridgeEvent.getChannel2();
                }
                if (this.channelId.equalsIgnoreCase(bridgeEvent.getChannel1().getUniqueId()) || this.channelId.equalsIgnoreCase(bridgeEvent.getChannel2().getUniqueId())) {
                    logger.info("new bridge event :" + channel + " channel1 = " + bridgeEvent.getChannel1() + " channel2 =" + bridgeEvent.getChannel2());
                    this.handleId(channel);
                }
            }
            if (event instanceof DialEndEvent && this.channelId.equalsIgnoreCase(((DialEndEvent)event).getDestChannel().getUniqueId()) && (forward = ((DialEndEvent)event).getForward()) != null && forward.length() > 0) {
                logger.warn("DialEndEvent");
                this.originateLatch.countDown();
            }
        }
    }

    private void handleId(Channel channel) {
        if (this.newChannel == null && !channel.isLocal()) {
            this.newChannel = channel;
            this.channelSeen = true;
            logger.info("new channel name " + channel);
            if (this.listener != null) {
                this.listener.channelUpdate(channel);
            }
            if (this.originateSeen) {
                logger.info("notifying success 362");
                this.originateLatch.countDown();
            }
        }
    }
}

