/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class CharSegment
implements CharSequence {
    protected char[] _buffer;
    protected int _offset;
    protected int _length;

    public CharSegment() {
    }

    public CharSegment(char[] buffer, int offset, int length) {
        this._buffer = buffer;
        this._offset = offset;
        this._length = length;
    }

    public void init(char[] buffer, int offset, int length) {
        this._buffer = buffer;
        this._offset = offset;
        this._length = length;
    }

    public int length() {
        return this._length;
    }

    public int getLength() {
        return this._length;
    }

    public int getOffset() {
        return this._offset;
    }

    public char charAt(int i) {
        if (i < 0 || this._length <= i) {
            throw new IndexOutOfBoundsException();
        }
        return this._buffer[i + this._offset];
    }

    public char getLastChar() {
        if (this._length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this._buffer[this._offset + this._length - 1];
    }

    public char[] getBuffer() {
        return this._buffer;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        srcBegin += this._offset;
        srcEnd += this._offset;
        char[] buffer = this._buffer;
        while (srcBegin < srcEnd) {
            dst[dstBegin++] = buffer[srcBegin++];
        }
    }

    public String substring(int start) {
        if (this._length < start || start < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this._buffer, this._offset + start, this._length - start);
    }

    public String substring(int start, int end) {
        if (this._length < start || start < 0 || end < start) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this._buffer, this._offset + start, end - start);
    }

    public CharSequence subSequence(int start, int end) {
        if (this._length < start || start < 0 || end < start) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this._buffer, this._offset + start, end - start);
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public final int indexOf(char ch, int start) {
        if (start < 0) {
            start = 0;
        }
        int end = this._offset + this._length;
        start += this._offset;
        char[] buffer = this._buffer;
        while (start < end) {
            if (buffer[start] == ch) {
                return start - this._offset;
            }
            ++start;
        }
        return -1;
    }

    public final int lastIndexOf(char ch) {
        return this.lastIndexOf(ch, this._length - 1);
    }

    public final int lastIndexOf(char ch, int start) {
        if (this._length <= start) {
            start = this._length - 1;
        }
        char[] buffer = this._buffer;
        int offset = this._offset;
        while (start >= 0) {
            if (buffer[start + offset] == ch) {
                return start;
            }
            --start;
        }
        return -1;
    }

    public int indexOf(String s) {
        return this.indexOf(s, 0);
    }

    public int indexOf(String s, int start) {
        int slen = s.length();
        if (start < 0) {
            start = 0;
        }
        int end = this._offset + this._length - slen + 1;
        start += this._offset;
        char[] buffer = this._buffer;
        while (start < end) {
            int i;
            for (i = 0; i < slen && buffer[start + i] == s.charAt(i); ++i) {
            }
            if (i == slen) {
                return start - this._offset;
            }
            ++start;
        }
        return -1;
    }

    public int hashCode() {
        int begin;
        int hash = 0;
        char[] buffer = this._buffer;
        int end = begin + this._length;
        for (begin = this._offset; begin < end; ++begin) {
            hash = 65521 * hash + buffer[begin] * 251 + 1021;
        }
        return hash;
    }

    public final boolean equals(Object a) {
        if (this == a) {
            return true;
        }
        if (a instanceof CharSegment) {
            CharSegment cb = (CharSegment)a;
            int length = this._length;
            if (length != cb._length) {
                return false;
            }
            char[] buffer = this._buffer;
            char[] aBuffer = cb._buffer;
            int offset = this._offset;
            int aOffset = cb._offset;
            for (int i = length - 1; i >= 0; --i) {
                if (buffer[offset + i] == aBuffer[aOffset + i]) continue;
                return false;
            }
            return true;
        }
        if (a instanceof CharSequence) {
            CharSequence seq = (CharSequence)a;
            int length = seq.length();
            if (this._length != length) {
                return false;
            }
            for (int i = length - 1; i >= 0; --i) {
                if (this._buffer[i] == seq.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(CharSegment cb) {
        int length = this._length;
        if (length != cb._length) {
            return false;
        }
        char[] buffer = this._buffer;
        char[] aBuffer = cb._buffer;
        int offset = this._offset;
        int aOffset = cb._offset;
        for (int i = length - 1; i >= 0; --i) {
            if (buffer[offset + i] == aBuffer[aOffset + i]) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(char[] cb, int length) {
        if (length != this._length) {
            return false;
        }
        int offset = this._offset;
        char[] buffer = this._buffer;
        for (int i = this._length - 1; i >= 0; --i) {
            if (buffer[offset + i] == cb[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIgnoreCase(String a) {
        int len = a.length();
        if (this._length != len) {
            return false;
        }
        int offset = this._offset;
        char[] buffer = this._buffer;
        for (int i = 0; i < len; ++i) {
            char ca = buffer[offset + i];
            char cb = a.charAt(i);
            if (ca == cb || Character.toLowerCase(ca) == Character.toLowerCase(cb)) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIgnoreCase(CharSegment b) {
        int length = this._length;
        if (length != b._length) {
            return false;
        }
        char[] buffer = this._buffer;
        char[] bBuffer = b._buffer;
        int offset = this._offset;
        int bOffset = b._offset;
        for (int i = length - 1; i >= 0; --i) {
            char ca = buffer[offset + i];
            char cb = bBuffer[bOffset + i];
            if (ca == cb || Character.toLowerCase(ca) == Character.toLowerCase(cb)) continue;
            return false;
        }
        return true;
    }

    public final boolean matches(Object a) {
        if (a instanceof CharSegment) {
            CharSegment cb = (CharSegment)a;
            if (this._length != cb._length) {
                return false;
            }
            int offset = this._offset;
            int bOffset = cb._offset;
            char[] buffer = this._buffer;
            char[] cbBuffer = cb._buffer;
            for (int i = this._length - 1; i >= 0; --i) {
                if (buffer[offset + i] == cbBuffer[bOffset + i]) continue;
                return false;
            }
            return true;
        }
        if (a instanceof String) {
            String sa = (String)a;
            if (this._length != sa.length()) {
                return false;
            }
            int offset = this._offset;
            char[] buffer = this._buffer;
            for (int i = this._length - 1; i >= 0; --i) {
                if (buffer[i + offset] == sa.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matches(String sa) {
        if (this._length != sa.length()) {
            return false;
        }
        char[] buffer = this._buffer;
        int offset = this._offset;
        for (int i = this._length - 1; i >= 0; --i) {
            if (this._buffer[this._offset + i] == sa.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesIgnoreCase(String sa) {
        if (this._length != sa.length()) {
            return false;
        }
        char[] buffer = this._buffer;
        int offset = this._offset;
        for (int i = this._length - 1; i >= 0; --i) {
            char ca = buffer[offset + i];
            char cb = sa.charAt(i);
            if (ca == cb || Character.toLowerCase(ca) == Character.toLowerCase(cb)) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(int off1, CharSegment buf, int off2, int len) {
        if (this._length < off1 + len || buf._length < off2 + len) {
            return false;
        }
        char[] buffer = this._buffer;
        char[] bufBuffer = buf._buffer;
        for (int i = len - 1; i >= 0; --i) {
            if (buffer[off1 + i] == bufBuffer[off2 + i]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(int off1, String buf, int off2, int len) {
        if (this._length < off1 + len || buf.length() < off2 + len) {
            return false;
        }
        char[] buffer = this._buffer;
        for (int i = 0; i < len; ++i) {
            if (buffer[off1 + i] == buf.charAt(off2 + i)) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatchesIgnoreCase(int off1, CharSegment buf, int off2, int len) {
        if (this._length < off1 + len || buf._length < off2 + len) {
            return false;
        }
        char[] buffer = this._buffer;
        char[] bufBuffer = buf._buffer;
        for (int i = len - 1; i >= 0; --i) {
            if (Character.toLowerCase(buffer[off1 + i]) == Character.toLowerCase(bufBuffer[off2 + i])) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string) {
        if (string == null) {
            return false;
        }
        int strlen = string.length();
        if (this._length < strlen) {
            return false;
        }
        char[] buffer = this._buffer;
        int offset = this._offset;
        while (--strlen >= 0) {
            if (buffer[offset + strlen] == string.charAt(strlen)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String string) {
        if (string == null) {
            return false;
        }
        int strlen = string.length();
        if (this._length < strlen) {
            return false;
        }
        char[] buffer = this._buffer;
        int offset = this._offset + this._length - strlen;
        while (--strlen >= 0) {
            if (buffer[offset + strlen] == string.charAt(strlen)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(CharSegment cb) {
        if (cb == null) {
            return false;
        }
        int strlen = cb._length;
        if (this._length < strlen) {
            return false;
        }
        char[] buffer = this._buffer;
        int offset = this._offset + this._length - strlen;
        char[] cbBuffer = cb._buffer;
        int cbOffset = cb._offset;
        while (--strlen >= 0) {
            if (buffer[offset + strlen] == cbBuffer[cbOffset + strlen]) continue;
            return false;
        }
        return true;
    }

    public CharSegment toLowerCase() {
        char[] buffer = this._buffer;
        int len = this._length;
        int offset = this._offset;
        while (--len >= 0) {
            buffer[offset + len] = Character.toLowerCase(buffer[offset + len]);
        }
        return this;
    }

    public String toString() {
        return new String(this._buffer, this._offset, this._length);
    }
}

