/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.logging.Logger;

public class BasicDependencyContainer
implements Dependency {
    private static Logger _log;
    private ArrayList<Dependency> _dependencyList = new ArrayList();
    private boolean _isModified;
    private long _checkInterval = 2000L;
    private long _lastCheckTime = 0L;
    private volatile boolean _isChecking;

    public BasicDependencyContainer add(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't add self as a dependency.");
        }
        if (!this._dependencyList.contains(dependency)) {
            this._dependencyList.add(dependency);
        }
        return this;
    }

    public BasicDependencyContainer remove(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't remove self as a dependency.");
        }
        this._dependencyList.remove(dependency);
        return this;
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = checkInterval < 0L || checkInterval > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : checkInterval;
        this._lastCheckTime = 0L;
    }

    public long getCheckInterval() {
        return this._checkInterval;
    }

    public void setModified(boolean isModified) {
        this._isModified = isModified;
        this._lastCheckTime = 0L;
    }

    public void resetDependencyCheckInterval() {
        this._lastCheckTime = 0L;
    }

    public void clearModified() {
        this._isModified = false;
        this._lastCheckTime = Alarm.getCurrentTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        BasicDependencyContainer basicDependencyContainer = this;
        synchronized (basicDependencyContainer) {
            if (this._isChecking || this._isModified) {
                return this._isModified;
            }
            this._isChecking = true;
        }
        try {
            long now = Alarm.getCurrentTime();
            if (now < this._lastCheckTime + this._checkInterval) {
                boolean bl = this._isModified;
                return bl;
            }
            this._lastCheckTime = now;
            for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
                Dependency dependency = this._dependencyList.get(i);
                if (!dependency.isModified()) continue;
                this.log().fine(dependency + " is modified");
                boolean bl = this._isModified = true;
                return bl;
            }
            boolean bl = this._isModified;
            return bl;
        }
        finally {
            this._isChecking = false;
        }
    }

    public boolean logModified(Logger log) {
        for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
            Dependency dependency = this._dependencyList.get(i);
            if (!dependency.logModified(log)) continue;
            return true;
        }
        return false;
    }

    public boolean isModifiedNow() {
        this._lastCheckTime = 0L;
        return this.isModified();
    }

    private Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(BasicDependencyContainer.class.getName());
        }
        return _log;
    }

    public String toString() {
        return "BasicDependencyContainer" + this._dependencyList;
    }
}

