/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.util.Crc64;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.RandomUtil;
import com.caucho.vfs.ConstPath;
import com.caucho.vfs.Depend;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.HttpsPath;
import com.caucho.vfs.JndiPath;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.RandomAccessStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.SchemeMap;
import com.caucho.vfs.StderrStream;
import com.caucho.vfs.StdoutStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpPath;
import com.caucho.vfs.TcpsPath;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Path {
    protected static final L10N L = new L10N(Path.class);
    private static final Integer LOCK = new Integer(0);
    private static final LruCache<PathKey, Path> _pathLookupCache = new LruCache(8192);
    private static boolean _isTestWindows;
    protected static char _separatorChar;
    protected static char _pathSeparatorChar;
    private static String _newline;
    private static final PathKey _key;
    private static final SchemeMap DEFAULT_SCHEME_MAP;
    private static SchemeMap _defaultSchemeMap;
    protected SchemeMap _schemeMap = _defaultSchemeMap;
    static long _startTime;

    protected Path(Path root) {
        this._schemeMap = root != null ? root._schemeMap : (_defaultSchemeMap != null ? _defaultSchemeMap : DEFAULT_SCHEME_MAP);
    }

    public final Path lookup(String name) {
        return this.lookup(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path lookup(String userPath, Map<String, Object> newAttributes) {
        if (newAttributes != null) {
            return this.lookupImpl(userPath, newAttributes);
        }
        if (userPath == null) {
            return this;
        }
        if (this.isPathCacheable()) {
            PathKey pathKey = _key;
            synchronized (pathKey) {
                _key.init(this, userPath);
                Path path = _pathLookupCache.get(_key);
                if (path != null) {
                    return path.cacheCopy();
                }
            }
        }
        Path path = this.lookupImpl(userPath, null);
        if (_startTime == 0L) {
            _startTime = System.currentTimeMillis();
        }
        if (this.isPathCacheable()) {
            PathKey pathKey = _key;
            synchronized (pathKey) {
                Path copy = path.cacheCopy();
                if (copy != null) {
                    _pathLookupCache.putIfNew(new PathKey(this, userPath), copy);
                }
            }
        }
        return path;
    }

    protected boolean isPathCacheable() {
        return false;
    }

    public Path lookupImpl(String userPath, Map<String, Object> newAttributes) {
        char ch;
        int length;
        if (userPath == null) {
            return this.lookupImpl(this.getPath(), newAttributes);
        }
        String scheme = this.scanScheme(userPath);
        if (scheme == null) {
            return this.schemeWalk(userPath, newAttributes, userPath, 0);
        }
        SchemeMap schemeMap = this._schemeMap;
        if (Path.isWindows() && (length = scheme.length()) == 1 && ('a' <= (ch = scheme.charAt(0)) && ch <= 'z' || 'A' <= ch && ch <= 'Z')) {
            if (_isTestWindows) {
                return this.schemeWalk(userPath, newAttributes, "/" + userPath, 0);
            }
            Path path = schemeMap.get("file");
            if (path != null) {
                return path.schemeWalk(userPath, newAttributes, "/" + userPath, 0);
            }
            return this.schemeWalk(userPath, newAttributes, "/" + userPath, 0);
        }
        Path path = schemeMap.get(scheme);
        if (path == null) {
            return this.schemeWalk(userPath, newAttributes, userPath, 0);
        }
        return path.schemeWalk(userPath, newAttributes, userPath, scheme.length() + 1);
    }

    public final Path lookupNative(String name) {
        return this.lookupNative(name, null);
    }

    public Path lookupNative(String name, Map<String, Object> attributes) {
        return this.lookup(name, attributes);
    }

    public String lookupRelativeNativePath(Path path) {
        String thisNative = this.getNativePath();
        String pathNative = path.getNativePath();
        if (pathNative.startsWith(thisNative)) {
            int i;
            for (i = thisNative.length(); i < pathNative.length() && pathNative.charAt(i) == Path.getFileSeparatorChar(); ++i) {
            }
            return i == pathNative.length() ? "" : pathNative.substring(i);
        }
        return pathNative;
    }

    public ArrayList<Path> getResources(String name) {
        ArrayList<Path> list = new ArrayList<Path>();
        Path path = this.lookup(name);
        if (path.exists()) {
            list.add(path);
        }
        return list;
    }

    public ArrayList<Path> getResources() {
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(this);
        return list;
    }

    public Path getParent() {
        return this;
    }

    protected String scanScheme(String uri) {
        int i = 0;
        if (uri == null) {
            return null;
        }
        int length = uri.length();
        if (length == 0) {
            return null;
        }
        char ch = uri.charAt(0);
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
            for (i = 1; i < length; ++i) {
                ch = uri.charAt(i);
                if (ch == ':') {
                    return uri.substring(0, i).toLowerCase();
                }
                if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '0' || ch == '+' || ch == '-' || ch == '.')) break;
            }
        }
        return null;
    }

    protected abstract Path schemeWalk(String var1, Map<String, Object> var2, String var3, int var4);

    public String getURL() {
        return Path.escapeURL(this.getScheme() + ":" + this.getFullPath());
    }

    public abstract String getScheme();

    public String getHost() {
        throw new UnsupportedOperationException();
    }

    public int getPort() {
        throw new UnsupportedOperationException();
    }

    public abstract String getPath();

    public String getTail() {
        return "";
    }

    public String getQuery() {
        throw new UnsupportedOperationException();
    }

    public String getNativePath() {
        return this.getFullPath();
    }

    public String getUserPath() {
        return this.getPath();
    }

    public void setUserPath(String userPath) {
    }

    public String getFullPath() {
        return this.getPath();
    }

    public String getRelativePath() {
        return this.getPath();
    }

    public boolean isWindowsInsecure() {
        String lower = this.getPath().toLowerCase();
        char lastCh = lower.charAt(lower.length() - 1);
        return lastCh == '.' || lastCh == ' ' || lastCh == '*' || lastCh == '?' || (lastCh == '/' || lastCh == '\\') && !this.isDirectory() || lower.endsWith("::$data") || this.isWindowsSpecial(lower, "/con") || this.isWindowsSpecial(lower, "/aux") || this.isWindowsSpecial(lower, "/prn") || this.isWindowsSpecial(lower, "/nul") || this.isWindowsSpecial(lower, "/com1") || this.isWindowsSpecial(lower, "/com2") || this.isWindowsSpecial(lower, "/com3") || this.isWindowsSpecial(lower, "/com4") || this.isWindowsSpecial(lower, "/lpt1") || this.isWindowsSpecial(lower, "/lpt2") || this.isWindowsSpecial(lower, "/lpt3");
    }

    private boolean isWindowsSpecial(String lower, String test) {
        char ch;
        int testLen;
        int p = lower.indexOf(test);
        if (p < 0) {
            return false;
        }
        int lowerLen = lower.length();
        return lowerLen == p + (testLen = test.length()) || (ch = lower.charAt(p + testLen)) == '/' || ch == '.';
    }

    public Certificate[] getCertificates() {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isLink() {
        return false;
    }

    public boolean isSocket() {
        return false;
    }

    public boolean isFIFO() {
        return false;
    }

    public boolean isBlockDevice() {
        return false;
    }

    public boolean isCharacterDevice() {
        return false;
    }

    public boolean isExecutable() {
        return false;
    }

    public boolean setExecutable(boolean isExecutable) {
        return false;
    }

    public boolean isSymbolicLink() {
        return false;
    }

    public boolean isHardLink() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public void clearStatusCache() {
    }

    public long getLength() {
        return 0L;
    }

    public long getLastModified() {
        return 0L;
    }

    public void setLastModified(long time) {
    }

    public long getLastAccessTime() {
        return this.getLastModified();
    }

    public long getCreateTime() {
        return this.getLastModified();
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public long getDevice() {
        return 0L;
    }

    public long getInode() {
        return 0L;
    }

    public int getMode() {
        return 0;
    }

    public int getNumberOfLinks() {
        return 0;
    }

    public int getUser() {
        return 0;
    }

    public int getGroup() {
        return 0;
    }

    public long getDeviceId() {
        return 0L;
    }

    public long getBlockSize() {
        return 0L;
    }

    public long getBlockCount() {
        return 0L;
    }

    public long getLastStatusChangeTime() {
        return 0L;
    }

    public boolean canExecute() {
        return this.canRead();
    }

    public boolean changeGroup(int gid) throws IOException {
        return false;
    }

    public boolean changeGroup(String groupName) throws IOException {
        return false;
    }

    public boolean chmod(int value) {
        return false;
    }

    public int getOwner() {
        return this.getUser();
    }

    public boolean changeOwner(int uid) throws IOException {
        return false;
    }

    public boolean changeOwner(String ownerName) throws IOException {
        return false;
    }

    public long getDiskSpaceFree() {
        return 0L;
    }

    public long getDiskSpaceTotal() {
        return 0L;
    }

    public String[] list() throws IOException {
        return new String[0];
    }

    public Iterator<String> iterator() throws IOException {
        String[] list = this.list();
        if (list == null) {
            list = new String[]{};
        }
        return new ArrayIterator(list);
    }

    public boolean mkdir() throws IOException {
        return false;
    }

    public boolean mkdirs() throws IOException {
        return false;
    }

    public boolean remove() throws IOException {
        return false;
    }

    public boolean removeAll() throws IOException {
        if (this.isDirectory()) {
            String[] list = this.list();
            for (int i = 0; i < list.length; ++i) {
                Path subpath = this.lookup(list[i]);
                subpath.removeAll();
            }
        }
        return this.remove();
    }

    public boolean truncate() throws IOException {
        return this.truncate(0L);
    }

    public boolean truncate(long length) throws IOException {
        if (length == 0L) {
            if (this.exists()) {
                StreamImpl stream = this.openWriteImpl();
                stream.close();
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(this.getClass().getName() + ": truncate");
    }

    public boolean renameTo(Path path) throws IOException {
        return false;
    }

    public final boolean renameTo(String path) throws IOException {
        return this.renameTo(this.lookup(path));
    }

    public Path createRoot() {
        return this.createRoot(SchemeMap.getNullSchemeMap());
    }

    public Path createRoot(SchemeMap schemeMap) {
        throw new UnsupportedOperationException("createRoot");
    }

    public void bind(Path context) {
        throw new UnsupportedOperationException("bind");
    }

    public void unbind() {
        throw new UnsupportedOperationException("unbind");
    }

    public Object getValue() throws Exception {
        throw new UnsupportedOperationException("getValue");
    }

    public void setValue(Object obj) throws Exception {
        throw new UnsupportedOperationException("setValue");
    }

    public Object getAttribute(String name) throws IOException {
        return null;
    }

    public Iterator getAttributeNames() throws IOException {
        return null;
    }

    public final ReadStream openRead() throws IOException {
        this.clearStatusCache();
        StreamImpl impl = this.openReadImpl();
        impl.setPath(this);
        return new ReadStream(impl);
    }

    public final WriteStream openWrite() throws IOException {
        this.clearStatusCache();
        StreamImpl impl = this.openWriteImpl();
        impl.setPath(this);
        return new WriteStream(impl);
    }

    public ReadWritePair openReadWrite() throws IOException {
        this.clearStatusCache();
        StreamImpl impl = this.openReadWriteImpl();
        impl.setPath(this);
        WriteStream writeStream = new WriteStream(impl);
        ReadStream readStream = new ReadStream(impl, writeStream);
        return new ReadWritePair(readStream, writeStream);
    }

    public void openReadWrite(ReadStream is, WriteStream os) throws IOException {
        this.clearStatusCache();
        StreamImpl impl = this.openReadWriteImpl();
        impl.setPath(this);
        os.init(impl);
        is.init(impl, os);
    }

    public WriteStream openAppend() throws IOException {
        this.clearStatusCache();
        StreamImpl impl = this.openAppendImpl();
        return new WriteStream(impl);
    }

    public RandomAccessStream openRandomAccess() throws IOException {
        this.clearStatusCache();
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewFile() throws IOException {
        Integer n = LOCK;
        synchronized (n) {
            if (!this.exists()) {
                WriteStream s = this.openWrite();
                s.close();
                return true;
            }
        }
        return false;
    }

    public PersistentDependency createDepend() {
        return new Depend(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path createTempFile(String prefix, String suffix) throws IOException {
        if (prefix == null || prefix.length() == 0) {
            prefix = "t";
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        Integer n = LOCK;
        synchronized (n) {
            for (int i = 0; i < 32768; ++i) {
                int r = Math.abs((int)RandomUtil.getRandomLong());
                Path file = this.lookup(prefix + r + suffix);
                if (!file.createNewFile()) continue;
                return file;
            }
        }
        throw new IOException("cannot create temp file");
    }

    public boolean createLink(Path target, boolean hardLink) throws IOException {
        throw new UnsupportedOperationException(this.getScheme() + ": doesn't support createLink");
    }

    public String readLink() {
        return null;
    }

    public String realPath() {
        return this.getFullPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(OutputStream os) throws IOException {
        StreamImpl is = this.openReadImpl();
        TempBuffer tempBuffer = TempBuffer.allocate();
        try {
            int len;
            byte[] buffer = tempBuffer.getBuffer();
            int length = buffer.length;
            while ((len = is.read(buffer, 0, length)) > 0) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            TempBuffer.free(tempBuffer);
            tempBuffer = null;
            is.close();
        }
    }

    public void writeToStream(OutputStreamWithBuffer os) throws IOException {
        StreamImpl is = this.openReadImpl();
        try {
            byte[] buffer = os.getBuffer();
            int offset = os.getBufferOffset();
            int length = buffer.length;
            while (true) {
                int sublen;
                if ((sublen = length - offset) <= 0) {
                    buffer = os.nextBuffer(offset);
                    offset = 0;
                    sublen = length;
                }
                if ((sublen = is.read(buffer, offset, sublen)) <= 0) {
                    os.setBufferOffset(offset);
                    return;
                }
                offset += sublen;
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getCrc64() {
        if (this.isDirectory()) {
            String[] list = this.list();
            long digest = 0L;
            for (int i = 0; i < list.length; ++i) {
                digest = Crc64.generate(digest, list[i]);
            }
            return digest;
        }
        if (!this.canRead()) return -1L;
        ReadStream is = this.openRead();
        try {
            long digest = 0L;
            byte[] buffer = is.getBuffer();
            while (is.fillBuffer() > 0) {
                int length = is.getLength();
                digest = Crc64.generate(digest, buffer, 0, length);
            }
            long l = digest;
            is.close();
            return l;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1L;
            }
        }
    }

    public Object getObject() throws IOException {
        throw new UnsupportedOperationException(this.getScheme() + ": doesn't support getObject");
    }

    public void setObject(Object obj) throws IOException {
        throw new UnsupportedOperationException(this.getScheme() + ": doesn't support setObject");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        return this.getURL().equals(((Path)o).getURL());
    }

    public String toString() {
        return this.getFullPath();
    }

    public StreamImpl openReadImpl() throws IOException {
        throw new UnsupportedOperationException("openRead:" + this.getClass().getName());
    }

    public StreamImpl openWriteImpl() throws IOException {
        throw new UnsupportedOperationException("openWrite:" + this.getClass().getName());
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        throw new UnsupportedOperationException("openReadWrite:" + this.getClass().getName());
    }

    public StreamImpl openAppendImpl() throws IOException {
        throw new UnsupportedOperationException("openAppend:" + this.getClass().getName());
    }

    protected static String escapeURL(String rawURL) {
        CharBuffer cb = null;
        int length = rawURL.length();
        block5: for (int i = 0; i < length; ++i) {
            char ch = rawURL.charAt(i);
            switch (ch) {
                case ' ': {
                    if (cb == null) {
                        cb = new CharBuffer();
                        cb.append(rawURL, 0, i);
                    }
                    cb.append("%20");
                    continue block5;
                }
                case '#': {
                    if (cb == null) {
                        cb = new CharBuffer();
                        cb.append(rawURL, 0, i);
                    }
                    cb.append("%23");
                    continue block5;
                }
                case '%': {
                    if (cb == null) {
                        cb = new CharBuffer();
                        cb.append(rawURL, 0, i);
                    }
                    cb.append("%25");
                    continue block5;
                }
                default: {
                    if (cb == null) continue block5;
                    cb.append(ch);
                }
            }
        }
        if (cb != null) {
            return cb.toString();
        }
        return rawURL;
    }

    protected Path copy() {
        return this;
    }

    protected Path cacheCopy() {
        return this;
    }

    public static final void setDefaultSchemeMap(SchemeMap schemeMap) {
        _defaultSchemeMap = schemeMap;
        _pathLookupCache.clear();
    }

    public static final boolean isWindows() {
        return _separatorChar == '\\' || _isTestWindows;
    }

    public static final void setTestWindows(boolean isTest) {
        _isTestWindows = isTest;
    }

    protected static final char getSeparatorChar() {
        return _separatorChar;
    }

    public static final char getFileSeparatorChar() {
        return _separatorChar;
    }

    public static final char getPathSeparatorChar() {
        return _pathSeparatorChar;
    }

    protected static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getNewlineString() {
        if (_newline == null && (_newline = System.getProperty("line.separator")) == null) {
            _newline = "\n";
        }
        return _newline;
    }

    static {
        _separatorChar = File.separatorChar;
        _pathSeparatorChar = File.pathSeparatorChar;
        _key = new PathKey();
        DEFAULT_SCHEME_MAP = new SchemeMap();
        DEFAULT_SCHEME_MAP.put("file", new FilePath(null));
        DEFAULT_SCHEME_MAP.put("http", new HttpPath("127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("https", new HttpsPath("127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("tcp", new TcpPath(null, null, null, "127.0.0.1", 0));
        DEFAULT_SCHEME_MAP.put("tcps", new TcpsPath(null, null, null, "127.0.0.1", 0));
        StdoutStream stdout = StdoutStream.create();
        StderrStream stderr = StderrStream.create();
        DEFAULT_SCHEME_MAP.put("stdout", stdout.getPath());
        DEFAULT_SCHEME_MAP.put("stderr", stderr.getPath());
        VfsStream nullStream = new VfsStream(null, null);
        DEFAULT_SCHEME_MAP.put("null", new ConstPath(null, nullStream));
        DEFAULT_SCHEME_MAP.put("jndi", new JndiPath());
    }

    static class PathKey {
        private Path _parent;
        private String _lookup;

        PathKey() {
        }

        PathKey(Path parent, String lookup) {
            this._parent = parent;
            this._lookup = lookup;
        }

        void init(Path parent, String lookup) {
            this._parent = parent;
            this._lookup = lookup;
        }

        public int hashCode() {
            if (this._parent != null) {
                return this._parent.hashCode() * 65521 + this._lookup.hashCode();
            }
            return this._lookup.hashCode();
        }

        public boolean equals(Object test) {
            if (!(test instanceof PathKey)) {
                return false;
            }
            PathKey key = (PathKey)test;
            if (this._parent != null) {
                return this._parent.equals(key._parent) && this._lookup.equals(key._lookup);
            }
            return key._parent == null && this._lookup.equals(key._lookup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayIterator
    implements Iterator<String> {
        String[] list;
        int index;

        @Override
        public boolean hasNext() {
            return this.index < this.list.length;
        }

        @Override
        public String next() {
            return this.index < this.list.length ? this.list[this.index++] : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        ArrayIterator(String[] list) {
            this.list = list;
            this.index = 0;
        }
    }
}

