/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.NullPath;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InterruptedIOException;

public class PipeStream
extends StreamImpl {
    private PipeStream sibling;
    private byte[] readBuffer;
    private int readOffset;
    private int readLength;

    private PipeStream() {
        this.setPath(new NullPath("pipe"));
        this.readBuffer = new byte[2 * TempBuffer.SIZE];
        this.readOffset = 0;
        this.readLength = 0;
    }

    public static Object[] create() {
        PipeStream b;
        PipeStream a = new PipeStream();
        a.sibling = b = new PipeStream();
        b.sibling = a;
        return new Object[]{new ReadStream(a, null), new WriteStream(b)};
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this.readBuffer == null) {
            return 0;
        }
        PipeStream pipeStream = this;
        synchronized (pipeStream) {
            try {
                int sublen;
                if (this.readOffset >= this.readLength) {
                    if (this.sibling.readBuffer == null) {
                        return 0;
                    }
                    this.notifyAll();
                    this.wait();
                }
                if ((sublen = this.readLength - this.readOffset) <= 0) {
                    return 0;
                }
                if (length < sublen) {
                    sublen = length;
                }
                System.arraycopy(this.readBuffer, this.readOffset, buf, offset, sublen);
                this.readOffset += sublen;
                return sublen;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable() throws IOException {
        PipeStream pipeStream = this;
        synchronized (pipeStream) {
            return this.readLength - this.readOffset;
        }
    }

    public boolean canWrite() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        while (length > 0) {
            PipeStream pipeStream = this.sibling;
            synchronized (pipeStream) {
                if (this.sibling.readBuffer == null) {
                    return;
                }
                if (this.sibling.readLength == this.sibling.readBuffer.length) {
                    if (this.sibling.readOffset < this.sibling.readLength) {
                        try {
                            this.sibling.wait();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException(e.getMessage());
                        }
                    }
                    this.sibling.readOffset = 0;
                    this.sibling.readLength = 0;
                }
                if (this.sibling.readOffset == this.sibling.readLength) {
                    this.sibling.readOffset = 0;
                    this.sibling.readLength = 0;
                }
                if (this.sibling.readBuffer == null) {
                    return;
                }
                int sublen = this.sibling.readBuffer.length - this.sibling.readLength;
                if (length < sublen) {
                    sublen = length;
                }
                System.arraycopy(buf, offset, this.sibling.readBuffer, this.sibling.readLength, sublen);
                this.sibling.readLength += sublen;
                length -= sublen;
                offset += sublen;
                this.sibling.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.readBuffer == null) {
            return;
        }
        PipeStream pipeStream = this;
        synchronized (pipeStream) {
            this.readBuffer = null;
            this.readLength = 0;
            this.readOffset = 0;
            this.notifyAll();
        }
        pipeStream = this.sibling;
        synchronized (pipeStream) {
            this.sibling.notifyAll();
        }
    }
}

