/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class StringWriter
extends StreamImpl {
    private WriteStream ws;
    private CharBuffer cb;

    public StringWriter() {
    }

    public StringWriter(CharBuffer cb) {
        this.cb = cb;
    }

    public WriteStream openWrite() {
        if (this.cb != null) {
            this.cb.clear();
        } else {
            this.cb = CharBuffer.allocate();
        }
        if (this.ws == null) {
            this.ws = new WriteStream(this);
        } else {
            this.ws.init(this);
        }
        try {
            this.ws.setEncoding("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.ws;
    }

    public String getString() {
        try {
            this.ws.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String str = this.cb.close();
        this.cb = null;
        return str;
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        int end = offset + length;
        while (offset < end) {
            int ch2;
            int ch1;
            if ((ch1 = buf[offset++] & 0xFF) < 128) {
                this.cb.append((char)ch1);
                continue;
            }
            if ((ch1 & 0xE0) == 192) {
                if (offset >= end) {
                    throw new EOFException("unexpected end of file in utf8 character");
                }
                if (((ch2 = buf[offset++] & 0xFF) & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                this.cb.append((char)(((ch1 & 0x1F) << 6) + (ch2 & 0x3F)));
                continue;
            }
            if ((ch1 & 0xF0) == 224) {
                if (offset + 1 >= end) {
                    throw new EOFException("unexpected end of file in utf8 character");
                }
                ch2 = buf[offset++] & 0xFF;
                int ch3 = buf[offset++] & 0xFF;
                if ((ch2 & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                if ((ch3 & 0xC0) != 128) {
                    throw new CharConversionException("illegal utf8 encoding");
                }
                this.cb.append((char)(((ch1 & 0x1F) << 12) + ((ch2 & 0x3F) << 6) + (ch3 & 0x3F)));
                continue;
            }
            throw new CharConversionException("illegal utf8 encoding at (" + ch1 + ")");
        }
    }
}

