/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.NumberValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.ValueType;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleValue
extends NumberValue
implements Serializable {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    private final double _value;

    public DoubleValue(double value) {
        this._value = value;
    }

    public static DoubleValue create(double value) {
        return new DoubleValue(value);
    }

    public static Value create(Number value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return new DoubleValue(value.doubleValue());
    }

    @Override
    public String getType() {
        return "double";
    }

    @Override
    public ValueType getValueType() {
        return ValueType.DOUBLE;
    }

    @Override
    public boolean isDoubleConvertible() {
        return true;
    }

    @Override
    public boolean isLongConvertible() {
        return this._value == (double)((long)this._value);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean toBoolean() {
        return this._value != 0.0;
    }

    @Override
    public long toLong() {
        if (this._value > 9.223372036854776E18 || this._value < -9.223372036854776E18) {
            return 0L;
        }
        return (long)this._value;
    }

    @Override
    public double toDouble() {
        return this._value;
    }

    @Override
    public DoubleValue toDoubleValue() {
        return this;
    }

    @Override
    public StringValue toStringBuilder(Env env) {
        return env.createUnicodeBuilder().append(this.toString());
    }

    @Override
    public Value toKey() {
        return LongValue.create((long)this._value);
    }

    @Override
    public Object toJavaObject() {
        return new Double(this._value);
    }

    @Override
    public Value neg() {
        return new DoubleValue(-this._value);
    }

    @Override
    public Value pos() {
        return this;
    }

    @Override
    public Value add(Value rValue) {
        return new DoubleValue(this._value + rValue.toDouble());
    }

    @Override
    public Value add(long lValue) {
        return new DoubleValue((double)lValue + this._value);
    }

    @Override
    public Value preincr(int incr) {
        return new DoubleValue(this._value + (double)incr);
    }

    @Override
    public Value postincr(int incr) {
        return new DoubleValue(this._value + (double)incr);
    }

    @Override
    public Value mul(Value rValue) {
        return new DoubleValue(this._value * rValue.toDouble());
    }

    @Override
    public Value mul(long lValue) {
        return new DoubleValue((double)lValue * this._value);
    }

    @Override
    public boolean eql(Value rValue) {
        if (!((rValue = rValue.toValue()) instanceof DoubleValue)) {
            return false;
        }
        double rDouble = ((DoubleValue)rValue)._value;
        return this._value == rDouble;
    }

    public String toString() {
        long longValue = (long)this._value;
        if ((double)longValue == this._value) {
            return String.valueOf(longValue);
        }
        return String.valueOf(this._value);
    }

    public Object toObject() {
        return this.toString();
    }

    @Override
    public void print(Env env) {
        env.print(this.toString());
    }

    @Override
    public void serialize(Env env, StringBuilder sb) {
        sb.append("d:");
        sb.append(this._value);
        sb.append(";");
    }

    @Override
    public void varExport(StringBuilder sb) {
        sb.append(this.toString());
    }

    @Override
    public void generate(PrintWriter out) throws IOException {
        if (this._value == 0.0) {
            out.print("DoubleValue.ZERO");
        } else {
            out.print("new DoubleValue(" + this._value + ")");
        }
    }

    public int hashCode() {
        return (int)(37.0 + 65521.0 * this._value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleValue)) {
            return false;
        }
        DoubleValue value = (DoubleValue)o;
        return this._value == value._value;
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print("float(" + this.toString() + ")");
    }

    private Object readResolve() {
        if (this._value == 0.0) {
            return ZERO;
        }
        return this;
    }
}

