/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalArrayValue
extends ArrayValueImpl {
    private final Env _env;

    public GlobalArrayValue(Env env) {
        this._env = env;
    }

    @Override
    public Object toObject() {
        return null;
    }

    @Override
    public ArrayValue append(Value key, Value value) {
        this._env.setGlobalValue(key.toString(), value);
        return this;
    }

    @Override
    public Value get(Value key) {
        return this._env.getGlobalValue(key.toString());
    }

    @Override
    public Var getRef(Value key) {
        return this._env.getGlobalRef(key.toString());
    }

    @Override
    public Value getArg(Value index) {
        return this.getRef(index);
    }

    @Override
    public Value remove(Value key) {
        return this._env.unsetGlobalVar(key.toString());
    }

    @Override
    public Value copy() {
        return this;
    }

    @Override
    public int getSize() {
        return this._env.getGlobalEnv().size();
    }

    @Override
    public void print(Env env) {
        env.print("Array");
    }

    @Override
    public Set<Map.Entry<Value, Value>> entrySet() {
        return this.createAndFillArray().entrySet();
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        return this.createAndFillArray().getIterator(env);
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        return this.createAndFillArray().getKeyIterator(env);
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        return this.createAndFillArray().getValueIterator(env);
    }

    private ArrayValue createAndFillArray() {
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry<String, Var> entry : this._env.getGlobalEnv().entrySet()) {
            StringValue key = this._env.createString(entry.getKey());
            Value val = entry.getValue().toValue();
            array.put(key, val);
        }
        return array;
    }
}

