/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.QuercusException;
import com.caucho.quercus.annotation.Name;
import com.caucho.quercus.env.JavaInvoker;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.util.L10N;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JavaMethod
extends JavaInvoker {
    private static final L10N L = new L10N(JavaMethod.class);
    private final Method _method;

    public JavaMethod(ModuleContext moduleContext, Method method) {
        super(moduleContext, JavaMethod.getName(method), method.getParameterTypes(), method.getParameterAnnotations(), method.getAnnotations(), method.getReturnType());
        this._method = method;
        this._method.setAccessible(true);
    }

    private static String getName(Method method) {
        Name nameAnn = method.getAnnotation(Name.class);
        String name = nameAnn != null ? nameAnn.value() : method.getName();
        return name;
    }

    public Method getMethod() {
        return this._method;
    }

    public Class[] getJavaParameterTypes() {
        return this._method.getParameterTypes();
    }

    public Class getJavaDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    public Object invoke(Object obj, Object[] args) {
        try {
            return this._method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getCause();
            String methodName = this._method.getDeclaringClass().getName() + "." + this._method.getName();
            throw new QuercusException(methodName + ": " + e1.getMessage(), e1);
        }
        catch (Exception e) {
            String methodName = this._method.getDeclaringClass().getName() + "." + this._method.getName();
            throw new QuercusException(methodName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "JavaMethod[" + this._method + "]";
    }
}

