/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArgGetFieldValue;
import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.CopyObjectExtValue;
import com.caucho.quercus.env.CopyRoot;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.RefVar;
import com.caucho.quercus.env.SerializeMap;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.StringLiteralExpr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectExtValue
extends ObjectValue
implements Serializable {
    private static final StringValue TO_STRING = new StringBuilderValue("__toString");
    private static final int DEFAULT_SIZE = 16;
    private MethodMap<AbstractFunction> _methodMap;
    private Entry[] _entries;
    private int _hashMask;
    private int _size;
    private boolean _isFieldInit;

    public ObjectExtValue(QuercusClass cl) {
        super(cl);
        this._methodMap = cl.getMethodMap();
        this._entries = new Entry[16];
        this._hashMask = this._entries.length - 1;
    }

    public ObjectExtValue(Env env, ObjectExtValue copy, CopyRoot root) {
        super(copy.getQuercusClass());
        this._methodMap = copy._methodMap;
        this._size = copy._size;
        this._isFieldInit = copy._isFieldInit;
        Entry[] copyEntries = copy._entries;
        this._entries = new Entry[copyEntries.length];
        this._hashMask = copy._hashMask;
        int len = copyEntries.length;
        for (int i = 0; i < len; ++i) {
            Entry entry = copyEntries[i];
            while (entry != null) {
                Entry entryCopy = entry.copyTree(env, root);
                entryCopy._next = this._entries[i];
                if (this._entries[i] != null) {
                    this._entries[i]._prev = entryCopy;
                }
                this._entries[i] = entryCopy;
                entry = entry._next;
            }
        }
        this._incompleteObjectName = copy._incompleteObjectName;
    }

    private void init() {
        this._entries = new Entry[16];
        this._hashMask = this._entries.length - 1;
        this._size = 0;
    }

    @Override
    protected void setQuercusClass(QuercusClass cl) {
        super.setQuercusClass(cl);
        this._methodMap = cl.getMethodMap();
    }

    @Override
    public void initObject(Env env, QuercusClass cls) {
        this.setQuercusClass(cls);
        Entry[] entries = this._entries;
        this._entries = new Entry[this._entries.length];
        this._hashMask = this._entries.length - 1;
        this._size = 0;
        cls.initObject(env, this);
        EntryIterator iter = new EntryIterator(entries);
        while (iter.hasNext()) {
            Entry newField = iter.next();
            Entry entry = this.getEntry(newField._key);
            if (entry != null) {
                entry._value = newField._value;
                continue;
            }
            this.initField(newField._key, newField._value, newField._visibility);
        }
    }

    @Override
    public int getSize() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Value getField(Env env, StringValue name) {
        int hash = name.hashCode() & this._hashMask;
        Entry entry = this._entries[hash];
        while (entry != null) {
            if (name.equals(entry._key)) {
                QuercusClass cls;
                if (entry._visibility == FieldVisibility.PRIVATE && (cls = env.getCallingClass()) != this._quercusClass) {
                    env.error(L.l("Can't access private field '{0}::${1}'", (Object)this._quercusClass.getName(), (Object)name));
                }
                return entry._value.toValue();
            }
            entry = entry._next;
        }
        if (!env.pushFieldGet(this._className, name)) {
            return NullValue.NULL;
        }
        try {
            Value value = this.getFieldExt(env, name);
            return value;
        }
        finally {
            env.popFieldGet(this._className, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getThisField(Env env, StringValue name) {
        int hash = name.hashCode() & this._hashMask;
        Entry entry = this._entries[hash];
        while (entry != null) {
            if (name.equals(entry._key)) {
                return entry._value.toValue();
            }
            entry = entry._next;
        }
        if (!env.pushFieldGet(this._className, name)) {
            return NullValue.NULL;
        }
        try {
            Value value = this.getFieldExt(env, name);
            return value;
        }
        finally {
            env.popFieldGet(this._className, name);
        }
    }

    protected Value getFieldExt(Env env, StringValue name) {
        return this._quercusClass.getField(env, this, name);
    }

    @Override
    public Var getFieldRef(Env env, StringValue name) {
        Entry entry = this.createEntry(name, FieldVisibility.PUBLIC);
        Value value = entry._value;
        if (value instanceof Var) {
            return (Var)value;
        }
        Var var = new Var(value);
        entry.setValue(var);
        return var;
    }

    @Override
    public Var getThisFieldRef(Env env, StringValue name) {
        Entry entry = this.createEntry(name, FieldVisibility.PUBLIC);
        Value value = entry._value;
        if (value instanceof Var) {
            return (Var)value;
        }
        Var var = new Var(value);
        entry.setValue(var);
        return var;
    }

    @Override
    public Value getFieldArg(Env env, StringValue name) {
        Entry entry = this.getEntry(name);
        if (entry != null) {
            return entry.toArg();
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value getThisFieldArg(Env env, StringValue name) {
        Entry entry = this.getEntry(name);
        if (entry != null) {
            return entry.toArg();
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value getFieldArgRef(Env env, StringValue name) {
        Entry entry = this.getEntry(name);
        if (entry != null) {
            return entry.toArg();
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value getThisFieldArgRef(Env env, StringValue name) {
        Entry entry = this.getEntry(name);
        if (entry != null) {
            return entry.toArg();
        }
        return new ArgGetFieldValue(env, this, name);
    }

    @Override
    public Value putField(Env env, StringValue name, Value value) {
        Value oldValue;
        Entry entry = this.getEntry(name);
        if (entry == null) {
            AbstractFunction fieldSet;
            oldValue = this.putFieldExt(env, name, value);
            if (oldValue != null) {
                return oldValue;
            }
            if (!this._isFieldInit && (fieldSet = this._quercusClass.getFieldSet()) != null) {
                this._isFieldInit = true;
                Value retVal = fieldSet.callMethod(env, this, name, value);
                this._isFieldInit = false;
                return retVal;
            }
        }
        entry = this.createEntry(name, FieldVisibility.PUBLIC);
        oldValue = entry._value;
        if (value instanceof Var) {
            Var var = (Var)value;
            var.setReference();
            entry._value = var;
        } else if (oldValue instanceof Var) {
            oldValue.set(value);
        } else {
            entry._value = value;
        }
        return value;
    }

    @Override
    public Value putThisField(Env env, StringValue name, Value value) {
        Value oldValue;
        Entry entry = this.getEntry(name);
        if (entry == null) {
            AbstractFunction fieldSet;
            oldValue = this.putFieldExt(env, name, value);
            if (oldValue != null) {
                return oldValue;
            }
            if (!this._isFieldInit && (fieldSet = this._quercusClass.getFieldSet()) != null) {
                this._isFieldInit = true;
                Value retVal = fieldSet.callMethod(env, this, name, value);
                this._isFieldInit = false;
                return retVal;
            }
        }
        entry = this.createEntry(name, FieldVisibility.PUBLIC);
        oldValue = entry._value;
        if (value instanceof Var) {
            Var var = (Var)value;
            var.setReference();
            entry._value = var;
        } else if (oldValue instanceof Var) {
            oldValue.set(value);
        } else {
            entry._value = value;
        }
        return value;
    }

    protected Value putFieldExt(Env env, StringValue name, Value value) {
        return null;
    }

    @Override
    public void initField(StringValue key, Value value, FieldVisibility visibility) {
        Entry entry = this.createEntry(key, visibility);
        entry._value = value;
    }

    @Override
    public void unsetField(StringValue name) {
        int hash = name.hashCode() & this._hashMask;
        Entry entry = this._entries[hash];
        while (entry != null) {
            if (name.equals(entry.getKey())) {
                Entry prev = entry._prev;
                Entry next = entry._next;
                if (prev != null) {
                    prev._next = next;
                } else {
                    this._entries[hash] = next;
                }
                if (next != null) {
                    next._prev = prev;
                }
                --this._size;
                return;
            }
            entry = entry._next;
        }
    }

    private Entry getEntry(StringValue name) {
        int hash = name.hashCode() & this._hashMask;
        Entry entry = this._entries[hash];
        while (entry != null) {
            if (name.equals(entry._key)) {
                return entry;
            }
            entry = entry._next;
        }
        return null;
    }

    private Entry createEntry(StringValue name, FieldVisibility visibility) {
        int hash = name.hashCode() & this._hashMask;
        Entry entry = this._entries[hash];
        while (entry != null) {
            if (name.equals(entry._key)) {
                return entry;
            }
            entry = entry._next;
        }
        ++this._size;
        Entry newEntry = new Entry(name, visibility);
        Entry next = this._entries[hash];
        if (next != null) {
            newEntry._next = next;
            next._prev = newEntry;
        }
        this._entries[hash] = newEntry;
        return newEntry;
    }

    @Override
    public Value get(Value key) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.get(this, key);
        }
        return super.get(key);
    }

    @Override
    public Value put(Value key, Value value) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.put(this, key, value);
        }
        return super.put(key, value);
    }

    @Override
    public Value put(Value value) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.put(this, value);
        }
        return super.put(value);
    }

    @Override
    public Value remove(Value key) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.unset(this, key);
        }
        return super.remove(key);
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getIterator(env, this);
        }
        return new KeyValueIterator(this._entries);
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getKeyIterator(env, this);
        }
        return new KeyIterator(this._entries);
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getValueIterator(env, this);
        }
        return new ValueIterator(this._entries);
    }

    @Override
    public AbstractFunction findFunction(String methodName) {
        return this._quercusClass.findFunction(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, (Value)this, args);
                return value;
            }
            if (this._quercusClass.getCall() != null) {
                Expr[] newArgs = new Expr[args.length + 1];
                newArgs[0] = new StringLiteralExpr(ObjectExtValue.toMethod(name, nameLen));
                System.arraycopy(args, 0, newArgs, 1, args.length);
                Value value = this._quercusClass.getCall().callMethod(env, (Value)this, newArgs);
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value[] args) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, (Value)this, args);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethod(env, this, env.createString(name, nameLen), new ArrayValueImpl(args));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, this);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethod(env, this, env.createString(name, nameLen), new ArrayValueImpl());
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, (Value)this, a1);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethod(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, this, a1, a2);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethod(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, this, a1, a2, a3);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethod(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, this, a1, a2, a3, a4);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethod(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethod(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethod(env, this, a1, a2, a3, a4, a5);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethod(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4).append(a5));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Expr[] args) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            Value value = this._quercusClass.callMethodRef(env, (Value)this, hash, name, nameLen, args);
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value[] args) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, (Value)this, args);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, env.createString(name, nameLen), new ArrayValueImpl(args));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, this);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, env.createString(name, nameLen), new ArrayValueImpl());
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, (Value)this, a1);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, a1, a2);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, a1, a2, a3);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, a1, a2, a3, a4);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callMethodRef(Env env, int hash, char[] name, int nameLen, Value a1, Value a2, Value a3, Value a4, Value a5) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._methodMap.get(hash, name, nameLen);
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, a1, a2, a3, a4, a5);
                return value;
            }
            fun = this._quercusClass.getCall();
            if (fun != null) {
                Value value = fun.callMethodRef(env, this, env.createString(name, nameLen), new ArrayValueImpl().append(a1).append(a2).append(a3).append(a4).append(a5));
                return value;
            }
            Value value = env.error(L.l("Call to undefined method {0}::{1}()", (Object)this.getName(), (Object)ObjectExtValue.toMethod(name, nameLen)));
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value callClassMethod(Env env, AbstractFunction fun, Value[] args) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            Value value = fun.callMethod(env, (Value)this, args);
            return value;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    @Override
    public Value getObject(Env env) {
        return this;
    }

    @Override
    public Value getObject(Env env, Value index) {
        env.error(L.l("Can't use object '{0}' as array", (Object)this.getName()));
        return NullValue.NULL;
    }

    @Override
    public Value copy() {
        return this;
    }

    @Override
    public Value copy(Env env, IdentityHashMap<Value, Value> map) {
        Value oldValue = map.get(this);
        if (oldValue != null) {
            return oldValue;
        }
        return this;
    }

    @Override
    public Value copyTree(Env env, CopyRoot root) {
        return new CopyObjectExtValue(env, this, root);
    }

    @Override
    public Value clone() {
        ObjectExtValue newObject = new ObjectExtValue(this._quercusClass);
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            newObject.putThisField(null, (StringValue)entry.getKey(), entry.getValue());
        }
        return newObject;
    }

    @Override
    public void serialize(Env env, StringBuilder sb, SerializeMap serializeMap) {
        Integer index = serializeMap.get(this);
        if (index != null) {
            sb.append("r:");
            sb.append(index);
            sb.append(";");
            return;
        }
        serializeMap.put(this);
        serializeMap.incrementIndex();
        sb.append("O:");
        sb.append(this._className.length());
        sb.append(":\"");
        sb.append(this._className);
        sb.append("\":");
        sb.append(this.getSize());
        sb.append(":{");
        EntryIterator iter = new EntryIterator(this._entries);
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            sb.append("s:");
            Value key = entry.getKey();
            int len = key.length();
            if (entry._visibility == FieldVisibility.PROTECTED) {
                sb.append(len + 3);
                sb.append(":\"");
                sb.append("\u0000*\u0000");
            } else if (entry._visibility == FieldVisibility.PRIVATE) {
                sb.append(len + 3);
                sb.append(":\"");
                sb.append("\u0000A\u0000");
            } else {
                sb.append(len);
                sb.append(":\"");
            }
            sb.append(key);
            sb.append("\";");
            Value value = entry.getRawValue();
            value.serialize(env, sb, serializeMap);
        }
        sb.append("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringValue toString(Env env) {
        QuercusClass oldClass = env.setCallingClass(this._quercusClass);
        try {
            AbstractFunction fun = this._quercusClass.findFunction("__toString");
            if (fun != null) {
                StringValue stringValue = fun.callMethod(env, (Value)this, new Expr[0]).toStringValue();
                return stringValue;
            }
            StringValue stringValue = env.createString(this._className + "[]");
            return stringValue;
        }
        finally {
            env.setCallingClass(oldClass);
        }
    }

    @Override
    public void print(Env env) {
        env.print(this.toString(env));
    }

    @Override
    public Value toArray() {
        ArrayValueImpl array = new ArrayValueImpl();
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            array.put(entry.getKey(), entry.getValue());
        }
        return array;
    }

    @Override
    public Value toObject(Env env) {
        return this;
    }

    @Override
    public Object toJavaObject() {
        return this;
    }

    @Override
    public Set<? extends Map.Entry<Value, Value>> entrySet() {
        return new EntrySet();
    }

    public Set<? extends Map.Entry<Value, Value>> sortedEntrySet() {
        return new TreeSet<Map.Entry<Value, Value>>(this.entrySet());
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        int size = this.getSize();
        if (this.isIncompleteObject()) {
            ++size;
        }
        out.println("object(" + this.getName() + ") (" + size + ") {");
        if (this.isIncompleteObject()) {
            this.printDepth(out, 2 * (depth + 1));
            out.println("[\"__Quercus_Incomplete_Class_name\"]=>");
            this.printDepth(out, 2 * (depth + 1));
            StringValue value = env.createString(this.getIncompleteObjectName());
            value.varDump(env, out, depth + 1, valueSet);
            out.println();
        }
        for (Map.Entry<Value, Value> entry : this.sortedEntrySet()) {
            Entry entry2 = (Entry)entry;
            entry2.varDumpImpl(env, out, depth + 1, valueSet);
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }

    @Override
    protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print(this.getName());
        out.print(' ');
        out.println("Object");
        this.printDepth(out, 4 * depth);
        out.println("(");
        for (Map.Entry<Value, Value> entry : this.sortedEntrySet()) {
            Entry entry2 = (Entry)entry;
            entry2.printRImpl(env, out, depth + 1, valueSet);
        }
        this.printDepth(out, 4 * depth);
        out.println(")");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._className);
        out.writeInt(this._size);
        for (Map.Entry<Value, Value> entry : this.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Env env = Env.getInstance();
        String name = (String)in.readObject();
        QuercusClass cl = env.findClass(name);
        this.init();
        if (cl != null) {
            this.setQuercusClass(cl);
        } else {
            cl = env.getQuercus().getStdClass();
            this.setQuercusClass(cl);
            this.setIncompleteObjectName(name);
        }
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.putThisField(env, (StringValue)in.readObject(), (Value)in.readObject());
        }
    }

    public void cleanup(Env env) {
        AbstractFunction fun = this.getQuercusClass().getDestructor();
        if (fun != null) {
            fun.callMethod(env, this);
        }
    }

    private static String toMethod(char[] key, int keyLength) {
        return new String(key, 0, keyLength);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + "[" + this._className + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry
    implements Map.Entry<Value, Value>,
    Comparable<Map.Entry<Value, Value>> {
        private final StringValue _key;
        private final FieldVisibility _visibility;
        private Value _value;
        Entry _prev;
        Entry _next;

        public Entry(StringValue key) {
            this._key = key;
            this._visibility = FieldVisibility.PUBLIC;
            this._value = NullValue.NULL;
        }

        public Entry(StringValue key, FieldVisibility visibility) {
            this._key = key;
            this._visibility = visibility;
            this._value = NullValue.NULL;
        }

        public Entry(StringValue key, Value value) {
            this._key = key;
            this._visibility = FieldVisibility.PUBLIC;
            this._value = value;
        }

        public Entry(StringValue key, Value value, FieldVisibility visibility) {
            this._key = key;
            this._visibility = visibility;
            this._value = value;
        }

        @Override
        public Value getValue() {
            return this._value.toValue();
        }

        public Value getRawValue() {
            return this._value;
        }

        @Override
        public Value getKey() {
            return this._key;
        }

        public final boolean isPrivate() {
            return this._visibility == FieldVisibility.PRIVATE;
        }

        public Value toValue() {
            return this._value.toValue();
        }

        public Var toRefVar() {
            Var var = this._value.toRefVar();
            this._value = var;
            return var;
        }

        public Value toArgValue() {
            return this._value.toValue();
        }

        @Override
        public Value setValue(Value value) {
            Value oldValue = this.toValue();
            this._value = value;
            return oldValue;
        }

        public Value toRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new RefVar((Var)value);
            }
            Var var = new Var(this._value);
            this._value = var;
            return new RefVar(var);
        }

        public Value toArgRef() {
            Value value = this._value;
            if (value instanceof Var) {
                return new RefVar((Var)value);
            }
            Var var = new Var(this._value);
            this._value = var;
            return new RefVar(var);
        }

        public Value toArg() {
            Value value = this._value;
            if (value instanceof Var) {
                return value;
            }
            Var var = new Var(this._value);
            this._value = var;
            return var;
        }

        Entry copyTree(Env env, CopyRoot root) {
            return new Entry(this._key, this._value.copyTree(env, root), this._visibility);
        }

        @Override
        public int compareTo(Map.Entry<Value, Value> other) {
            if (other == null) {
                return 1;
            }
            Value thisKey = this.getKey();
            Value otherKey = other.getKey();
            if (thisKey == null) {
                return otherKey == null ? 0 : -1;
            }
            if (otherKey == null) {
                return 1;
            }
            return thisKey.cmp(otherKey);
        }

        public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            String suffix = "";
            if (this._visibility == FieldVisibility.PROTECTED) {
                suffix = ":protected";
            } else if (this._visibility == FieldVisibility.PRIVATE) {
                suffix = ":private";
            }
            this.printDepth(out, 2 * depth);
            out.println("[\"" + this.getKey() + suffix + "\"]=>");
            this.printDepth(out, 2 * depth);
            this._value.varDump(env, out, depth, valueSet);
            out.println();
        }

        protected void printRImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
            String suffix = "";
            if (this._visibility == FieldVisibility.PROTECTED) {
                suffix = ":protected";
            } else if (this._visibility == FieldVisibility.PRIVATE) {
                suffix = ":private";
            }
            this.printDepth(out, 4 * depth);
            out.print("[" + this.getKey() + suffix + "] => ");
            this._value.printR(env, out, depth + 1, valueSet);
            out.println();
        }

        private void printDepth(WriteStream out, int depth) throws IOException {
            for (int i = 0; i < depth; ++i) {
                out.print(' ');
            }
        }

        public String toString() {
            return "ObjectExtValue.Entry[" + this.getKey() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyIterator
    implements Iterator<Value> {
        private final Entry[] _list;
        private int _index;
        private Entry _entry;

        KeyIterator(Entry[] list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            if (this._entry != null) {
                return true;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            return this._index < this._list.length;
        }

        @Override
        public Value next() {
            if (this._entry != null) {
                Entry entry = this._entry;
                this._entry = entry._next;
                return entry._key;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            if (this._list.length <= this._index) {
                return null;
            }
            Entry entry = this._list[this._index++];
            this._entry = entry._next;
            return entry._key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValueIterator
    implements Iterator<Value> {
        private final Entry[] _list;
        private int _index;
        private Entry _entry;

        ValueIterator(Entry[] list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            if (this._entry != null) {
                return true;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            return this._index < this._list.length;
        }

        @Override
        public Value next() {
            if (this._entry != null) {
                Entry entry = this._entry;
                this._entry = entry._next;
                return entry._value;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            if (this._list.length <= this._index) {
                return null;
            }
            Entry entry = this._list[this._index++];
            this._entry = entry._next;
            return entry._value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyValueIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private final Entry[] _list;
        private int _index;
        private Entry _entry;

        KeyValueIterator(Entry[] list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            if (this._entry != null) {
                return true;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            return this._index < this._list.length;
        }

        @Override
        public Map.Entry<Value, Value> next() {
            if (this._entry != null) {
                Entry entry = this._entry;
                this._entry = entry._next;
                return entry;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            if (this._list.length <= this._index) {
                return null;
            }
            Entry entry = this._list[this._index++];
            this._entry = entry._next;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntryIterator
    implements Iterator<Entry> {
        private final Entry[] _list;
        private int _index;
        private Entry _entry;

        EntryIterator(Entry[] list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            if (this._entry != null) {
                return true;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            return this._index < this._list.length;
        }

        @Override
        public Entry next() {
            if (this._entry != null) {
                Entry entry = this._entry;
                this._entry = entry._next;
                return entry;
            }
            while (this._index < this._list.length && this._list[this._index] == null) {
                ++this._index;
            }
            if (this._list.length <= this._index) {
                return null;
            }
            Entry entry = this._list[this._index++];
            this._entry = entry._next;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntrySet
    extends AbstractSet<Map.Entry<Value, Value>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return ObjectExtValue.this.getSize();
        }

        @Override
        public Iterator<Map.Entry<Value, Value>> iterator() {
            return new KeyValueIterator(ObjectExtValue.this._entries);
        }
    }
}

