/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;

public class FieldVarGetExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(FieldVarGetExpr.class);
    protected final Expr _objExpr;
    protected final Expr _nameExpr;

    public FieldVarGetExpr(Location location, Expr objExpr, Expr nameExpr) {
        super(location);
        this._objExpr = objExpr;
        this._nameExpr = nameExpr;
    }

    public FieldVarGetExpr(Expr objExpr, Expr nameExpr) {
        this._objExpr = objExpr;
        this._nameExpr = nameExpr;
    }

    public Value evalArg(Env env) {
        Value value = this._objExpr.evalArg(env);
        return value.getFieldArg(env, this._nameExpr.evalStringValue(env));
    }

    public Value evalRef(Env env) {
        Value value = this._objExpr.evalObject(env);
        return value.getFieldRef(env, this._nameExpr.evalStringValue(env));
    }

    public Value eval(Env env) {
        Value obj = this._objExpr.eval(env);
        return obj.getField(env, this._nameExpr.evalStringValue(env));
    }

    public void evalAssign(Env env, Value value) {
        Value obj = this._objExpr.evalObject(env);
        obj.putField(env, this._nameExpr.evalStringValue(env), value);
    }

    public Value evalArray(Env env) {
        Value obj = this._objExpr.evalObject(env);
        return obj.getFieldArray(env, this._nameExpr.evalStringValue(env));
    }

    public Value evalObject(Env env) {
        Value obj = this._objExpr.evalObject(env);
        return obj.getFieldObject(env, this._nameExpr.evalStringValue(env));
    }

    public void evalUnset(Env env) {
        Value obj = this._objExpr.eval(env);
        obj.unsetField(this._nameExpr.evalStringValue(env));
    }

    public String toString() {
        return this._objExpr + "->{" + this._nameExpr + "}";
    }
}

