/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LateStaticBindingClassMethodExpr
extends Expr {
    private static final L10N L = new L10N(LateStaticBindingClassMethodExpr.class);
    protected final String _name;
    protected final Expr[] _args;
    protected boolean _isMethod;

    public LateStaticBindingClassMethodExpr(Location location, String name, ArrayList<Expr> args) {
        super(location);
        this._name = name.intern();
        this._args = new Expr[args.size()];
        args.toArray(this._args);
    }

    public LateStaticBindingClassMethodExpr(Location location, String name, Expr[] args) {
        super(location);
        this._name = name.intern();
        this._args = args;
    }

    public LateStaticBindingClassMethodExpr(String name, ArrayList<Expr> args) {
        this(Location.UNKNOWN, name, args);
    }

    public LateStaticBindingClassMethodExpr(String name, Expr[] args) {
        this(Location.UNKNOWN, name, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value eval(Env env) {
        QuercusClass cls = env.getCallingClass();
        if (cls == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        AbstractFunction fun = cls.getFunction(this._name);
        Value[] values = new Value[this._args.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this._args[i].eval(env);
        }
        Value obj = env.getThis();
        env.pushCall(this, obj, values);
        try {
            env.checkTimeout();
            Value value = fun.callMethod(env, obj, values);
            return value;
        }
        finally {
            env.popCall();
        }
    }

    @Override
    public String toString() {
        return "static::" + this._name + "()";
    }
}

