/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;

public class EnumMarshal
extends Marshal {
    private Class _enumClass;

    public EnumMarshal(Class enumClass) {
        this._enumClass = enumClass;
    }

    public Object marshal(Env env, Expr expr, Class argClass) {
        String name = expr.evalString(env);
        return Enum.valueOf(this._enumClass, name);
    }

    public Object marshal(Env env, Value value, Class argClass) {
        String name = value.toString();
        return Enum.valueOf(this._enumClass, name);
    }

    public Value unmarshal(Env env, Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        return env.createString(value.toString());
    }

    public Class getExpectedClass() {
        return this._enumClass;
    }
}

