/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaCollectionAdapter;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.function.JavaMarshal;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;
import java.util.Collection;

public class JavaCollectionMarshal
extends JavaMarshal {
    private static final L10N L = new L10N(JavaMarshal.class);

    public JavaCollectionMarshal(JavaClassDef def, boolean isNotNull) {
        this(def, isNotNull, false);
    }

    public JavaCollectionMarshal(JavaClassDef def, boolean isNotNull, boolean isUnmarshalNullAsFalse) {
        super(def, isNotNull, isUnmarshalNullAsFalse);
    }

    public Object marshal(Env env, Value value, Class argClass) {
        if (!value.isset()) {
            if (this._isNotNull) {
                env.warning(L.l("null is an unexpected argument, expected {0}", (Object)JavaCollectionMarshal.shortName(argClass)));
            }
            return null;
        }
        Collection obj = value.toJavaCollection(env, argClass);
        if (obj == null) {
            if (this._isNotNull) {
                env.warning(L.l("null is an unexpected argument, expected {0}", (Object)JavaCollectionMarshal.shortName(argClass)));
            }
            return null;
        }
        if (!argClass.isAssignableFrom(obj.getClass())) {
            env.warning(L.l("'{0}' of type '{1}' is an unexpected argument, expected {2}", (Object)value, (Object)JavaCollectionMarshal.shortName(value.getClass()), (Object)JavaCollectionMarshal.shortName(argClass)));
            return null;
        }
        return obj;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue instanceof JavaCollectionAdapter && this.getExpectedClass().isAssignableFrom(argValue.toJavaObject().getClass())) {
            return 0;
        }
        if (argValue.isArray()) {
            return 300;
        }
        return 400;
    }
}

