/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.db;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.annotation.Reference;
import com.caucho.quercus.annotation.ReturnNullAsFalse;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JdbcResultResource;
import com.caucho.quercus.lib.db.JdbcStatementResource;
import com.caucho.quercus.lib.db.Mysqli;
import com.caucho.quercus.lib.db.MysqliResult;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MysqliStatement
extends JdbcStatementResource {
    private static final Logger log = Logger.getLogger(MysqliStatement.class.getName());
    private static final L10N L = new L10N(MysqliStatement.class);

    MysqliStatement(Mysqli conn) {
        super(conn);
    }

    public int getaffected_rows(Env env) {
        return this.affected_rows(env);
    }

    public int affected_rows(Env env) {
        try {
            return this.validateConnection().getAffectedRows();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return -1;
        }
    }

    public boolean bind_param(Env env, StringValue types, @Reference Value[] params) {
        try {
            return this.bindParams(env, types.toString(), params);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean bind_result(Env env, @Reference Value[] outParams) {
        try {
            return this.bindResults(env, outParams);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean close(Env env) {
        try {
            super.close();
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public Value data_seek(Env env, int offset) {
        try {
            if (this.dataSeek(offset)) {
                return NullValue.NULL;
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return BooleanValue.FALSE;
    }

    public int errno() {
        try {
            return this.errorCode();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return -1;
        }
    }

    public int geterrno() {
        return this.errno();
    }

    public StringValue error(Env env) {
        try {
            return env.createString(this.errorMessage());
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    @ReturnNullAsFalse
    public StringValue geterror(Env env) {
        return this.error(env);
    }

    public boolean execute(Env env) {
        try {
            return super.execute(env);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public Value fetch(Env env) {
        try {
            return super.fetch(env);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            env.error(e);
            return BooleanValue.FALSE;
        }
    }

    public void free_result(Env env) {
        try {
            this.freeResult();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public Value getnum_rows(Env env) {
        return this.num_rows(env);
    }

    public Value num_rows(Env env) {
        try {
            if (this.getResultSet() != null) {
                return LongValue.create(JdbcResultResource.getNumRows(this.getResultSet()));
            }
            return BooleanValue.FALSE;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return BooleanValue.FALSE;
        }
    }

    public int getparam_count(Env env) {
        return this.param_count(env);
    }

    public int param_count(Env env) {
        try {
            return this.paramCount();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return -1;
        }
    }

    public boolean prepare(Env env, StringValue query) {
        try {
            return super.prepare(env, query);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean reset(Env env) {
        return true;
    }

    @ReturnNullAsFalse
    public MysqliResult result_metadata(Env env) {
        try {
            if (this.getResultSet() != null) {
                return new MysqliResult(env, this.getMetaData(), (Mysqli)this.validateConnection());
            }
            return null;
        }
        catch (Exception e) {
            throw new QuercusModuleException(e);
        }
    }

    public boolean send_long_data(Env env, int paramNumber, String data) {
        throw new UnimplementedException("mysqli_stmt_send_long_data");
    }

    public StringValue getsqlstate(Env env) {
        return this.sqlstate(env);
    }

    public StringValue sqlstate(Env env) {
        int code = this.errno();
        return env.createString(Mysqli.lookupSqlstate(code));
    }

    public boolean store_result(Env env) {
        return true;
    }

    public int getfield_count(Env env) {
        return this.field_count(env);
    }

    public int field_count(Env env) {
        try {
            return this.getFieldCount();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return -1;
        }
    }

    public Value getinsert_id(Env env) {
        return this.insert_id(env);
    }

    public Value insert_id(Env env) {
        return ((Mysqli)this.validateConnection()).insert_id(env);
    }
}

