/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.file;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.EnvCleanup;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.file.AbstractBinaryOutput;
import com.caucho.quercus.lib.file.BinaryInput;
import com.caucho.quercus.lib.file.BinaryOutput;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.file.LineReader;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LockableStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileInputOutput
extends AbstractBinaryOutput
implements BinaryInput,
BinaryOutput,
LockableStream,
EnvCleanup {
    private static final Logger log = Logger.getLogger(FileInputOutput.class.getName());
    private Env _env;
    private Path _path;
    private LineReader _lineReader;
    private RandomAccessStream _stream;
    private int _buffer;
    private boolean _doUnread = false;
    private Reader _readEncoding;
    private String _readEncodingName;
    private boolean _temporary;

    public FileInputOutput(Env env, Path path) throws IOException {
        this(env, path, false, false, false);
    }

    public FileInputOutput(Env env, Path path, boolean append, boolean truncate) throws IOException {
        this(env, path, append, truncate, false);
    }

    public FileInputOutput(Env env, Path path, boolean append, boolean truncate, boolean temporary) throws IOException {
        this._env = env;
        env.addCleanup(this);
        this._path = path;
        this._lineReader = new LineReader(env);
        if (truncate) {
            path.truncate(0L);
        }
        this._stream = path.openRandomAccess();
        if (append && this._stream.getLength() > 0L) {
            this._stream.seek(this._stream.getLength());
        }
        this._temporary = temporary;
    }

    public OutputStream getOutputStream() {
        try {
            return this._stream.getOutputStream();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public InputStream getInputStream() {
        try {
            return this._stream.getInputStream();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public Path getPath() {
        return this._path;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        String mimeName = Encoding.getMimeName((String)encoding);
        if (mimeName != null && mimeName.equals(this._readEncodingName)) {
            return;
        }
        this._readEncoding = Encoding.getReadEncoding((InputStream)this.getInputStream(), (String)encoding);
        this._readEncodingName = mimeName;
    }

    private int readChar() throws IOException {
        if (this._readEncoding != null) {
            int ch = this._readEncoding.read();
            return ch;
        }
        return this.read() & 0xFF;
    }

    public void unread() throws IOException {
        this._doUnread = true;
    }

    public int read() throws IOException {
        if (this._doUnread) {
            this._doUnread = false;
            return this._buffer;
        }
        this._buffer = this._stream.read();
        return this._buffer;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        this._doUnread = false;
        return this._stream.read(buffer, offset, length);
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        this._doUnread = false;
        return this._stream.read(buffer, offset, length);
    }

    public StringValue appendTo(StringValue builder) throws IOException {
        if (this._stream != null) {
            return builder.append(this._stream);
        }
        return builder;
    }

    public StringValue read(int length) throws IOException {
        StringValue bb = this._env.createBinaryBuilder();
        TempBuffer temp = TempBuffer.allocate();
        byte[] buffer = temp.getBuffer();
        while (length > 0) {
            int sublen = buffer.length;
            if (length < sublen) {
                sublen = length;
            }
            if ((sublen = this.read(buffer, 0, sublen)) <= 0) break;
            bb.append(buffer, 0, sublen);
            length -= sublen;
        }
        TempBuffer.free((TempBuffer)temp);
        return bb;
    }

    public boolean readOptionalLinefeed() throws IOException {
        int ch = this.read();
        if (ch == 10) {
            return true;
        }
        this.unread();
        return false;
    }

    public StringValue readLine(long length) throws IOException {
        return this._lineReader.readLine(this._env, this, length);
    }

    public boolean isEOF() {
        try {
            return this._stream.getLength() <= this._stream.getFilePointer();
        }
        catch (IOException e) {
            return true;
        }
    }

    public void print(char v) throws IOException {
        this._stream.write((int)((byte)v));
    }

    public void print(String v) throws IOException {
        for (int i = 0; i < v.length(); ++i) {
            this.write(v.charAt(i));
        }
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._stream.write(buffer, offset, length);
    }

    public void write(int ch) throws IOException {
        this._stream.write(ch);
    }

    public void flush() throws IOException {
    }

    public void closeWrite() {
        this.close();
    }

    public void closeRead() {
        this.close();
    }

    public void close() {
        this._env.removeCleanup(this);
        this.cleanup();
    }

    public void cleanup() {
        try {
            RandomAccessStream ras = this._stream;
            this._stream = null;
            if (ras != null) {
                ras.close();
                if (this._temporary) {
                    this._path.remove();
                }
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public long getPosition() {
        try {
            return this._stream.getFilePointer();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return -1L;
        }
    }

    public boolean setPosition(long offset) {
        return this._stream.seek(offset);
    }

    public long seek(long offset, int whence) {
        long position;
        switch (whence) {
            case 1: {
                position = this.getPosition() + offset;
                break;
            }
            case 2: {
                try {
                    position = this._stream.getLength() + offset;
                    break;
                }
                catch (IOException e) {
                    log.log(Level.FINE, e.toString(), e);
                    return this.getPosition();
                }
            }
            default: {
                position = offset;
            }
        }
        if (!this.setPosition(position)) {
            return -1L;
        }
        return position;
    }

    public BinaryInput openCopy() throws IOException {
        return new FileInputOutput(this._env, this._path);
    }

    public boolean lock(boolean shared, boolean block) {
        return this._stream.lock(shared, block);
    }

    public boolean unlock() {
        return this._stream.unlock();
    }

    public Value stat() {
        return FileModule.statImpl(this._env, this.getPath());
    }

    public String toString() {
        return "FileInputOutput[" + this.getPath() + "]";
    }
}

