/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.gettext.expr;

import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.gettext.expr.Expr;
import com.caucho.quercus.lib.gettext.expr.PluralExprParser;

public class PluralExpr {
    private PluralExprParser _parser;
    private Expr _npluralsExpr;
    private Expr _pluralExpr;

    private PluralExpr(CharSequence expr) {
        this._parser = new PluralExprParser(expr);
    }

    private void init() {
        if (this._parser != null) {
            this._npluralsExpr = this._parser.getNpluralsExpr();
            this._pluralExpr = this._parser.getPluralExpr();
            this._parser = null;
        }
    }

    public static PluralExpr getPluralExpr(StringValue metaData) {
        String pluralForms = "Plural-Forms:";
        int i = metaData.indexOf(pluralForms);
        if (i < 0) {
            return new PluralExpr("nplurals=2; plural=n!=1");
        }
        int j = metaData.indexOf('\n', i += pluralForms.length());
        if (j < 0) {
            return new PluralExpr(metaData.substring(i));
        }
        return new PluralExpr(metaData.substring(i, j));
    }

    public static int eval(CharSequence expr, int quantity) {
        return new PluralExpr(expr).eval(quantity);
    }

    public int eval(int quantity) {
        this.init();
        return this.validate(quantity);
    }

    private int validate(int quantity) {
        int pluralForm = this._pluralExpr == null ? -1 : this._pluralExpr.eval(quantity);
        int numOfPlurals = this._npluralsExpr == null ? -1 : this._npluralsExpr.eval(quantity);
        if (numOfPlurals < 1 || pluralForm < 0) {
            if (quantity == 1) {
                return 0;
            }
            return 1;
        }
        if (pluralForm >= numOfPlurals) {
            return 0;
        }
        return pluralForm;
    }
}

