/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.lib.i18n.GenericDecoder;
import com.caucho.quercus.lib.i18n.Utf8Decoder;

public abstract class Decoder {
    protected String _charset;
    protected CharSequence _replacement;
    protected boolean _isIgnoreErrors = false;
    protected boolean _isReplaceUnicode = false;
    protected boolean _isAllowMalformedOut = false;
    protected boolean _hasError;

    protected Decoder(String charset) {
        this._charset = charset;
    }

    public static Decoder create(String charset) {
        if (charset.equalsIgnoreCase("utf8") || charset.equalsIgnoreCase("utf-8")) {
            return new Utf8Decoder(charset);
        }
        return new GenericDecoder(charset);
    }

    public boolean isUtf8() {
        return false;
    }

    public final boolean isIgnoreErrors() {
        return this._isIgnoreErrors;
    }

    public final void setIgnoreErrors(boolean isIgnore) {
        this._isIgnoreErrors = isIgnore;
    }

    public final boolean hasError() {
        return this._hasError;
    }

    public final void setReplacement(CharSequence replacement) {
        this._replacement = replacement;
    }

    public final void setReplaceUnicode(boolean isReplaceUnicode) {
        this._isReplaceUnicode = isReplaceUnicode;
    }

    public final void setAllowMalformedOut(boolean isAllowMalformedOut) {
        this._isAllowMalformedOut = isAllowMalformedOut;
    }

    public void reset() {
        this._hasError = false;
    }

    public final CharSequence decode(Env env, StringValue str) {
        if (str.isUnicode()) {
            return str;
        }
        return this.decodeStringBuilder(env, str);
    }

    public StringBuilder decodeStringBuilder(Env env, StringValue str) {
        return this.decodeImpl(env, str);
    }

    public StringValue decodeUnicode(Env env, StringValue str) {
        UnicodeBuilderValue sb = new UnicodeBuilderValue();
        StringBuilder unicodeStr = this.decodeImpl(env, str);
        return sb.append(unicodeStr);
    }

    public abstract boolean isDecodable(Env var1, StringValue var2);

    protected abstract StringBuilder decodeImpl(Env var1, StringValue var2);
}

