/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.i18n;

import com.caucho.quercus.UnimplementedException;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.i18n.Decoder;
import com.caucho.quercus.lib.i18n.UnicodeUtility;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeUtility;

public class QuercusMimeUtility {
    private static final Logger log = Logger.getLogger(QuercusMimeUtility.class.getName());

    public static Value decodeMimeHeaders(Env env, StringValue encodedHeaders, String charset) throws UnsupportedEncodingException {
        ArrayValueImpl headers = new ArrayValueImpl();
        try {
            Enumeration enumeration = new InternetHeaders(encodedHeaders.toInputStream()).getAllHeaders();
            while (enumeration.hasMoreElements()) {
                ArrayValue inner;
                Header header = (Header)enumeration.nextElement();
                StringValue name = QuercusMimeUtility.decodeMime(env, header.getName(), charset);
                StringValue val = QuercusMimeUtility.decodeMime(env, header.getValue(), charset);
                Value headerName = ((ArrayValue)headers).containsKey(name);
                if (headerName == null) {
                    headers.put(name, val);
                    continue;
                }
                if (headerName.isArray()) {
                    inner = headerName.toArrayValue(env);
                } else {
                    inner = new ArrayValueImpl();
                    inner.put(headerName);
                }
                inner.put(val);
                headers.put(name, inner);
            }
            return headers;
        }
        catch (MessagingException e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning(e.getMessage());
            return BooleanValue.FALSE;
        }
    }

    public static StringValue decodeMime(Env env, CharSequence word, String charset) throws UnsupportedEncodingException {
        String decodedStr = MimeUtility.decodeText((String)((Object)word).toString());
        StringValue str = env.createString(MimeUtility.unfold((String)decodedStr));
        return str.toBinaryValue(env, charset);
    }

    public static Value encodeMime(Env env, StringValue name, StringValue value, String inCharset, String outCharset, String scheme) throws UnsupportedEncodingException {
        return QuercusMimeUtility.encodeMime(env, name, value, inCharset, outCharset, scheme, "\r\n", 76);
    }

    public static StringValue encodeMime(Env env, StringValue name, StringValue value, String inCharset, String outCharset, String scheme, String lineBreakChars, int lineLength) throws UnsupportedEncodingException {
        Decoder decoder = Decoder.create(inCharset);
        CharSequence nameUnicode = decoder.decode(env, name);
        decoder.reset();
        String valueUnicode = ((Object)decoder.decode(env, value)).toString();
        StringValue sb = env.createUnicodeBuilder();
        sb.append(UnicodeUtility.encode(env, nameUnicode, outCharset));
        sb.append(':');
        sb.append(' ');
        String word = QuercusMimeUtility.encodeMimeWord(valueUnicode.toString(), outCharset, scheme, lineBreakChars, lineLength);
        sb.append(MimeUtility.fold((int)sb.length(), (String)word));
        return sb;
    }

    public static String encodeMimeWord(String value, String charset, String scheme, String lineBreakChars, int lineLength) throws UnsupportedEncodingException {
        if (lineLength != 76) {
            throw new UnimplementedException("Mime line length option");
        }
        if (!lineBreakChars.equals("\r\n")) {
            throw new UnimplementedException("Mime line break option");
        }
        return MimeUtility.encodeWord((String)value, (String)charset, (String)scheme);
    }
}

