/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.regexp;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.lib.regexp.Regexp;
import com.caucho.quercus.lib.regexp.RegexpNode;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegexpState {
    private static final Logger log = Logger.getLogger(RegexpState.class.getName());
    private static final L10N L = new L10N(Regexp.class);
    public static final int FAIL = -1;
    public static final int SUCCESS = 0;
    private Regexp _regexp;
    StringValue _subject;
    boolean _isGlobal;
    int _first;
    int _start;
    CharBuffer _prefix;
    int _minLength;
    boolean _isUnicode;
    boolean _isPHP5String;
    boolean _isUTF8;
    boolean _isEval;
    int _groupLength;
    int[] _groupBegin;
    int[] _groupEnd;
    int[] _loopCount;
    int[] _loopOffset;

    public RegexpState(Env env, Regexp regexp, StringValue subject) {
        this(regexp);
        this._subject = subject = this._regexp.convertSubject(env, subject);
    }

    public RegexpState(Regexp regexp) {
        this._regexp = regexp;
        int nGroup = this._regexp._nGroup;
        this._groupBegin = new int[nGroup];
        this._groupEnd = new int[nGroup];
        int nLoop = this._regexp._nLoop;
        this._loopCount = new int[nLoop];
        this._loopOffset = new int[nLoop];
    }

    public boolean find() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " find()");
        }
        int minLength = this._regexp._minLength;
        boolean[] firstSet = this._regexp._firstSet;
        int length = this._subject.length();
        while (this._first + minLength <= length) {
            char firstChar;
            if (firstSet == null || this._first >= length || (firstChar = this._subject.charAt(this._first)) >= '\u0100' || firstSet[firstChar]) {
                this.clearGroup();
                int offset = this._regexp._prog.match(this._subject, length, this._first, this);
                if (offset >= 0) {
                    this._groupBegin[0] = this._first;
                    this._groupEnd[0] = offset;
                    this._first = this._first < offset ? offset : ++this._first;
                    return true;
                }
            }
            ++this._first;
        }
        this._first = length + 1;
        return false;
    }

    public boolean find(Env env, StringValue subject) {
        this._subject = subject = this._regexp.convertSubject(env, subject);
        this._first = 0;
        return this.find();
    }

    public int find(Env env, StringValue subject, int first) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " find(" + subject + ")");
        }
        this._subject = subject = this._regexp.convertSubject(env, subject);
        this._first = first;
        this.clearGroup();
        return this._regexp._prog.match(this._subject, subject.length(), first, this);
    }

    public int exec(Env env, StringValue subject, int start) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " exec(" + subject + ")");
        }
        subject = this._regexp.convertSubject(env, subject);
        this.clearGroup();
        this._start = start;
        this._first = start;
        this._subject = subject;
        int subjectLength = subject.length();
        int minLength = this._regexp._minLength;
        boolean[] firstSet = this._regexp._firstSet;
        int end = subject.length() - minLength;
        RegexpNode prog = this._regexp._prog;
        while (start <= end) {
            int value;
            char firstChar;
            if ((firstSet == null || start >= end && minLength <= 0 || (firstChar = subject.charAt(start)) >= '\u0100' || firstSet[firstChar]) && (value = prog.match(subject, subjectLength, start, this)) >= 0) {
                this._groupBegin[0] = start;
                this._groupEnd[0] = value;
                return start;
            }
            ++start;
        }
        return -1;
    }

    private void clearGroup() {
        this._groupLength = 0;
        for (int i = this._groupBegin.length - 1; i > 0; --i) {
            this._groupBegin[i] = -1;
            this._groupEnd[i] = -1;
        }
    }

    public int getBegin(int i) {
        return this._groupBegin[i];
    }

    public int getEnd(int i) {
        return this._groupEnd[i];
    }

    public void setBegin(int i, int v) {
        this._groupBegin[i] = v;
    }

    public void setEnd(int i, int v) {
        this._groupEnd[i] = v;
    }

    public int getLength() {
        return this._groupLength;
    }

    public void setLength(int length) {
        this._groupLength = length;
    }

    public int length() {
        return this._groupLength;
    }

    public int start() {
        return this.getBegin(0);
    }

    public int start(int i) {
        return this.getBegin(i);
    }

    public int end() {
        return this.getEnd(0);
    }

    public int end(int i) {
        return this.getEnd(i);
    }

    public int groupCount() {
        return this._regexp._nGroup;
    }

    public boolean isMatchedGroup(int i) {
        return i <= this._groupLength;
    }

    public StringValue group(Env env) {
        return this.group(env, 0);
    }

    public StringValue group(Env env, int i) {
        int begin = this.getBegin(i);
        int end = this.getEnd(i);
        StringValue s = this._subject.substring(begin, end);
        return this._regexp.convertResult(env, s);
    }

    public StringValue getGroupName(int i) {
        StringValue[] groupNames = this._regexp._groupNames;
        if (groupNames == null || groupNames.length <= i) {
            return null;
        }
        return groupNames[i];
    }

    public StringValue substring(Env env, int start) {
        StringValue result = this._subject.substring(start);
        return this._regexp.convertResult(env, result);
    }

    public StringValue substring(Env env, int start, int end) {
        StringValue result = this._subject.substring(start, end);
        return this._regexp.convertResult(env, result);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._regexp + "]";
    }
}

