/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Closure;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ObservableMap
implements Map {
    private Map delegate;
    private PropertyChangeSupport pcs;
    private Closure test;

    public ObservableMap() {
        this(new LinkedHashMap(), null);
    }

    public ObservableMap(Closure test) {
        this(new LinkedHashMap(), test);
    }

    public ObservableMap(Map delegate) {
        this(delegate, null);
    }

    public ObservableMap(Map delegate, Closure test) {
        this.delegate = delegate;
        this.test = test;
        this.pcs = new PropertyChangeSupport(this);
    }

    public void clear() {
        HashMap values = new HashMap();
        if (!this.delegate.isEmpty()) {
            values.putAll(this.delegate);
        }
        this.delegate.clear();
        if (values != null) {
            this.pcs.firePropertyChange(new PropertyClearedEvent(this, values));
        }
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    public boolean equals(Object o) {
        return ((Object)this.delegate).equals(o);
    }

    public Object get(Object key) {
        return this.delegate.get(key);
    }

    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public Object put(Object key, Object value) {
        boolean newKey;
        Object oldValue = null;
        boolean bl = newKey = !this.delegate.containsKey(key);
        if (this.test != null) {
            oldValue = this.delegate.put(key, value);
            Object result = null;
            result = this.test.getMaximumNumberOfParameters() == 2 ? this.test.call(new Object[]{key, value}) : this.test.call(value);
            if (result != null && result instanceof Boolean && ((Boolean)result).booleanValue()) {
                if (newKey) {
                    this.pcs.firePropertyChange(new PropertyAddedEvent(this, String.valueOf(key), value));
                } else if (oldValue != value) {
                    this.pcs.firePropertyChange(new PropertyUpdatedEvent(this, String.valueOf(key), oldValue, value));
                }
            }
        } else {
            oldValue = this.delegate.put(key, value);
            if (newKey) {
                this.pcs.firePropertyChange(new PropertyAddedEvent(this, String.valueOf(key), value));
            } else if (oldValue != value) {
                this.pcs.firePropertyChange(new PropertyUpdatedEvent(this, String.valueOf(key), oldValue, value));
            }
        }
        return oldValue;
    }

    public void putAll(Map map) {
        if (map != null) {
            ArrayList<PropertyEvent> events = new ArrayList<PropertyEvent>();
            for (Map.Entry entry : map.entrySet()) {
                boolean newKey;
                String key = String.valueOf(entry.getKey());
                Object newValue = entry.getValue();
                Object oldValue = null;
                boolean bl = newKey = !this.delegate.containsKey(key);
                if (this.test != null) {
                    oldValue = this.delegate.put(key, newValue);
                    Object result = null;
                    result = this.test.getMaximumNumberOfParameters() == 2 ? this.test.call(new Object[]{key, newValue}) : this.test.call(newValue);
                    if (result == null || !(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
                    if (newKey) {
                        events.add(new PropertyAddedEvent(this, key, newValue));
                        continue;
                    }
                    if (oldValue == newValue) continue;
                    events.add(new PropertyUpdatedEvent(this, key, oldValue, newValue));
                    continue;
                }
                oldValue = this.delegate.put(key, newValue);
                if (newKey) {
                    events.add(new PropertyAddedEvent(this, key, newValue));
                    continue;
                }
                if (oldValue == newValue) continue;
                events.add(new PropertyUpdatedEvent(this, key, oldValue, newValue));
            }
            if (events.size() > 0) {
                this.pcs.firePropertyChange(new MultiPropertyEvent(this, events.toArray(new PropertyEvent[events.size()])));
            }
        }
    }

    public Object remove(Object key) {
        Object result = this.delegate.remove(key);
        if (key != null) {
            this.pcs.firePropertyChange(new PropertyRemovedEvent(this, String.valueOf(key), result));
        }
        return result;
    }

    public int size() {
        return this.delegate.size();
    }

    public Collection values() {
        return this.delegate.values();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public static class MultiPropertyEvent
    extends PropertyEvent {
        public static final String MULTI_PROPERTY = "groovy_util_ObservableMap_MultiPropertyEvent_MULTI";
        private PropertyEvent[] events = new PropertyEvent[0];

        public MultiPropertyEvent(Object source, PropertyEvent[] events) {
            super(source, MULTI_PROPERTY, OLDVALUE, NEWVALUE, 4);
            if (events != null && events.length > 0) {
                this.events = new PropertyEvent[events.length];
                System.arraycopy(events, 0, this.events, 0, events.length);
            }
        }

        public PropertyEvent[] getEvents() {
            PropertyEvent[] copy = new PropertyEvent[this.events.length];
            System.arraycopy(this.events, 0, copy, 0, this.events.length);
            return copy;
        }
    }

    public static class PropertyClearedEvent
    extends PropertyEvent {
        public static final String CLEAR_PROPERTY = "groovy_util_ObservableMap_PropertyClearedEvent_CLEAR";
        private Map values = new HashMap();

        public PropertyClearedEvent(Object source, Map values) {
            super(source, CLEAR_PROPERTY, OLDVALUE, NEWVALUE, 3);
            if (values != null) {
                this.values.putAll(values);
            }
        }

        public Map getValues() {
            return Collections.unmodifiableMap(this.values);
        }
    }

    public static class PropertyRemovedEvent
    extends PropertyEvent {
        public PropertyRemovedEvent(Object source, String propertyName, Object oldValue) {
            super(source, propertyName, oldValue, null, 2);
        }
    }

    public static class PropertyUpdatedEvent
    extends PropertyEvent {
        public PropertyUpdatedEvent(Object source, String propertyName, Object oldValue, Object newValue) {
            super(source, propertyName, oldValue, newValue, 1);
        }
    }

    public static class PropertyAddedEvent
    extends PropertyEvent {
        public PropertyAddedEvent(Object source, String propertyName, Object newValue) {
            super(source, propertyName, null, newValue, 0);
        }
    }

    public static abstract class PropertyEvent
    extends PropertyChangeEvent {
        public static final int ADDED = 0;
        public static final int UPDATED = 1;
        public static final int REMOVED = 2;
        public static final int CLEARED = 3;
        public static final int MULTI = 4;
        protected static final Object OLDVALUE = new Object();
        protected static final Object NEWVALUE = new Object();
        private int type;

        public PropertyEvent(Object source, String propertyName, Object oldValue, Object newValue, int type) {
            super(source, propertyName, oldValue, newValue);
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.type = type;
                    break;
                }
                default: {
                    this.type = 1;
                }
            }
        }

        public int getType() {
            return this.type;
        }

        public String getTypeAsString() {
            switch (this.type) {
                case 0: {
                    return "ADDED";
                }
                case 1: {
                    return "UPDATED";
                }
                case 2: {
                    return "REMOVED";
                }
                case 3: {
                    return "CLEARED";
                }
                case 4: {
                    return "MULTI";
                }
            }
            return "UPDATED";
        }
    }
}

