/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"GC"})
public class RubyGC {
    public static RubyModule createGCModule(Ruby runtime2) {
        RubyModule result = runtime2.defineModule("GC");
        runtime2.setGC(result);
        result.defineAnnotatedMethods(RubyGC.class);
        return result;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject start(IRubyObject recv2) {
        System.gc();
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject garbage_collect(IRubyObject recv2) {
        System.gc();
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject enable(IRubyObject recv2) {
        recv2.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.enable will not work on JRuby", "GC.enable");
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject disable(IRubyObject recv2) {
        recv2.getRuntime().getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "GC.disable will not work on JRuby", "GC.disable");
        return recv2.getRuntime().getNil();
    }
}

