/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class UndefinedAccessor
implements IAccessor {
    private final Ruby runtime;
    private final GlobalVariable globalVariable;
    private final String name;

    public UndefinedAccessor(Ruby runtime2, GlobalVariable globalVariable, String name2) {
        assert (runtime2 != null);
        assert (globalVariable != null);
        assert (name2 != null);
        this.runtime = runtime2;
        this.globalVariable = globalVariable;
        this.name = name2;
    }

    public IRubyObject getValue() {
        if (this.runtime.isVerbose()) {
            this.runtime.getWarnings().warning(IRubyWarnings.ID.ACCESSOR_NOT_INITIALIZED, "global variable `" + this.name + "' not initialized", this.name);
        }
        return this.runtime.getNil();
    }

    public IRubyObject setValue(IRubyObject newValue) {
        assert (newValue != null);
        this.globalVariable.setAccessor(new ValueAccessor(newValue));
        return newValue;
    }
}

