/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.executable.YARVMachine;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class YARVMethod
extends DynamicMethod
implements JumpTarget {
    private YARVMachine.InstructionSequence iseq;
    private StaticScope staticScope;
    private Arity arity;

    public YARVMethod(RubyModule implementationClass, YARVMachine.InstructionSequence iseq, StaticScope staticScope, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FrameFullScopeFull);
        boolean req;
        this.staticScope = staticScope;
        this.iseq = iseq;
        boolean opts = iseq.args_arg_opts > 0 || iseq.args_rest > 0;
        boolean bl = req = iseq.args_argc > 0;
        this.arity = !req && !opts ? Arity.noArguments() : (req && !opts ? Arity.fixed(iseq.args_argc) : (opts && !req ? Arity.optional() : Arity.required(iseq.args_argc)));
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name2, IRubyObject[] args2, Block block) {
        IRubyObject iRubyObject;
        assert (args2 != null);
        Ruby runtime2 = context.getRuntime();
        this.callConfig.pre(context, self, klazz, name2, block, this.staticScope, this);
        try {
            this.prepareArguments(context, runtime2, args2);
            this.getArity().checkArity(runtime2, args2);
            if (runtime2.hasEventHooks()) {
                this.traceCall(context, runtime2, name2);
            }
            DynamicScope scope = context.getCurrentScope();
            scope.setArgValues(args2, args2.length);
            iRubyObject = YARVMachine.INSTANCE.exec(context, self, this.iseq.body);
            Object var11_12 = null;
        }
        catch (JumpException.ReturnJump rj) {
            block10: {
                try {
                    if (rj.getTarget() != this) break block10;
                    IRubyObject iRubyObject2 = (IRubyObject)rj.getValue();
                    Object var11_13 = null;
                    if (runtime2.hasEventHooks()) {
                        this.traceReturn(context, runtime2, name2);
                    }
                    this.callConfig.post(context);
                    return iRubyObject2;
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (runtime2.hasEventHooks()) {
                        this.traceReturn(context, runtime2, name2);
                    }
                    this.callConfig.post(context);
                    throw throwable;
                }
            }
            throw rj;
        }
        if (runtime2.hasEventHooks()) {
            this.traceReturn(context, runtime2, name2);
        }
        this.callConfig.post(context);
        return iRubyObject;
    }

    private void prepareArguments(ThreadContext context, Ruby runtime2, IRubyObject[] args2) {
        boolean hasOptArgs;
        context.setFileAndLine(this.iseq.filename, -1);
        int expectedArgsCount = this.iseq.args_argc;
        int restArg = this.iseq.args_rest;
        boolean bl = hasOptArgs = this.iseq.args_arg_opts > 0;
        if (expectedArgsCount > args2.length) {
            throw runtime2.newArgumentError("Wrong # of arguments(" + args2.length + " for " + expectedArgsCount + ")");
        }
        if (hasOptArgs || restArg != -1) {
            this.prepareOptOrRestArgs(context, runtime2, args2, expectedArgsCount, restArg, hasOptArgs);
        }
    }

    private IRubyObject[] prepareOptOrRestArgs(ThreadContext context, Ruby runtime2, IRubyObject[] args2, int expectedArgsCount, int restArg, boolean hasOptArgs) {
        int i;
        int opt;
        if (restArg == 0 && hasOptArgs && (opt = expectedArgsCount + this.iseq.args_arg_opts) < args2.length) {
            throw runtime2.newArgumentError("wrong # of arguments(" + args2.length + " for " + opt + ")");
        }
        int count2 = expectedArgsCount + this.iseq.args_arg_opts + this.iseq.args_rest;
        ArrayList<IRubyObject> allArgs = new ArrayList<IRubyObject>();
        for (i = 0; i < count2 && i < args2.length; ++i) {
            allArgs.add(args2[i]);
        }
        if (restArg != 0) {
            for (i = expectedArgsCount; i < args2.length; ++i) {
                allArgs.add(args2[i]);
            }
            if (restArg >= 0) {
                RubyArray array = runtime2.newArray(args2.length - expectedArgsCount);
                for (int i2 = expectedArgsCount; i2 < args2.length; ++i2) {
                    array.append(args2[i2]);
                }
                context.getCurrentScope().setValue(restArg, array, 0);
            }
        }
        args2 = allArgs.toArray(new IRubyObject[allArgs.size()]);
        return args2;
    }

    private void traceReturn(ThreadContext context, Ruby runtime2, String name2) {
        if (!runtime2.hasEventHooks()) {
            return;
        }
        Frame frame = context.getPreviousFrame();
        runtime2.callEventHooks(context, RubyEvent.RETURN, frame.getFile(), frame.getLine(), name2, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime2, String name2) {
        if (!runtime2.hasEventHooks()) {
            return;
        }
        runtime2.callEventHooks(context, RubyEvent.CALL, context.getFile(), context.getLine(), name2, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.arity;
    }

    public DynamicMethod dup() {
        return new YARVMethod(this.getImplementationClass(), this.iseq, this.staticScope, this.getVisibility());
    }
}

