/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.ConfigRuntimeException;
import com.caucho.config.LineConfigException;
import com.caucho.util.CompileException;
import com.caucho.util.DisplayableException;
import com.caucho.util.Html;
import com.caucho.util.LineCompileException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class ConfigException
extends ConfigRuntimeException
implements CompileException,
DisplayableException {
    private static final Logger log = Logger.getLogger(ConfigException.class.getName());

    public ConfigException() {
    }

    public ConfigException(String msg) {
        super(msg);
    }

    public ConfigException(String msg, Throwable e) {
        super(msg, e);
    }

    private static String getMessage(Throwable e) {
        if (e instanceof DisplayableException || e instanceof CompileException) {
            return e.getMessage();
        }
        return e.toString();
    }

    public static RuntimeException create(String location, Throwable e) {
        if (e instanceof InstantiationException && e.getCause() != null) {
            e = e.getCause();
        }
        if (e instanceof InvocationTargetException && e.getCause() != null) {
            e = e.getCause();
        }
        if (e instanceof LineConfigException) {
            throw (LineConfigException)e;
        }
        if (e instanceof DisplayableException) {
            return new ConfigException(location + e.getMessage(), e);
        }
        return new ConfigException(location + e, e);
    }

    public static RuntimeException createLine(String line, Throwable e) {
        while (e.getCause() != null && (e instanceof InstantiationException || e instanceof InvocationTargetException || e.getClass().equals(ConfigRuntimeException.class))) {
            e = e.getCause();
        }
        if (e instanceof LineConfigException) {
            throw (LineConfigException)e;
        }
        if (e instanceof DisplayableException) {
            return new LineConfigException(line + e.getMessage(), e);
        }
        return new LineConfigException(line + e, e);
    }

    public static RuntimeException create(Field field, Throwable e) {
        return ConfigException.create(ConfigException.loc(field), e);
    }

    public static RuntimeException create(Method method, Throwable e) {
        return ConfigException.create(ConfigException.loc(method), e);
    }

    public static RuntimeException create(Method method, String msg, Throwable e) {
        return new ConfigException(ConfigException.loc(method) + msg, e);
    }

    public static RuntimeException create(Method method, String msg) {
        return new ConfigException(ConfigException.loc(method) + msg);
    }

    public static RuntimeException create(Throwable e) {
        while (e.getCause() != null && (e instanceof InstantiationException || e instanceof InvocationTargetException || e.getClass().equals(ConfigRuntimeException.class))) {
            e = e.getCause();
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof LineCompileException) {
            return new LineConfigException(e.getMessage(), e);
        }
        if (e instanceof DisplayableException || e instanceof CompileException) {
            return new ConfigException(e.getMessage(), e);
        }
        return new ConfigRuntimeException(e);
    }

    public void print(PrintWriter out) {
        out.println(Html.escapeHtml(this.getMessage()));
    }

    public static String loc(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName() + ": ";
    }

    public static String loc(Method method) {
        return method.getDeclaringClass().getName() + "." + method.getName() + "(): ";
    }
}

