/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Base64;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Attachment {
    private static final L10N L = new L10N(Attachment.class);
    private byte[] _contents;
    private final Map<String, List<String>> _headers = new HashMap<String, List<String>>();

    Attachment() {
    }

    void setContents(byte[] contents) {
        this._contents = contents;
    }

    public byte[] getContents() {
        return this._contents;
    }

    public byte[] getRawContents() throws IOException {
        String encoding = this.getHeaderValue("Content-Transfer-Encoding");
        if (encoding == null) {
            return this._contents;
        }
        if ("base64".equalsIgnoreCase(encoding)) {
            return Base64.decodeToByteArray(new String(this._contents, "US-ASCII"));
        }
        if ("binary".equalsIgnoreCase(encoding)) {
            return this._contents;
        }
        throw new IOException(L.l("Unknown attachment transfer encoding: {0}", encoding));
    }

    public String getHeaderValue(String name) {
        List<String> values = this._headers.get(name);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public Iterator getHeaderValues(String name) {
        List<String> values = this._headers.get(name);
        if (values == null) {
            return null;
        }
        return values.iterator();
    }

    public void addHeader(String name, String value) {
        List<String> values = this._headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this._headers.put(name, values);
        }
        values.add(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Attachment[");
        for (Map.Entry<String, List<String>> entry : this._headers.entrySet()) {
            for (String value : entry.getValue()) {
                sb.append(entry.getKey());
                sb.append(" -> ");
                sb.append(value);
                sb.append(",");
            }
        }
        sb.append("contents=");
        sb.append(new String(this._contents));
        sb.append("]");
        return sb.toString();
    }
}

