/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Attachment;
import com.caucho.util.L10N;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentReader {
    private static final Logger log = Logger.getLogger(AttachmentReader.class.getName());
    private static final L10N L = new L10N(AttachmentReader.class);

    public static List<Attachment> read(InputStream is, String contentType) throws IOException {
        String[] tokens = contentType.split(";");
        String boundary = null;
        for (int i = 0; i < tokens.length; ++i) {
            int start = tokens[i].indexOf("boundary=");
            if (start < 0) continue;
            boundary = tokens[i].substring(start + "boundary=".length() + 1, tokens[i].lastIndexOf(34));
            boundary = boundary + "\r\n";
            break;
        }
        if (boundary == null) {
            return null;
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        Attachment attachment = new Attachment();
        BoundaryBuffer buffer = new BoundaryBuffer();
        boolean starting = true;
        boolean inBody = false;
        int lastCh = -1;
        int ch = is.read();
        while (ch >= 0) {
            buffer.write(ch);
            if (buffer.endsWith(boundary)) {
                if (!starting) {
                    attachment.setContents(buffer.getContents(boundary));
                    attachments.add(attachment);
                    attachment = new Attachment();
                }
                buffer.reset();
                starting = false;
                inBody = false;
            } else if (!inBody && !starting && lastCh == 13 && ch == 10) {
                if (buffer.size() == 2) {
                    inBody = true;
                } else {
                    String header = buffer.toString("US-ASCII");
                    tokens = header.split(":", 2);
                    if (tokens.length == 2) {
                        attachment.addHeader(tokens[0].trim(), tokens[1].trim());
                    } else {
                        log.fine(L.l("Header in attachment does not contain a ':': '{0}'", header));
                    }
                }
                buffer.reset();
            }
            lastCh = ch;
            ch = is.read();
        }
        attachment.setContents(buffer.toByteArray());
        attachments.add(attachment);
        return attachments;
    }

    private static class BoundaryBuffer
    extends ByteArrayOutputStream {
        private BoundaryBuffer() {
        }

        public boolean endsWith(String boundary) throws UnsupportedEncodingException {
            if (this.count < boundary.length()) {
                return false;
            }
            String end = new String(this.buf, this.count - boundary.length(), boundary.length(), "US-ASCII");
            return end.equals(boundary);
        }

        public byte[] getContents(String boundary) {
            byte[] contents = new byte[this.count - boundary.length() - "\r\n--".length()];
            System.arraycopy(this.buf, 0, contents, 0, contents.length);
            return contents;
        }
    }
}

