/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.FileRandomAccessStream;
import com.caucho.vfs.FileReadStream;
import com.caucho.vfs.FileWriteStream;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePath
extends FilesystemPath {
    private static byte[] NEWLINE = FilePath.getNewlineString().getBytes();
    private static FilesystemPath PWD;
    private File _file;
    protected boolean _isWindows;

    protected FilePath(FilesystemPath root, String userPath, String path) {
        super(root, userPath, path);
        _separatorChar = FilePath.getFileSeparatorChar();
        this._isWindows = _separatorChar == '\\';
    }

    public FilePath(String path) {
        this(null, path, FilePath.normalizePath("/", FilePath.initialPath(path), 0, FilePath.getFileSeparatorChar()));
        if (this._root == null) {
            this._root._root = this._root = new FilePath(null, "/", "/");
            if (PWD == null) {
                PWD = this._root;
            }
        }
        _separatorChar = FilesystemPath._separatorChar;
        this._isWindows = ((FilePath)this._root)._isWindows;
    }

    protected static String initialPath(String path) {
        if (path == null) {
            return FilePath.getPwd();
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            return path;
        }
        if (path.length() > 1 && path.charAt(1) == ':' && FilePath.isWindows()) {
            return path;
        }
        String dir = FilePath.getPwd();
        if (dir.length() > 0 && dir.charAt(dir.length() - 1) == '/') {
            return dir + path;
        }
        return dir + "/" + path;
    }

    public static String getPwd() {
        String path = FilePath.getUserDir();
        path = path.replace(FilePath.getFileSeparatorChar(), '/');
        if (FilePath.isWindows()) {
            path = FilePath.convertFromWindowsPath(path);
        }
        return path;
    }

    private static String convertFromWindowsPath(String path) {
        char ch;
        int colon = path.indexOf(58);
        int length = path.length();
        if (colon == 1 && (ch = path.charAt(0)) != '/' && ch != '\\') {
            return "/" + path.charAt(0) + ":/" + path.substring(2);
        }
        if (!(length <= 1 || (ch = path.charAt(0)) != '/' && ch != '\\' || (ch = path.charAt(1)) != '/' && ch != '\\')) {
            if (colon < 0) {
                return "/:" + path;
            }
            for (int i = colon - 2; i > 1; --i) {
                ch = path.charAt(i);
                if (ch == '/' || ch == '\\') continue;
                return "/:" + path;
            }
            ch = path.charAt(colon - 1);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                return path.substring(colon - 2);
            }
            return "/:" + path;
        }
        return path;
    }

    @Override
    public long getDiskSpaceFree() {
        try {
            return this._file.getFreeSpace();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public long getDiskSpaceTotal() {
        try {
            return this._file.getTotalSpace();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    protected Path schemeWalk(String userPath, Map<String, Object> attributes, String filePath, int offset) {
        if (!FilePath.isWindows()) {
            return super.schemeWalk(userPath, attributes, filePath, offset);
        }
        if (filePath.length() < offset + 2) {
            return super.schemeWalk(userPath, attributes, filePath, offset);
        }
        char ch1 = filePath.charAt(offset + 1);
        char ch2 = filePath.charAt(offset);
        if (!(ch2 != '/' && ch2 != _separatorChar || ch1 != '/' && ch1 != _separatorChar)) {
            return super.schemeWalk(userPath, attributes, FilePath.convertFromWindowsPath(filePath.substring(offset)), 0);
        }
        return super.schemeWalk(userPath, attributes, filePath, offset);
    }

    @Override
    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        return new FilePath(this._root, userPath, path);
    }

    @Override
    protected boolean isPathCacheable() {
        return true;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public String getURL() {
        char ch;
        if (!FilePath.isWindows()) {
            return FilePath.escapeURL("file:" + this.getFullPath());
        }
        String path = this.getFullPath();
        int length = path.length();
        CharBuffer cb = new CharBuffer();
        cb.append("file:");
        int offset = 0;
        if (!(length >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':' && ('a' <= (ch = path.charAt(1)) && ch <= 'z' || 'A' <= ch && ch <= 'Z') || length < 3 || path.charAt(0) != '/' || path.charAt(1) != ':' || path.charAt(2) != '/')) {
            cb.append('/');
            cb.append('/');
            cb.append('/');
            cb.append('/');
            offset = 3;
        }
        while (offset < length) {
            ch = path.charAt(offset);
            if (ch == '\\') {
                cb.append('/');
            } else {
                cb.append(ch);
            }
            ++offset;
        }
        return FilePath.escapeURL(cb.toString());
    }

    @Override
    public String getNativePath() {
        char ch;
        if (!FilePath.isWindows()) {
            return this.getFullPath();
        }
        String path = this.getFullPath();
        int length = path.length();
        CharBuffer cb = new CharBuffer();
        int offset = 0;
        if (FilePath.isWindows()) {
            if (length >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':' && ('a' <= (ch = path.charAt(1)) && ch <= 'z' || 'A' <= ch && ch <= 'Z')) {
                offset = 1;
            } else if (length >= 3 && path.charAt(0) == '/' && path.charAt(1) == ':' && path.charAt(2) == '/') {
                cb.append('\\');
                cb.append('\\');
                offset = 3;
            }
        }
        while (offset < length) {
            ch = path.charAt(offset);
            if (ch == '/') {
                cb.append(_separatorChar);
            } else {
                cb.append(ch);
            }
            ++offset;
        }
        return cb.close();
    }

    @Override
    public boolean exists() {
        if (this._isWindows && this.isAux()) {
            return false;
        }
        return this.getFile().exists();
    }

    @Override
    public int getMode() {
        int perms = 0;
        if (this.isDirectory()) {
            perms += 512;
            perms += 73;
        }
        if (this.canRead()) {
            perms += 292;
        }
        if (this.canWrite()) {
            perms += 144;
        }
        return perms;
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public boolean isFile() {
        if (this._isWindows && this.isAux()) {
            return false;
        }
        return this.getFile().isFile();
    }

    @Override
    public long getLength() {
        return this.getFile().length();
    }

    @Override
    public long getLastModified() {
        return this.getFile().lastModified();
    }

    @Override
    public void setLastModified(long time) {
        this.getFile().setLastModified(time);
    }

    @Override
    public boolean canRead() {
        File file = this.getFile();
        if (this._isWindows && this.isAux()) {
            return false;
        }
        return file.canRead();
    }

    @Override
    public boolean canWrite() {
        File file = this.getFile();
        if (this._isWindows && this.isAux()) {
            return false;
        }
        return file.canWrite();
    }

    @Override
    public String[] list() throws IOException {
        String[] list = this.getFile().list();
        if (list != null) {
            return list;
        }
        return new String[0];
    }

    @Override
    public boolean mkdir() throws IOException {
        boolean value = this.getFile().mkdir();
        if (!value && !this.getFile().isDirectory()) {
            throw new IOException("cannot create directory");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mkdirs() throws IOException {
        boolean value;
        File file;
        File file2 = file = this.getFile();
        synchronized (file2) {
            value = file.mkdirs();
        }
        if (!value && !file.isDirectory()) {
            throw new IOException("Cannot create directory: " + this.getFile());
        }
        return value;
    }

    @Override
    public boolean remove() {
        if (this.getFile().delete()) {
            return true;
        }
        if (this.getPath().endsWith(".jar")) {
            return this.getFile().delete();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncate(long length) throws IOException {
        File file = this.getFile();
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.getChannel().truncate(length);
            boolean bl = true;
            return bl;
        }
        finally {
            fos.close();
        }
    }

    @Override
    public boolean renameTo(Path path) {
        if (!(path instanceof FilePath)) {
            return false;
        }
        FilePath file = (FilePath)path;
        return this.getFile().renameTo(file.getFile());
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        if (this._isWindows && this.isAux()) {
            throw new FileNotFoundException(this._file.toString());
        }
        return new FileReadStream(new FileInputStream(this.getFile()), this);
    }

    @Override
    public StreamImpl openWriteImpl() throws IOException {
        FileWriteStream fws = new FileWriteStream(new FileOutputStream(this.getFile()), this);
        fws.setNewline(NEWLINE);
        return fws;
    }

    @Override
    public StreamImpl openAppendImpl() throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.getFile().toString(), true);
        }
        catch (IOException e) {
            fos = new FileOutputStream(this.getFile().toString());
        }
        FileWriteStream fws = new FileWriteStream(fos);
        fws.setNewline(NEWLINE);
        return fws;
    }

    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        VfsStream os = new VfsStream(new FileInputStream(this.getFile()), new FileOutputStream(this.getFile()), this);
        os.setNewline(NEWLINE);
        return os;
    }

    @Override
    public RandomAccessStream openRandomAccess() throws IOException {
        if (this._isWindows && this.isAux()) {
            throw new FileNotFoundException(this._file.toString());
        }
        return new FileRandomAccessStream(new RandomAccessFile(this.getFile(), "rw"));
    }

    @Override
    protected Path copy() {
        return new FilePath(this.getRoot(), this.getUserPath(), this.getPath());
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    public boolean equals(Object b) {
        if (this == b) {
            return true;
        }
        if (!(b instanceof FilePath)) {
            return false;
        }
        FilePath file = (FilePath)b;
        return this.getPath().equals(file.getPath());
    }

    public File getFile() {
        if (this._file != null) {
            return this._file;
        }
        this._file = Alarm.isTest() ? new File(this.getFullPath()) : new File(this.getNativePath());
        return this._file;
    }

    protected boolean isAux() {
        char ch;
        if (!this._isWindows) {
            return false;
        }
        File file = this.getFile();
        String path = this.getFullPath().toLowerCase();
        int len = path.length();
        int p = path.indexOf("/aux");
        if (p >= 0 && (len <= p + 4 || path.charAt(p + 4) == '.')) {
            return true;
        }
        p = path.indexOf("/con");
        if (p >= 0 && (len <= p + 4 || path.charAt(p + 4) == '.')) {
            return true;
        }
        p = path.indexOf("/lpt");
        if (p >= 0 && (len <= p + 5 || path.charAt(p + 5) == '.') && '0' <= (ch = path.charAt(p + 4)) && ch <= '9') {
            return true;
        }
        p = path.indexOf("/nul");
        return p >= 0 && (len <= p + 4 || path.charAt(p + 4) == '.');
    }
}

