/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.FlushBuffer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrintWriterImpl
extends PrintWriter
implements FlushBuffer {
    private static final Logger log = Logger.getLogger(PrintWriterImpl.class.getName());
    private static final char[] _nullChars = "null".toCharArray();
    private static final char[] _newline = "\n".toCharArray();
    private static final Writer _dummyWriter = new StringWriter();
    private final char[] _tempCharBuffer = new char[64];

    public PrintWriterImpl() {
        super(_dummyWriter);
    }

    public PrintWriterImpl(Writer out) {
        super(out);
    }

    public void setWriter(Writer out) {
        this.out = out;
    }

    public final void write(char ch) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            out.write(ch);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void write(char[] buf, int offset, int length) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            out.write(buf, offset, length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void write(char[] buf) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            out.write(buf, 0, buf.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void print(char ch) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            out.write(ch);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void print(int i) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        if (i == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        try {
            if (i < 0) {
                out.write(45);
                i = -i;
            } else if (i < 9) {
                out.write(48 + i);
                return;
            }
            int length = 0;
            int exp = 10;
            if (i >= 1000000000) {
                length = 9;
            } else {
                while (i >= exp) {
                    exp = 10 * exp;
                    ++length;
                }
            }
            int j = 31;
            while (i > 0) {
                this._tempCharBuffer[--j] = (char)(i % 10 + 48);
                i /= 10;
            }
            out.write(this._tempCharBuffer, j, 31 - j);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void print(long v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        if (v == Long.MIN_VALUE) {
            this.print("-9223372036854775808");
            return;
        }
        try {
            if (v < 0L) {
                out.write(45);
                v = -v;
            } else if (v == 0L) {
                out.write(48);
                return;
            }
            int j = 31;
            while (v > 0L) {
                this._tempCharBuffer[--j] = (char)(v % 10L + 48L);
                v /= 10L;
            }
            out.write(this._tempCharBuffer, j, 31 - j);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void print(float v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            String s = String.valueOf(v);
            out.write(s, 0, s.length());
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void print(double v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            String s = String.valueOf(v);
            out.write(s, 0, s.length());
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void print(char[] s) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            out.write(s, 0, s.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void print(String s) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            if (s == null) {
                out.write(_nullChars, 0, _nullChars.length);
            } else {
                out.write(s, 0, s.length());
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void print(Object v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            if (v == null) {
                out.write(_nullChars, 0, _nullChars.length);
            } else {
                String s = v.toString();
                out.write(s, 0, s.length());
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println() {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println(boolean v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        this.print(v);
        try {
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println(char v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            out.write(v);
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println(int v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        this.print(v);
        try {
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println(long v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        this.print(v);
        try {
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println(float v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        String s = String.valueOf(v);
        try {
            out.write(s, 0, s.length());
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println(double v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        this.print(v);
        try {
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println(char[] s) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            out.write(s, 0, s.length);
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println(String s) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            if (s == null) {
                out.write(_nullChars, 0, _nullChars.length);
            } else {
                out.write(s, 0, s.length());
            }
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public final void println(Object v) {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            if (v == null) {
                out.write(_nullChars, 0, _nullChars.length);
            } else {
                String s = v.toString();
                out.write(s, 0, s.length());
            }
            out.write(_newline, 0, _newline.length);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void flush() {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            out.flush();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void flushBuffer() {
        Writer out = this.out;
        if (out == null) {
            return;
        }
        try {
            if (out instanceof FlushBuffer) {
                ((FlushBuffer)((Object)out)).flushBuffer();
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void close() {
        this.out = null;
    }
}

