/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs.i18n;

import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;

public class UTF8Writer
extends EncodingWriter {
    private static final UTF8Writer _writer = new UTF8Writer();

    public String getJavaEncoding() {
        return "UTF8";
    }

    public EncodingWriter create(String javaEncoding) {
        return _writer;
    }

    public EncodingWriter create() {
        return _writer;
    }

    public void write(OutputStreamWithBuffer os, char ch) throws IOException {
        int length;
        byte[] buffer = os.getBuffer();
        if (buffer.length <= (length = os.getBufferOffset()) + 2) {
            buffer = os.nextBuffer(length);
            length = os.getBufferOffset();
        }
        if (ch < '\u0080') {
            buffer[length++] = (byte)ch;
        } else if (ch < '\u0800') {
            buffer[length++] = (byte)(192 + (ch >> 6));
            buffer[length++] = (byte)(128 + (ch & 0x3F));
        } else {
            buffer[length++] = (byte)(224 + (ch >> 12));
            buffer[length++] = (byte)(128 + (ch >> 6 & 0x3F));
            buffer[length++] = (byte)(128 + (ch & 0x3F));
        }
        os.setBufferOffset(length);
    }

    public void write(OutputStreamWithBuffer os, char[] cbuf, int off, int len) throws IOException {
        byte[] buffer = os.getBuffer();
        int length = os.getBufferOffset();
        int capacity = buffer.length;
        for (int i = 0; i < len; ++i) {
            char ch;
            if (capacity <= length + 2) {
                buffer = os.nextBuffer(length);
                length = os.getBufferOffset();
            }
            if ((ch = cbuf[off + i]) < '\u0080') {
                buffer[length++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                buffer[length++] = (byte)(192 + (ch >> 6));
                buffer[length++] = (byte)(128 + (ch & 0x3F));
                continue;
            }
            if (ch < '\ud800' || '\udfff' < ch) {
                buffer[length++] = (byte)(224 + (ch >> 12));
                buffer[length++] = (byte)(128 + (ch >> 6 & 0x3F));
                buffer[length++] = (byte)(128 + (ch & 0x3F));
                continue;
            }
            char ch2 = cbuf[off + i + 1];
            int v = 65536 + (ch & 0x3FF) * 1024 + (ch2 & 0x3FF);
            ++i;
            buffer[length++] = (byte)(240 + (v >> 18));
            buffer[length++] = (byte)(128 + (v >> 12 & 0x3F));
            buffer[length++] = (byte)(128 + (v >> 6 & 0x3F));
            buffer[length++] = (byte)(128 + (v & 0x3F));
        }
        os.setBufferOffset(length);
    }
}

