/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.collections.WeakHashSet;

@JRubyClass(name={"Class"}, parent="Module")
public class RubyClass
extends RubyModule {
    public static final int CS_IDX_INITIALIZE = 0;
    public static final String[] CS_NAMES = new String[]{"initialize"};
    private final CallSite[] baseCallSites = new CallSite[CS_NAMES.length];
    private CallSite[] extraCallSites;
    public static final ObjectAllocator CLASS_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyClass clazz = new RubyClass(runtime2);
            clazz.allocator = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;
            return clazz;
        }
    };
    protected final Ruby runtime;
    private ObjectAllocator allocator;
    protected ObjectMarshal marshal;
    private Set<RubyClass> subclasses;
    protected static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) throws IOException {
            IRubyObject object = (IRubyObject)obj;
            marshalStream.registerLinkTarget(object);
            marshalStream.dumpVariables(object.getVariableList());
        }

        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject result = type2.allocate();
            unmarshalStream.registerLinkTarget(result);
            unmarshalStream.defaultVariablesUnmarshal(result);
            return result;
        }
    };

    public static void createClassClass(Ruby runtime2, RubyClass classClass) {
        classClass.index = 13;
        classClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyClass;
            }
        };
        classClass.undefineMethod("module_function");
        classClass.undefineMethod("append_features");
        classClass.undefineMethod("extend_object");
        classClass.defineAnnotatedMethods(RubyClass.class);
        classClass.addMethod("new", new SpecificArityNew(classClass, Visibility.PUBLIC));
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    public void setAllocator(ObjectAllocator allocator) {
        this.allocator = allocator;
    }

    @JRubyMethod(name={"allocate"})
    public IRubyObject allocate() {
        if (this.superClass == null) {
            throw this.runtime.newTypeError("can't instantiate uninitialized class");
        }
        IRubyObject obj = this.allocator.allocate(this.runtime, this);
        if (obj.getMetaClass().getRealClass() != this.getRealClass()) {
            throw this.runtime.newTypeError("wrong instance allocation");
        }
        return obj;
    }

    public CallSite[] getBaseCallSites() {
        return this.baseCallSites;
    }

    public CallSite[] getExtraCallSites() {
        return this.extraCallSites;
    }

    public int getNativeTypeIndex() {
        return 13;
    }

    public boolean isModule() {
        return false;
    }

    public boolean isClass() {
        return true;
    }

    public boolean isSingleton() {
        return false;
    }

    public static RubyClass createBootstrapClass(Ruby runtime2, String name2, RubyClass superClass, ObjectAllocator allocator) {
        RubyClass obj;
        if (superClass == null) {
            obj = new RubyClass(runtime2);
            obj.marshal = DEFAULT_OBJECT_MARSHAL;
        } else {
            obj = new RubyClass(runtime2, superClass);
        }
        obj.setAllocator(allocator);
        obj.setBaseName(name2);
        return obj;
    }

    protected RubyClass(Ruby runtime2, RubyClass superClass, boolean objectSpace) {
        super(runtime2, runtime2.getClassClass(), objectSpace);
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = MethodIndex.getFunctionalCallSite(CS_NAMES[i]);
        }
        this.runtime = runtime2;
        this.superClass = superClass;
    }

    protected RubyClass(Ruby runtime2, RubyClass superClass, RubyModule.Generation generation, boolean objectSpace) {
        super(runtime2, runtime2.getClassClass(), generation, objectSpace);
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = MethodIndex.getFunctionalCallSite(CS_NAMES[i]);
        }
        this.runtime = runtime2;
        this.superClass = superClass;
    }

    protected RubyClass(Ruby runtime2) {
        super(runtime2, runtime2.getClassClass());
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = MethodIndex.getFunctionalCallSite(CS_NAMES[i]);
        }
        this.runtime = runtime2;
        this.index = 13;
    }

    protected RubyClass(Ruby runtime2, RubyClass superClazz) {
        this(runtime2);
        this.superClass = superClazz;
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.infectBy(this.superClass);
    }

    protected RubyClass(Ruby runtime2, RubyClass superClazz, CallSite[] extraCallSites) {
        this(runtime2);
        this.superClass = superClazz;
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.extraCallSites = extraCallSites;
        this.infectBy(this.superClass);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass) {
        if (superClass == runtime2.getClassClass()) {
            throw runtime2.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime2.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime2, superClass);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, CallSite[] extraCallSites) {
        if (superClass == runtime2.getClassClass()) {
            throw runtime2.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime2.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime2, superClass, extraCallSites);
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent) {
        RubyClass clazz = RubyClass.newClass(runtime2, superClass);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    public static RubyClass newClass(Ruby runtime2, RubyClass superClass, String name2, ObjectAllocator allocator, RubyModule parent, boolean setParent, CallSite[] extraCallSites) {
        RubyClass clazz = RubyClass.newClass(runtime2, superClass, extraCallSites);
        clazz.setBaseName(name2);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name2, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    public RubyClass makeMetaClass(RubyClass superClass) {
        if (this.isSingleton()) {
            MetaClass klass = new MetaClass(this.runtime, superClass);
            this.setMetaClass(klass);
            klass.setAttached(this);
            klass.setMetaClass(klass);
            klass.setSuperClass(this.getSuperClass().getRealClass().getMetaClass());
            return klass;
        }
        return super.makeMetaClass(superClass);
    }

    @Deprecated
    public IRubyObject invoke(ThreadContext context, IRubyObject self, int methodIndex, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return this.invoke(context, self, name2, args2, callType, block);
    }

    public boolean notVisibleAndNotMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return !method2.isCallableFrom(caller2, callType) && !name2.equals("method_missing");
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, CallType callType, Block block) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, callType, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, CallType.FUNCTIONAL, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, CallType callType, Block block) {
        IRubyObject caller2;
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, args2, callType, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, args2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, args2, CallType.FUNCTIONAL, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, args2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2, CallType callType, Block block) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg2, callType, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg2, CallType.FUNCTIONAL, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType, Block block) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg0, arg1, callType, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg0, arg1, CallType.FUNCTIONAL, block);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType, Block block) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg0, arg1, arg2, callType, block);
        }
        return method2.call(context, self, this, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg0, arg1, arg2, CallType.FUNCTIONAL, block);
        }
        return method2.call(context, self, this, name2, arg0, arg1, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, CallType callType) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self, this, name2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self, this, name2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, CallType callType) {
        IRubyObject caller2;
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, args2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, args2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2) {
        assert (args2 != null);
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, args2, CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, args2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2, CallType callType) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg2, CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg2);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, CallType callType) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg0, arg1, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg0, arg1, CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType) {
        IRubyObject caller2;
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2, name2, caller2 = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg0, arg1, arg2, callType, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, arg2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        DynamicMethod method2 = this.searchMethod(name2);
        if (this.shouldCallMethodMissing(method2)) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, name2, arg0, arg1, arg2, CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this, name2, arg0, arg1, arg2);
    }

    private boolean shouldCallMethodMissing(DynamicMethod method2) {
        return method2.isUndefined();
    }

    private boolean shouldCallMethodMissing(DynamicMethod method2, String name2, IRubyObject caller2, CallType callType) {
        return method2.isUndefined() || this.notVisibleAndNotMethodMissing(method2, name2, caller2, callType);
    }

    public IRubyObject invokeInherited(ThreadContext context, IRubyObject self, IRubyObject subclass) {
        DynamicMethod method2 = this.getMetaClass().searchMethod("inherited");
        if (method2.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(context, self, method2, "inherited", CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method2.call(context, self, (RubyModule)this.getMetaClass(), "inherited", subclass, Block.NULL_BLOCK);
    }

    public IRubyObject newInstance(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, (IRubyObject)this, obj, args2, block);
        return obj;
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_8, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        this.checkNotInitialized();
        return this.initializeCommon(this.runtime.getObject(), block, false);
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_8, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject superObject, Block block) {
        this.checkNotInitialized();
        RubyClass.checkInheritable(superObject);
        return this.initializeCommon((RubyClass)superObject, block, false);
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_9, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, Block block) {
        this.checkNotInitialized();
        return this.initializeCommon(this.runtime.getObject(), block, true);
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_9, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, IRubyObject superObject, Block block) {
        this.checkNotInitialized();
        RubyClass.checkInheritable(superObject);
        return this.initializeCommon((RubyClass)superObject, block, true);
    }

    private IRubyObject initializeCommon(RubyClass superClazz, Block block, boolean callInheritBeforeSuper) {
        this.superClass = superClazz;
        this.allocator = superClazz.allocator;
        this.makeMetaClass(superClazz.getMetaClass());
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        if (callInheritBeforeSuper) {
            this.inherit(superClazz);
            super.initialize(block);
        } else {
            super.initialize(block);
            this.inherit(superClazz);
        }
        return this;
    }

    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this.superClass != null) {
            throw this.runtime.newTypeError("already initialized class");
        }
        if (original instanceof MetaClass) {
            throw this.runtime.newTypeError("can't copy singleton class");
        }
        super.initialize_copy(original);
        this.allocator = ((RubyClass)original).allocator;
        return this;
    }

    protected void setModuleSuperClass(RubyClass superClass) {
        if (this.superClass != null) {
            this.superClass.removeSubclass(this);
        }
        superClass.addSubclass(this);
        this.superClass = superClass;
    }

    public Collection subclasses(boolean includeDescendants) {
        if (this.subclasses != null) {
            ArrayList<RubyClass> mine = new ArrayList<RubyClass>(this.subclasses);
            if (includeDescendants) {
                for (RubyClass i : this.subclasses) {
                    mine.addAll(i.subclasses(includeDescendants));
                }
            }
            return mine;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void addSubclass(RubyClass subclass) {
        if (this.subclasses == null) {
            this.subclasses = new WeakHashSet<RubyClass>();
        }
        this.subclasses.add(subclass);
    }

    public synchronized void removeSubclass(RubyClass subclass) {
        if (this.subclasses == null) {
            return;
        }
        this.subclasses.remove(subclass);
    }

    protected void invalidateCacheDescendants() {
        super.invalidateCacheDescendants();
        if (this.subclasses != null) {
            for (RubyClass subclass : this.subclasses) {
                subclass.invalidateCacheDescendants();
            }
        }
    }

    public Ruby getClassRuntime() {
        return this.runtime;
    }

    public RubyClass getRealClass() {
        return this;
    }

    @JRubyMethod(name={"inherited"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject inherited(ThreadContext context, IRubyObject arg2) {
        return this.runtime.getNil();
    }

    public void inherit(RubyClass superClazz) {
        if (superClazz == null) {
            superClazz = this.runtime.getObject();
        }
        superClazz.invokeInherited(this.runtime.getCurrentContext(), superClazz, this);
    }

    @JRubyMethod(name={"superclass"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject superclass(ThreadContext context) {
        RubyClass superClazz = this.superClass;
        if (superClazz == null) {
            throw this.runtime.newTypeError("uninitialized class");
        }
        if (this.isSingleton()) {
            superClazz = this.metaClass;
        }
        while (superClazz != null && superClazz.isIncluded()) {
            superClazz = superClazz.superClass;
        }
        return superClazz != null ? superClazz : this.runtime.getNil();
    }

    @JRubyMethod(name={"superclass"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject superclass19(ThreadContext context) {
        RubyClass superClazz = this.superClass;
        if (superClazz == null) {
            if (this.metaClass == this.runtime.getBasicObject()) {
                return this.runtime.getNil();
            }
            throw this.runtime.newTypeError("uninitialized class");
        }
        while (superClazz != null && superClazz.isIncluded()) {
            superClazz = superClazz.superClass;
        }
        return superClazz != null ? superClazz : this.runtime.getNil();
    }

    private void checkNotInitialized() {
        if (this.superClass != null) {
            throw this.runtime.newTypeError("already initialized class");
        }
    }

    public static void checkInheritable(IRubyObject superClass) {
        if (!(superClass instanceof RubyClass)) {
            throw superClass.getRuntime().newTypeError("superclass must be a Class (" + superClass.getMetaClass() + " given)");
        }
        if (((RubyClass)superClass).isSingleton()) {
            throw superClass.getRuntime().newTypeError("can't make subclass of virtual class");
        }
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal marshal) {
        this.marshal = marshal;
    }

    public final void marshal(Object obj, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.runtime, obj, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.runtime, this, unmarshalStream);
    }

    public static void marshalTo(RubyClass clazz, MarshalStream output) throws IOException {
        output.registerLinkTarget(clazz);
        output.writeString(MarshalStream.getPathFromClass(clazz));
    }

    public static RubyClass unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyClass result = UnmarshalStream.getClassFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result);
        return result;
    }

    public static class SpecificArityNew
    extends JavaMethod {
        public SpecificArityNew(RubyModule implClass, Visibility visibility) {
            super(implClass, visibility);
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, self, obj, args2, block);
            return obj;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, self, obj, block);
            return obj;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, self, obj, arg0, block);
            return obj;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, self, obj, arg0, arg1, block);
            return obj;
        }

        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, self, obj, arg0, arg1, arg2, block);
            return obj;
        }
    }
}

