/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.CompatVersion;
import org.jruby.anno.JRubyMethod;
import org.jruby.util.CodegenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBinder
implements AnnotationProcessorFactory {
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("org.jruby.anno.JRubyMethod", "org.jruby.anno.JRubyClass"));
    private static final Collection<String> supportedOptions = Collections.emptySet();

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        return new AnnotationBindingProcessor(env);
    }

    private static class AnnotationBindingProcessor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;
        private final List<String> classNames = new ArrayList<String>();

        AnnotationBindingProcessor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        public void process() {
            for (TypeDeclaration typeDecl : this.env.getSpecifiedTypeDeclarations()) {
                typeDecl.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new RubyClassVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }
            try {
                FileWriter fw = new FileWriter("src_gen/annotated_classes.txt");
                for (String name2 : this.classNames) {
                    fw.write(name2);
                    fw.write(10);
                }
                fw.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static int getArityValue(JRubyMethod anno, int actualRequired) {
            if (anno.optional() > 0 || anno.rest()) {
                return -(actualRequired + 1);
            }
            return actualRequired;
        }

        public static String getCallConfigNameByAnno(JRubyMethod anno) {
            return AnnotationBindingProcessor.getCallConfigName(anno.frame(), anno.scope(), anno.backtrace());
        }

        public static String getCallConfigName(boolean frame, boolean scope, boolean backtrace2) {
            if (frame) {
                if (scope) {
                    return "FrameFullScopeFull";
                }
                return "FrameFullScopeNone";
            }
            if (scope) {
                if (backtrace2) {
                    return "FrameBacktraceScopeFull";
                }
                return "FrameNoneScopeFull";
            }
            if (backtrace2) {
                return "FrameBacktraceScopeNone";
            }
            return "FrameNoneScopeNone";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RubyClassVisitor
        extends SimpleDeclarationVisitor {
            private PrintStream out;
            private static final boolean DEBUG = false;

            private RubyClassVisitor() {
            }

            public void visitClassDeclaration(ClassDeclaration cd) {
                try {
                    String qualifiedName = cd.getQualifiedName().replace('.', '$');
                    if (!qualifiedName.contains("org$jruby")) {
                        return;
                    }
                    ByteArrayOutputStream bytes2 = new ByteArrayOutputStream(1024);
                    this.out = new PrintStream(bytes2);
                    this.out.println("/* THIS FILE IS GENERATED. DO NOT EDIT */");
                    this.out.println("package org.jruby.gen;");
                    this.out.println("import org.jruby.RubyModule;");
                    this.out.println("import org.jruby.RubyClass;");
                    this.out.println("import org.jruby.CompatVersion;");
                    this.out.println("import org.jruby.anno.TypePopulator;");
                    this.out.println("import org.jruby.internal.runtime.methods.CallConfiguration;");
                    this.out.println("import org.jruby.internal.runtime.methods.JavaMethod;");
                    this.out.println("import org.jruby.internal.runtime.methods.DynamicMethod;");
                    this.out.println("import org.jruby.runtime.Arity;");
                    this.out.println("import org.jruby.runtime.Visibility;");
                    this.out.println("import org.jruby.compiler.ASTInspector;");
                    this.out.println("import java.util.Arrays;");
                    this.out.println("import java.util.List;");
                    this.out.println("public class " + qualifiedName + "$Populator extends TypePopulator {");
                    this.out.println("    public void populate(RubyModule cls, Class clazz) {");
                    this.out.println("        JavaMethod javaMethod;");
                    this.out.println("        DynamicMethod moduleMethod;");
                    this.out.println("        RubyClass metaClass = cls.getMetaClass();");
                    this.out.println("        RubyModule singletonClass;");
                    this.out.println("        CompatVersion compatVersion = cls.getRuntime().getInstanceConfig().getCompatVersion();");
                    HashMap<String, List<MethodDeclaration>> annotatedMethods = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> annotatedMethods1_8 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods1_8 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> annotatedMethods1_9 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> staticAnnotatedMethods1_9 = new HashMap<String, List<MethodDeclaration>>();
                    HashSet<String> frameAwareMethods = new HashSet<String>();
                    int methodCount = 0;
                    for (MethodDeclaration md : cd.getMethods()) {
                        JRubyMethod anno = (JRubyMethod)md.getAnnotation(JRubyMethod.class);
                        if (anno == null) continue;
                        ++methodCount;
                        String name2 = anno.name().length == 0 ? md.getSimpleName() : anno.name()[0];
                        HashMap<String, List<MethodDeclaration>> methodsHash = null;
                        methodsHash = md.getModifiers().contains(Modifier.STATIC) ? (anno.compat() == CompatVersion.RUBY1_8 ? staticAnnotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? staticAnnotatedMethods1_9 : staticAnnotatedMethods)) : (anno.compat() == CompatVersion.RUBY1_8 ? annotatedMethods1_8 : (anno.compat() == CompatVersion.RUBY1_9 ? annotatedMethods1_9 : annotatedMethods));
                        ArrayList<MethodDeclaration> methodDescs = (ArrayList<MethodDeclaration>)methodsHash.get(name2);
                        if (methodDescs == null) {
                            methodDescs = new ArrayList<MethodDeclaration>();
                            methodsHash.put(name2, methodDescs);
                        }
                        methodDescs.add(md);
                        if (!anno.frame() && (anno.reads() == null || anno.reads().length < 1) && (anno.writes() == null || anno.writes().length < 1)) continue;
                        frameAwareMethods.add(name2);
                    }
                    if (methodCount == 0) {
                        return;
                    }
                    AnnotationBindingProcessor.this.classNames.add(this.getActualQualifiedName((TypeDeclaration)cd));
                    this.processMethodDeclarations(staticAnnotatedMethods);
                    if (!staticAnnotatedMethods1_8.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(staticAnnotatedMethods1_8);
                        this.out.println("        }");
                    }
                    if (!staticAnnotatedMethods1_9.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_9 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(staticAnnotatedMethods1_9);
                        this.out.println("        }");
                    }
                    this.processMethodDeclarations(annotatedMethods);
                    if (!annotatedMethods1_8.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(annotatedMethods1_8);
                        this.out.println("        }");
                    }
                    if (!annotatedMethods1_9.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_9 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(annotatedMethods1_9);
                        this.out.println("        }");
                    }
                    this.out.println("    }");
                    if (!frameAwareMethods.isEmpty()) {
                        StringBuffer frameMethodsString = new StringBuffer();
                        boolean first2 = true;
                        for (String name2 : frameAwareMethods) {
                            if (!first2) {
                                frameMethodsString.append(',');
                            }
                            first2 = false;
                            frameMethodsString.append('\"').append(name2).append('\"');
                        }
                        this.out.println("    static {");
                        this.out.println("        ASTInspector.FRAME_AWARE_METHODS.addAll((List<String>)Arrays.asList(" + frameMethodsString + "));");
                        this.out.println("     }");
                    }
                    this.out.println("}");
                    this.out.close();
                    this.out = null;
                    FileOutputStream fos = new FileOutputStream("src_gen/" + qualifiedName + "$Populator.java");
                    fos.write(bytes2.toByteArray());
                    fos.close();
                }
                catch (IOException ioe) {
                    System.err.println("FAILED TO GENERATE:");
                    ioe.printStackTrace();
                    System.exit(1);
                }
            }

            public void processMethodDeclarations(Map<String, List<MethodDeclaration>> declarations) {
                for (Map.Entry<String, List<MethodDeclaration>> entry : declarations.entrySet()) {
                    List<MethodDeclaration> list2 = entry.getValue();
                    if (list2.size() == 1) {
                        this.processMethodDeclaration(list2.get(0));
                        continue;
                    }
                    this.processMethodDeclarationMulti(list2.get(0));
                }
            }

            public void processMethodDeclaration(MethodDeclaration md) {
                JRubyMethod anno = (JRubyMethod)md.getAnnotation(JRubyMethod.class);
                if (anno != null && this.out != null) {
                    boolean isStatic = md.getModifiers().contains(Modifier.STATIC);
                    String qualifiedName = this.getActualQualifiedName(md.getDeclaringType());
                    boolean hasContext = false;
                    boolean hasBlock = false;
                    for (ParameterDeclaration pd : md.getParameters()) {
                        hasContext |= pd.getType().toString().equals("org.jruby.runtime.ThreadContext");
                        hasBlock |= pd.getType().toString().equals("org.jruby.runtime.Block");
                    }
                    int actualRequired = this.calculateActualRequired(md.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
                    String annotatedBindingName = CodegenUtils.getAnnotatedBindingClassName(md.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), false, anno.frame());
                    String implClass = anno.meta() ? "metaClass" : "cls";
                    this.out.println("        javaMethod = new " + annotatedBindingName + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ");");
                    this.out.println("        populateMethod(javaMethod, " + AnnotationBindingProcessor.getArityValue(anno, actualRequired) + ", \"" + md.getSimpleName() + "\", " + isStatic + ", " + "CallConfiguration." + AnnotationBindingProcessor.getCallConfigNameByAnno(anno) + ");");
                    this.generateMethodAddCalls(md, anno);
                }
            }

            public void processMethodDeclarationMulti(MethodDeclaration md) {
                JRubyMethod anno = (JRubyMethod)md.getAnnotation(JRubyMethod.class);
                if (anno != null && this.out != null) {
                    boolean isStatic = md.getModifiers().contains(Modifier.STATIC);
                    String qualifiedName = this.getActualQualifiedName(md.getDeclaringType());
                    boolean hasContext = false;
                    boolean hasBlock = false;
                    for (ParameterDeclaration pd : md.getParameters()) {
                        hasContext |= pd.getType().toString().equals("org.jruby.runtime.ThreadContext");
                        hasBlock |= pd.getType().toString().equals("org.jruby.runtime.Block");
                    }
                    int actualRequired = this.calculateActualRequired(md.getParameters().size(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
                    String annotatedBindingName = CodegenUtils.getAnnotatedBindingClassName(md.getSimpleName(), qualifiedName, isStatic, actualRequired, anno.optional(), true, anno.frame());
                    String implClass = anno.meta() ? "metaClass" : "cls";
                    this.out.println("        javaMethod = new " + annotatedBindingName + "(" + implClass + ", Visibility." + (Object)((Object)anno.visibility()) + ");");
                    this.out.println("        populateMethod(javaMethod, -1, \"" + md.getSimpleName() + "\", " + isStatic + ", " + "CallConfiguration." + AnnotationBindingProcessor.getCallConfigNameByAnno(anno) + ");");
                    this.generateMethodAddCalls(md, anno);
                }
            }

            private String getActualQualifiedName(TypeDeclaration td) {
                String qualifiedName = td.getDeclaringType() != null ? (td.getDeclaringType().getDeclaringType() != null ? td.getDeclaringType().getDeclaringType().getQualifiedName() + "$" + td.getDeclaringType().getSimpleName() + "$" + td.getSimpleName() : td.getDeclaringType().getQualifiedName() + "$" + td.getSimpleName()) : td.getQualifiedName();
                return qualifiedName;
            }

            private boolean tryClass(String className) {
                Class<?> tryClass = null;
                try {
                    tryClass = Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return tryClass != null;
            }

            private int calculateActualRequired(int paramsLength, int optional, boolean rest2, boolean isStatic, boolean hasContext, boolean hasBlock) {
                int actualRequired;
                if (optional == 0 && !rest2) {
                    int args2 = paramsLength;
                    if (args2 == 0) {
                        actualRequired = 0;
                    } else {
                        if (isStatic) {
                            --args2;
                        }
                        if (hasContext) {
                            --args2;
                        }
                        if (hasBlock) {
                            --args2;
                        }
                        actualRequired = args2;
                    }
                } else {
                    int args3 = paramsLength;
                    if (args3 == 0) {
                        actualRequired = 0;
                    } else {
                        if (isStatic) {
                            --args3;
                        }
                        if (hasContext) {
                            --args3;
                        }
                        if (hasBlock) {
                            --args3;
                        }
                        actualRequired = --args3;
                    }
                    if (actualRequired != 0) {
                        throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported");
                    }
                }
                return actualRequired;
            }

            public void generateMethodAddCalls(MethodDeclaration md, JRubyMethod jrubyMethod) {
                block18: {
                    String baseName;
                    block17: {
                        if (jrubyMethod.frame()) {
                            for (String name2 : jrubyMethod.name()) {
                                this.out.println("        ASTInspector.FRAME_AWARE_METHODS.add(\"" + name2 + "\");");
                            }
                        }
                        if (!jrubyMethod.meta()) break block17;
                        if (jrubyMethod.name().length == 0) {
                            baseName = md.getSimpleName();
                            this.out.println("        metaClass.addMethod(\"" + baseName + "\", javaMethod);");
                        } else {
                            baseName = jrubyMethod.name()[0];
                            for (String name3 : jrubyMethod.name()) {
                                this.out.println("        metaClass.addMethod(\"" + name3 + "\", javaMethod);");
                            }
                        }
                        if (jrubyMethod.alias().length <= 0) break block18;
                        for (String alias : jrubyMethod.alias()) {
                            this.out.println("        metaClass.defineAlias(\"" + alias + "\", \"" + baseName + "\");");
                        }
                        break block18;
                    }
                    if (jrubyMethod.name().length == 0) {
                        baseName = md.getSimpleName();
                        this.out.println("        cls.addMethod(\"" + baseName + "\", javaMethod);");
                    } else {
                        baseName = jrubyMethod.name()[0];
                        for (String name4 : jrubyMethod.name()) {
                            this.out.println("        cls.addMethod(\"" + name4 + "\", javaMethod);");
                        }
                    }
                    if (jrubyMethod.alias().length > 0) {
                        for (String alias : jrubyMethod.alias()) {
                            this.out.println("        cls.defineAlias(\"" + alias + "\", \"" + baseName + "\");");
                        }
                    }
                    if (jrubyMethod.module()) {
                        this.out.println("        moduleMethod = populateModuleMethod(cls, javaMethod);");
                        this.out.println("        singletonClass = moduleMethod.getImplementationClass();");
                        if (jrubyMethod.name().length == 0) {
                            baseName = md.getSimpleName();
                            this.out.println("        singletonClass.addMethod(\"" + baseName + "\", moduleMethod);");
                        } else {
                            baseName = jrubyMethod.name()[0];
                            for (String name4 : jrubyMethod.name()) {
                                this.out.println("        singletonClass.addMethod(\"" + name4 + "\", moduleMethod);");
                            }
                        }
                        if (jrubyMethod.alias().length > 0) {
                            for (String alias : jrubyMethod.alias()) {
                                this.out.println("        singletonClass.defineAlias(\"" + alias + "\", \"" + baseName + "\");");
                            }
                        }
                    }
                }
            }
        }
    }
}

