/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;

final class AllocatedNativeMemoryIO
extends NativeMemoryIO
implements AllocatedDirectMemoryIO {
    private final int size;
    private volatile boolean released = false;
    private volatile boolean autorelease = true;

    static final AllocatedNativeMemoryIO allocate(int size2, boolean clear2) {
        long memory = IO.allocateMemory(size2, clear2);
        return memory != 0L ? new AllocatedNativeMemoryIO(memory, size2) : null;
    }

    private AllocatedNativeMemoryIO(long address2, int size2) {
        super(address2);
        this.size = size2;
    }

    public void free() {
        if (!this.released) {
            IO.freeMemory(this.address);
            this.released = true;
        }
    }

    public void setAutoRelease(boolean release) {
        this.autorelease = release;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.released && this.autorelease) {
                IO.freeMemory(this.address);
                this.released = true;
            }
        }
        finally {
            super.finalize();
        }
    }
}

