/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.InvocationBuffer;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.Invocation;
import org.jruby.ext.ffi.jffi.ParameterMarshaller;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class CallbackMarshaller
implements ParameterMarshaller {
    private final CallbackInfo cbInfo;
    private final CallingConvention convention;

    public CallbackMarshaller(CallbackInfo cbInfo, CallingConvention convention) {
        this.cbInfo = cbInfo;
        this.convention = convention;
    }

    public void marshal(Invocation invocation, InvocationBuffer buffer, IRubyObject value2) {
        this.marshal(invocation.getThreadContext(), buffer, value2);
    }

    public void marshal(ThreadContext context, InvocationBuffer buffer, IRubyObject value2) {
        if (value2.isNil()) {
            buffer.putAddress(0L);
        } else {
            this.marshalParam(context, buffer, value2);
        }
    }

    void marshal(ThreadContext context, InvocationBuffer buffer, Block value2) {
        this.marshalParam(context, buffer, value2);
    }

    void marshalParam(ThreadContext context, InvocationBuffer buffer, Object value2) {
        Pointer cb = CallbackManager.getInstance().getCallback(context.getRuntime(), this.cbInfo, value2);
        buffer.putAddress(((CallbackManager.Callback)cb).getAddress());
    }

    public boolean needsInvocationSession() {
        return false;
    }
}

