/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Library;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.BasePointer;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::DynamicLibrary"}, parent="Object")
public class DynamicLibrary
extends RubyObject {
    @JRubyConstant
    public static final int RTLD_LAZY = 1;
    @JRubyConstant
    public static final int RTLD_NOW = 2;
    @JRubyConstant
    public static final int RTLD_LOCAL = 4;
    @JRubyConstant
    public static final int RTLD_GLOBAL = 8;
    private final Library library;
    private final String name;

    public static RubyClass createDynamicLibraryClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("DynamicLibrary", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass symClass = result.defineClassUnder("Symbol", module.fastGetClass("BasePointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        symClass.defineAnnotatedMethods(Symbol.class);
        result.defineAnnotatedMethods(DynamicLibrary.class);
        result.defineAnnotatedConstants(DynamicLibrary.class);
        return result;
    }

    private static final int getNativeLibraryFlags(IRubyObject rbFlags) {
        int f = 0;
        int flags = RubyNumeric.fix2int(rbFlags);
        f |= (flags & 1) != 0 ? 1 : 0;
        f |= (flags & 2) != 0 ? 2 : 0;
        f |= (flags & 4) != 0 ? 4 : 0;
        return f |= (flags & 8) != 0 ? 8 : 0;
    }

    public DynamicLibrary(Ruby runtime2, RubyClass klass, String name2, Library library) {
        super(runtime2, klass);
        this.name = name2;
        this.library = library;
    }

    final Library getNativeLibrary() {
        return this.library;
    }

    @JRubyMethod(name={"open"}, meta=true)
    public static final IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject libraryName, IRubyObject libraryFlags) {
        String libName = libraryName.isNil() ? null : libraryName.toString();
        try {
            Library library = Library.getCachedInstance(libName, DynamicLibrary.getNativeLibraryFlags(libraryFlags));
            if (library == null) {
                throw new UnsatisfiedLinkError(Library.getLastError());
            }
            return new DynamicLibrary(context.getRuntime(), (RubyClass)recv2, libName, library);
        }
        catch (UnsatisfiedLinkError ex) {
            throw context.getRuntime().newLoadError(String.format("Could not open library '%s' : %s", libName != null ? libName : "current process", ex.getMessage()));
        }
    }

    @JRubyMethod(name={"find_symbol"})
    public IRubyObject findSymbol(ThreadContext context, IRubyObject symbolName) {
        String sym = symbolName.toString();
        long address2 = this.library.getSymbolAddress(sym);
        if (address2 == 0L) {
            return context.getRuntime().getNil();
        }
        return new Symbol(context.getRuntime(), this, sym, address2);
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name(ThreadContext context) {
        return this.name != null ? RubyString.newString(context.getRuntime(), this.name) : context.getRuntime().getNil();
    }

    static final class Symbol
    extends BasePointer {
        private final DynamicLibrary library;
        private final String name;

        public Symbol(Ruby runtime2, DynamicLibrary library, String name2, long address2) {
            super(runtime2, FFIProvider.getModule(runtime2).fastGetClass("DynamicLibrary").fastGetClass("Symbol"), new NativeMemoryIO(address2), Long.MAX_VALUE);
            this.library = library;
            this.name = name2;
        }

        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect(ThreadContext context) {
            return RubyString.newString(context.getRuntime(), String.format("#<Library Symbol library=%s symbol=%s address=%#x>", this.library.name, this.name, this.getAddress()));
        }

        @JRubyMethod(name={"to_s"}, optional=1)
        public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
            return RubyString.newString(context.getRuntime(), this.name);
        }

        public final String toString() {
            return this.name;
        }

        final String getName() {
            return this.name;
        }
    }
}

