/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.Platform;
import java.nio.channels.ByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.jffi.AllocatedNativeMemoryIO;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.DynamicLibrary;
import org.jruby.ext.ffi.jffi.JFFIInvoker;
import org.jruby.ext.ffi.jffi.JFFIProvider;
import org.jruby.ext.ffi.jffi.NativeMemoryIO;
import org.jruby.ext.ffi.jffi.VariadicInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory
extends org.jruby.ext.ffi.Factory {
    public Factory() {
        if (!Platform.getPlatform().isSupported()) {
            throw new UnsatisfiedLinkError("JFFI backend not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Ruby runtime2, RubyModule ffi2) {
        super.init(runtime2, ffi2);
        RubyModule rubyModule = ffi2;
        synchronized (rubyModule) {
            if (ffi2.fastGetClass("DynamicLibrary") == null) {
                DynamicLibrary.createDynamicLibraryClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Invoker") == null) {
                JFFIInvoker.createInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("VariadicInvoker") == null) {
                VariadicInvoker.createVariadicInvokerClass(runtime2, ffi2);
            }
            if (ffi2.fastGetClass("Callback") == null) {
                CallbackManager.createCallbackClass(runtime2, ffi2);
            }
        }
    }

    @Override
    protected FFIProvider newProvider(Ruby runtime2) {
        return new JFFIProvider(runtime2);
    }

    @Override
    public <T> T loadLibrary(String libraryName, Class<T> libraryClass) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ByteChannel newByteChannel(int fd) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AllocatedDirectMemoryIO allocateDirectMemory(int size2, boolean clear2) {
        return AllocatedNativeMemoryIO.allocate(size2, clear2);
    }

    @Override
    public DirectMemoryIO wrapDirectMemory(long address2) {
        return address2 != 0L ? new NativeMemoryIO(address2) : null;
    }

    @Override
    public CallbackManager getCallbackManager() {
        return CallbackManager.getInstance();
    }
}

