/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

abstract class AbstractBuilder {
    protected final Log logger = LogFactory.getLog(this.getClass());

    AbstractBuilder() {
    }

    protected void setAttributes(Object target, Map<String, Object> attributes, Set<String> ignoredAttributes) {
        Map<String, Method> setters = ReflectionUtil.getSetters(target.getClass());
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            if (ignoredAttributes != null && ignoredAttributes.contains(entry.getKey())) continue;
            String setterName = ReflectionUtil.stripIllegalCharacters(entry.getKey());
            if ("source".equals(setterName)) {
                setterName = "src";
            } else if ("class".equals(setterName)) {
                setterName = "clazz";
            }
            Method setter = setters.get(setterName);
            if (setter == null && !setterName.endsWith("s") && (setter = setters.get(setterName + "s")) != null && !setter.getParameterTypes()[0].isAssignableFrom(Map.class)) {
                setter = null;
            }
            if (setter == null && !(target instanceof UserEvent) && !target.getClass().equals(ManagerResponse.class)) {
                this.logger.warn("Unable to set property '" + entry.getKey() + "' to '" + entry.getValue() + "' on " + target.getClass().getName() + ": no setter. Please report at https://github.com/asterisk-java/asterisk-java/issues");
                for (Map.Entry<String, Object> entry2 : attributes.entrySet()) {
                    this.logger.debug("Key: " + entry2.getKey() + " Value: " + entry2.getValue());
                }
            }
            if (setter == null) continue;
            try {
                Object value;
                Class<Object> dataType = setter.getParameterTypes()[0];
                if (dataType == Boolean.class) {
                    value = AstUtil.isTrue(entry.getValue());
                } else if (dataType.isAssignableFrom(String.class)) {
                    value = this.parseString(entry);
                } else if (dataType.isAssignableFrom(Map.class)) {
                    value = this.parseMap(entry);
                } else if (dataType.isAssignableFrom(Double.TYPE) || dataType.isAssignableFrom(Double.class)) {
                    value = this.parseDouble(entry);
                } else if (dataType.isAssignableFrom(Long.TYPE) || dataType.isAssignableFrom(Long.class)) {
                    value = this.parseLong(entry);
                } else if (dataType.isAssignableFrom(Integer.TYPE) || dataType.isAssignableFrom(Integer.class)) {
                    value = this.parseInteger(entry);
                } else {
                    try {
                        Constructor<?> constructor = dataType.getConstructor(String.class);
                        value = dataType.isAssignableFrom(Boolean.class) ? constructor.newInstance(AstUtil.convertAsteriskBooleanStringToStandardBooleanString((String)entry.getValue())) : constructor.newInstance(entry.getValue());
                    }
                    catch (Exception e) {
                        this.logger.error("Unable to convert value: Called the constructor of " + dataType + " with value '" + entry.getValue() + "' for the attribute '" + entry.getKey() + "'\n of event type " + target.getClass().getName() + " with resulting error: " + e.getMessage(), e);
                        continue;
                    }
                }
                setter.invoke(target, value);
            }
            catch (Exception e) {
                this.logger.error("Unable to set property '" + entry.getKey() + "' to '" + entry.getValue() + "' on " + target.getClass().getName() + " " + e.getMessage(), e);
            }
        }
    }

    private Integer parseInteger(Map.Entry<String, Object> entry) {
        String stringValue = (String)entry.getValue();
        Integer value = stringValue != null && stringValue.length() > 0 ? Integer.valueOf(Integer.parseInt(stringValue)) : null;
        return value;
    }

    private Map<String, String> parseMap(Map.Entry<String, Object> entry) {
        Map<String, String> value;
        if (entry.getValue() instanceof List) {
            List list = (List)entry.getValue();
            value = this.buildMap(list.toArray(new String[list.size()]));
        } else {
            value = entry.getValue() instanceof String ? this.buildMap((String)entry.getValue()) : null;
        }
        return value;
    }

    private Object parseString(Map.Entry<String, Object> entry) {
        Object value = entry.getValue();
        if (AstUtil.isNull(value)) {
            value = null;
        }
        if (value instanceof List) {
            StringBuilder strBuff = new StringBuilder();
            for (String tmp : (List)value) {
                if (tmp == null || tmp.length() == 0) continue;
                strBuff.append(tmp).append('\n');
            }
            value = strBuff.toString();
        }
        return value;
    }

    private Double parseDouble(Map.Entry<String, Object> entry) {
        String stringValue = (String)entry.getValue();
        Double value = stringValue != null && stringValue.length() > 0 ? Double.valueOf(Double.parseDouble(stringValue)) : null;
        return value;
    }

    private Long parseLong(Map.Entry<String, Object> entry) {
        String stringValue = (String)entry.getValue();
        Long value = stringValue != null && stringValue.length() > 0 ? Long.valueOf(Long.parseLong(stringValue)) : null;
        return value;
    }

    private Map<String, String> buildMap(String ... lines) {
        if (lines == null) {
            return null;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String line : lines) {
            int index = line.indexOf(61);
            if (index > 0) {
                String key = line.substring(0, index);
                String value = line.substring(index + 1, line.length());
                map.put(key, value);
                continue;
            }
            this.logger.warn("Malformed line '" + line + "' for a map property");
        }
        return map;
    }
}

