/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.agi.config;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;
import org.asteriskjava.fastagi.MappingStrategy;
import org.asteriskjava.pbx.agi.config.DuplicateScriptException;
import org.asteriskjava.pbx.agi.config.ServiceAgiScript;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AgiMappingStragegy
implements MappingStrategy {
    private static final Log logger = LogFactory.getLog(AgiMappingStragegy.class);
    private Map<String, Class<ServiceAgiScript>> handlers = new HashMap<String, Class<ServiceAgiScript>>();

    @Override
    public AgiScript determineScript(AgiRequest request, AgiChannel channel) {
        AgiScript ret = null;
        String script = request.getScript();
        if (script.indexOf(".") != -1) {
            script = script.substring(0, script.indexOf("."));
        }
        if (script.startsWith("/")) {
            script = script.substring(1);
        }
        Iterator<String> itr = request.getParameterMap().keySet().iterator();
        logger.debug("*********************************");
        logger.debug("script " + script);
        while (itr.hasNext()) {
            String key = itr.next();
            String val = request.getParameter(key);
            if (key.compareToIgnoreCase("cardNumber") == 0) {
                val = "suppressed";
            }
            logger.debug(key + ": " + val);
        }
        logger.debug("******");
        if (this.handlers.containsKey(script)) {
            try {
                ret = this.handlers.get(script).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error(e, e);
            }
        }
        return ret;
    }

    public void addServiceAgiScript(Class<? extends ServiceAgiScript> handler) throws DuplicateScriptException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        logger.info("loading agi handler {}" + handler.getCanonicalName());
        ServiceAgiScript tmpHandler = handler.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (this.handlers.containsKey(tmpHandler.getScriptName())) {
            throw new DuplicateScriptException("Script " + tmpHandler.getScriptName() + " already exists");
        }
        String[] parameters = tmpHandler.getParameters();
        String sample = "Agi(agi://localhost/" + tmpHandler.getScriptName() + ".agi";
        logger.info("********************************************");
        logger.info("registered new agi script: " + tmpHandler.getScriptName());
        for (int i = 0; i < parameters.length; ++i) {
            logger.info("parameter: " + parameters[i]);
            sample = i == 0 ? sample + "?" + parameters[i] + "=testdata" : sample + "&" + parameters[i] + "=testdata";
        }
        logger.info("sample usage...");
        logger.info(sample + ")");
        Class<? extends ServiceAgiScript> handler2 = handler;
        this.handlers.put(tmpHandler.getScriptName(), handler2);
    }
}

