/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.asteriskjava.lock.Lockable;
import org.asteriskjava.lock.LockableList;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.InvalidChannelName;
import org.asteriskjava.pbx.ListenerPriority;
import org.asteriskjava.pbx.asterisk.wrap.actions.StatusAction;
import org.asteriskjava.pbx.asterisk.wrap.events.HangupEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.MasqueradeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.RenameEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ResponseEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.ResponseEvents;
import org.asteriskjava.pbx.asterisk.wrap.events.StatusEvent;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.pbx.internal.core.CoherentManagerConnection;
import org.asteriskjava.pbx.internal.core.FilteredManagerListener;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class LiveChannelManager
extends Lockable
implements FilteredManagerListener<ManagerEvent> {
    private static final Log logger = LogFactory.getLog(LiveChannelManager.class);
    private final LockableList<ChannelProxy> _liveChannels = new LockableList(new CopyOnWriteArrayList());

    public LiveChannelManager() {
        CoherentManagerConnection.getInstance().addListener(this);
    }

    void performPostCreationTasks() {
        StatusAction statusAction = new StatusAction();
        try {
            ResponseEvents events = CoherentManagerConnection.sendEventGeneratingAction(statusAction, 1000);
            for (ResponseEvent event : events.getEvents()) {
                if (!(event instanceof StatusEvent)) continue;
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | TimeoutException e) {
            logger.error(e, e);
        }
    }

    public ChannelProxy getChannelByEndPoint(EndPoint endPoint) {
        ChannelProxy connectedChannel = null;
        for (ChannelProxy channel : this._liveChannels) {
            if (!channel.isConnectedTo(endPoint)) continue;
            connectedChannel = channel;
            break;
        }
        return connectedChannel;
    }

    public void add(ChannelProxy proxy) {
        try (Locker.LockCloser closer = this._liveChannels.withLock();){
            ChannelProxy index = this.findProxy(proxy);
            if (index == null) {
                this._liveChannels.add(proxy);
            }
        }
        logger.debug("Adding liveChannel " + proxy);
        this.dumpProxies(proxy, "Add");
        this.sanityCheck();
    }

    private void dumpProxies(ChannelProxy proxy, String cause) {
        if (logger.isDebugEnabled()) {
            logger.debug("Dump of LiveChannels, cause:" + cause + ": " + proxy);
            for (ChannelProxy aProxy : this._liveChannels) {
                logger.debug("ChannelProxy: " + aProxy);
            }
        }
    }

    public void remove(ChannelProxy proxy) {
        ChannelProxy index = this.findProxy(proxy);
        if (index != null) {
            logger.info("Removing liveChannel " + proxy);
            this._liveChannels.remove(index);
        }
        this.dumpProxies(proxy, "Removing");
    }

    public ChannelProxy findChannel(String extendedChannelName, String uniqueID) {
        ChannelProxy proxy = null;
        logger.debug("Trying to find channel " + extendedChannelName + " " + uniqueID);
        String localUniqueId = uniqueID;
        if (localUniqueId == null) {
            localUniqueId = "-1";
        }
        if (localUniqueId.compareTo("-1") != 0) {
            for (ChannelProxy aChannel : this._liveChannels) {
                if (!aChannel.sameUniqueID(localUniqueId)) continue;
                proxy = aChannel;
                break;
            }
        }
        if (proxy == null) {
            for (ChannelProxy aChannel : this._liveChannels) {
                if (!aChannel.isSame(extendedChannelName, localUniqueId)) continue;
                proxy = aChannel;
                break;
            }
        }
        if (proxy == null) {
            logger.debug("Failed to match channel to any of...");
            for (ChannelProxy aChannel : this._liveChannels) {
                logger.debug(aChannel);
            }
        }
        return proxy;
    }

    private ChannelProxy findProxy(Channel original) {
        for (ChannelProxy aChannel : this._liveChannels) {
            if (!aChannel.isSame(original)) continue;
            return aChannel;
        }
        return null;
    }

    public HashSet<Class<? extends ManagerEvent>> requiredEvents() {
        HashSet<Class<? extends ManagerEvent>> required = new HashSet<Class<? extends ManagerEvent>>();
        required.add(MasqueradeEvent.class);
        required.add(RenameEvent.class);
        required.add(HangupEvent.class);
        required.add(NewChannelEvent.class);
        return required;
    }

    ChannelProxy findProxyById(String id) {
        for (ChannelProxy aChannel : this._liveChannels) {
            if (!("" + aChannel.getIdentity()).equals(id)) continue;
            return aChannel;
        }
        return null;
    }

    @Override
    public void onManagerEvent(ManagerEvent event) {
        if (event instanceof MasqueradeEvent) {
            MasqueradeEvent masq = (MasqueradeEvent)event;
            ChannelProxy originalIndex = this.findProxy(masq.getOriginal());
            ChannelProxy cloneIndex = this.findProxy(masq.getClone());
            if (originalIndex != null && cloneIndex != null) {
                ChannelProxy originalProxy = (ChannelProxy)masq.getOriginal();
                ChannelProxy cloneProxy = (ChannelProxy)masq.getClone();
                try {
                    originalProxy.masquerade(cloneProxy);
                    this.dumpProxies(cloneProxy, "Masquerade");
                    this.sanityCheck();
                }
                catch (InvalidChannelName e) {
                    logger.error(e, e);
                }
            } else {
                logger.error("Either the clone or original channelProxy was missing during a masquerade: cloneIndex=" + cloneIndex + " originalIndex=" + originalIndex);
            }
        }
        if (event instanceof RenameEvent) {
            RenameEvent rename = (RenameEvent)event;
            ChannelProxy oldChannel = this.findProxy(rename.getChannel());
            if (oldChannel != null) {
                try {
                    oldChannel.rename(rename.getNewName(), rename.getUniqueId());
                    this.dumpProxies(oldChannel, "RenameEvent");
                    this.sanityCheck();
                }
                catch (InvalidChannelName e) {
                    logger.error(e, e);
                }
            } else {
                String message = "Unable to rename channel -> Failed to find channel " + rename.getChannel();
                logger.warn(message);
                this.dumpProxies(null, message);
            }
        } else if (event instanceof HangupEvent) {
            HangupEvent hangup = (HangupEvent)event;
            if (hangup.getChannel() != null) {
                ChannelProxy proxy = this.findProxy(hangup.getChannel());
                if (proxy != null) {
                    logger.debug("Removing proxy " + proxy);
                    this._liveChannels.remove(proxy);
                    logger.debug("Removing liveChannel " + proxy);
                    proxy.getChannel().notifyHangupListeners(hangup.getCause(), hangup.getCauseTxt());
                    this.dumpProxies(proxy, "HangupEvent");
                }
            } else {
                logger.error("Didn't remove hungup channel");
            }
        }
    }

    @Override
    public String getName() {
        return "LiveChannelManager";
    }

    @Override
    public ListenerPriority getPriority() {
        return ListenerPriority.CRITICAL;
    }

    public void sanityCheck() {
        if (logger.isDebugEnabled()) {
            logger.error("Performing Sanity Check");
            HashSet<String> channels = new HashSet<String>();
            for (ChannelProxy channel : this._liveChannels) {
                if (channels.add(channel.getChannel().getExtendedChannelName())) continue;
                logger.error("Multiple channels by the name " + channel.getChannel().getExtendedChannelName() + " exist");
                for (ChannelProxy channel2 : this._liveChannels) {
                    if (!channel2.getChannel().getExtendedChannelName().equals(channel.getChannel().getExtendedChannelName())) continue;
                    logger.error(channel2);
                }
                Exception ex = new Exception("called from here");
                logger.error(ex, ex);
            }
        }
    }

    public List<ChannelProxy> getChannelList() {
        LinkedList<ChannelProxy> channels = new LinkedList<ChannelProxy>();
        channels.addAll(this._liveChannels);
        return channels;
    }
}

