/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.LinkedList;
import org.asteriskjava.lock.LockableList;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.EndPoint;
import org.asteriskjava.pbx.asterisk.wrap.events.MasqueradeEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewChannelEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.NewStateEvent;
import org.asteriskjava.pbx.asterisk.wrap.events.StatusEvent;
import org.asteriskjava.pbx.internal.core.CallEndedListener;
import org.asteriskjava.pbx.internal.core.CallTracker;
import org.asteriskjava.pbx.internal.core.ChannelProxy;
import org.asteriskjava.pbx.internal.core.PeerState;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class Peer
implements CallEndedListener {
    private static final Log logger = LogFactory.getLog(Peer.class);
    private final EndPoint peerEndPoint;
    private final LockableList<CallTracker> callList = new LockableList(new LinkedList());
    private PeerState _state = PeerState.NOTSET;
    private boolean dnd = false;

    public Peer(EndPoint endPoint) {
        this.peerEndPoint = endPoint;
    }

    public boolean isSame(Peer rhs) {
        return this.peerEndPoint.isSame(rhs.getEndPoint());
    }

    private CallTracker registerChannel(Channel newChannel) {
        CallTracker associatedCall = null;
        boolean found = false;
        try (Locker.LockCloser closer = this.callList.withLock();){
            for (CallTracker call : this.callList) {
                if (call.findChannel(newChannel) == -1) continue;
                found = true;
                associatedCall = call;
                break;
            }
            if (!found) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Peer adding Call: " + this.toString() + " " + newChannel.getExtendedChannelName());
                }
                associatedCall = this.createCallTracker(newChannel);
                this.dumpCallList();
            }
        }
        return associatedCall;
    }

    private CallTracker createCallTracker(Channel newChannel) {
        CallTracker newCall;
        try (Locker.LockCloser closer = this.callList.withLock();){
            newCall = new CallTracker(this, newChannel);
            this.callList.add(newCall);
        }
        return newCall;
    }

    public boolean getDND() {
        return this.dnd;
    }

    public PeerState getState() {
        return this._state;
    }

    private boolean isConnectedToSelf(Channel channel) {
        return this.getEndPoint().isSame(channel.getEndPoint());
    }

    public void handleEvent(MasqueradeEvent b) {
        if (this.isConnectedToSelf(b.getClone())) {
            CallTracker original = this.findCall(b.getOriginal());
            CallTracker clone = this.findCall(b.getClone());
            if (original != null && clone != null) {
                clone.mergeCalls(original);
                clone.setState(b.getCloneState());
                this.evaluateState();
            } else {
                logger.warn("When processing masquradeEvent we could not find the expected calls. event=" + b.toString() + " original=" + original + " clone=" + clone);
            }
        }
    }

    public void handleEvent(NewChannelEvent b) {
        CallTracker call;
        if (b.getChannel() == null || b.getChannel().isConsole()) {
            return;
        }
        if (this.isConnectedToSelf(b.getChannel()) && (call = this.registerChannel(b.getChannel())) != null) {
            call.setState(b.getChannelState());
            this.evaluateState();
        }
    }

    public void handleEvent(NewStateEvent b) {
        CallTracker call;
        if (this.isConnectedToSelf(b.getChannel()) && (call = this.registerChannel(b.getChannel())) != null) {
            call.setState(b.getChannelState());
            this.evaluateState();
        }
    }

    public void handleEvent(StatusEvent b) {
        Channel channel = b.getChannel();
        if (this.isConnectedToSelf(channel)) {
            ((ChannelProxy)channel).getRealChannel().markChannel();
            CallTracker call = this.findCall(channel);
            if (call != null) {
                call.setState(b.getState());
                this.evaluateState();
            }
        }
    }

    private CallTracker findCall(Channel channel) {
        CallTracker result = null;
        try (Locker.LockCloser closer = this.callList.withLock();){
            for (CallTracker call : this.callList) {
                if (call.findChannel(channel) == -1) continue;
                result = call;
                break;
            }
        }
        return result;
    }

    public void setDND(boolean on) {
        this.dnd = on;
    }

    public void startSweep() {
        logger.debug("Starting sweep for " + this.peerEndPoint.getFullyQualifiedName());
        try (Locker.LockCloser closer = this.callList.withLock();){
            for (CallTracker call : this.callList) {
                call.startSweep();
            }
        }
    }

    public void endSweep() {
        logger.debug("Ending sweep for " + this.peerEndPoint.getFullyQualifiedName());
        try (Locker.LockCloser closer = this.callList.withLock();){
            for (CallTracker call : this.callList) {
                call.endSweep();
            }
        }
        this.evaluateState();
    }

    private void evaluateState() {
        try (Locker.LockCloser closer = this.callList.withLock();){
            PeerState newState = PeerState.NOTSET;
            for (CallTracker call : this.callList) {
                if (call.getState().getPriority() <= newState.getPriority()) continue;
                newState = call.getState();
            }
            this._state = newState;
        }
    }

    public EndPoint getEndPoint() {
        return this.peerEndPoint;
    }

    public String toString() {
        return this.getEndPoint().toString();
    }

    private void dumpCallList() {
        if (logger.isDebugEnabled()) {
            logger.debug("Peer: dump CallList:" + this);
            for (CallTracker call : this.callList) {
                call.dumpChannelList();
            }
        }
    }

    @Override
    public void callEnded(CallTracker call) {
        boolean found = false;
        try (Locker.LockCloser closer = this.callList.withLock();){
            for (CallTracker aCall : this.callList) {
                if (call != aCall) continue;
                found = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("peer Removing call " + call);
                }
                this.callList.remove(call);
                this.evaluateState();
                this.dumpCallList();
                break;
            }
            if (!found) {
                logger.error("Error call not found removing call from peer: call=" + call + " peer=" + this);
                this.dumpCallList();
            }
        }
    }
}

