/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus;

import com.caucho.config.ConfigException;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.QuercusRuntimeException;
import com.caucho.quercus.annotation.ClassImplementation;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.SessionArrayValue;
import com.caucho.quercus.env.StringBuilderValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.UnicodeBuilderValue;
import com.caucho.quercus.env.UnicodeValueImpl;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.db.JavaSqlDriverWrapper;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.lib.session.QuercusSessionManager;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.ModuleInfo;
import com.caucho.quercus.module.ModuleStartupListener;
import com.caucho.quercus.module.QuercusModule;
import com.caucho.quercus.page.InterpretedPage;
import com.caucho.quercus.page.PageManager;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.parser.QuercusParser;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.quercus.program.ClassDef;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.quercus.program.UndefinedFunction;
import com.caucho.util.Alarm;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.util.LruCache;
import com.caucho.util.TimedCache;
import com.caucho.vfs.FilePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.Statement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Quercus {
    private static L10N L = new L10N(Quercus.class);
    private static final Logger log = Log.open(Quercus.class);
    private static HashSet<String> _superGlobals = new HashSet();
    private static IniDefinitions _ini = new IniDefinitions();
    private final PageManager _pageManager;
    private final QuercusSessionManager _sessionManager;
    private final ClassLoader _loader;
    private ModuleContext _moduleContext;
    private HashMap<String, StringValue> _internMap = new HashMap();
    private HashMap<String, ModuleInfo> _modules = new HashMap();
    private HashSet<ModuleStartupListener> _moduleStartupListeners = new HashSet();
    private HashSet<String> _extensionSet = new HashSet();
    private HashMap<String, Value> _constMap = new HashMap();
    private HashMap<String, AbstractFunction> _funMap = new HashMap();
    private HashMap<String, AbstractFunction> _lowerFunMap = new HashMap();
    private HashMap<String, JavaClassDef> _javaClassWrappers = new HashMap();
    private HashMap<String, JavaClassDef> _lowerJavaClassWrappers = new HashMap();
    private final IniDefinitions _iniDefinitions = new IniDefinitions();
    private IdentityHashMap<String, Value> _iniMap;
    private HashMap<Value, Value> _serverEnvMap = new HashMap();
    private IntMap _classNameMap = new IntMap(8192);
    private ClassDef[] _classMap = new ClassDef[256];
    private IntMap _constantNameMap = new IntMap(8192);
    private IntMap _functionNameMap = new IntMap(8192);
    private AbstractFunction[] _functionMap = new AbstractFunction[256];
    private LruCache<String, QuercusProgram> _evalCache = new LruCache(4096);
    private int _includeCacheMax = 8192;
    private long _includeCacheTimeout = 10000L;
    private TimedCache<IncludeKey, Path> _includeCache;
    private long _defCacheHitCount;
    private long _defCacheMissCount;
    private LruCache<String, SessionArrayValue> _sessionMap = new LruCache(4096);
    private HashMap<String, Object> _specialMap = new HashMap();
    private String _scriptEncoding;
    private String _phpVersion = "5.2.0";
    private String _mySqlVersion;
    private boolean _isStrict;
    private boolean _isRequireSource;
    private boolean _isConnectionPool = true;
    private DataSource _database;
    private HashMap<String, DataSource> _databaseMap = new HashMap();
    private long _staticId;
    private Path _pwd;
    private Path _workDir;
    private ServletContext _servletContext;
    public static final IniDefinition INI_INCLUDE_PATH;
    public static final IniDefinition INI_REGISTER_LONG_ARRAYS;
    public static final IniDefinition INI_ALWAYS_POPULATE_RAW_POST_DATA;
    public static final IniDefinition INI_UNICODE_SEMANTICS;
    public static final IniDefinition INI_UNICODE_FALLBACK_ENCODING;
    public static final IniDefinition INI_UNICODE_FROM_ERROR_MODE;
    public static final IniDefinition INI_UNICODE_FROM_ERROR_SUBST_CHAR;
    public static final IniDefinition INI_UNICODE_HTTP_INPUT_ENCODING;
    public static final IniDefinition INI_UNICODE_OUTPUT_ENCODING;
    public static final IniDefinition INI_UNICODE_RUNTIME_ENCODING;
    public static final IniDefinition INI_UNICODE_SCRIPT_ENCODING;

    public Quercus() {
        this._loader = Thread.currentThread().getContextClassLoader();
        this._moduleContext = this.getLocalContext();
        this._pageManager = this.createPageManager();
        this._sessionManager = this.createSessionManager();
    }

    public Path getPwd() {
        if (this._pwd == null) {
            this._pwd = new FilePath(System.getProperty("user.dir"));
        }
        return this._pwd;
    }

    public void setPwd(Path path) {
        this._pwd = path;
    }

    public Path getWorkDir() {
        if (this._workDir == null) {
            this._workDir = this.getPwd().lookup("WEB-INF/work");
        }
        return this._workDir;
    }

    public void setWorkDir(Path workDir) {
        this._workDir = workDir;
    }

    public String getCookieName() {
        return "JSESSIONID";
    }

    public long getDependencyCheckInterval() {
        return 2000L;
    }

    public int getIncludeCacheMax() {
        return this._includeCacheMax;
    }

    public void setIncludeCacheMax(int cacheMax) {
        this._includeCacheMax = cacheMax;
    }

    public void setIncludeCacheTimeout(long timeout) {
        this._includeCacheTimeout = timeout;
    }

    public long getIncludeCacheTimeout() {
        return this._includeCacheTimeout;
    }

    public String getVersion() {
        return "Open Source 3.2.0";
    }

    public String getVersionDate() {
        return "20070628T2777";
    }

    protected PageManager createPageManager() {
        return new PageManager(this);
    }

    protected QuercusSessionManager createSessionManager() {
        return new QuercusSessionManager();
    }

    public final ModuleContext getLocalContext() {
        return this.getLocalContext(this._loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleContext getLocalContext(ClassLoader loader) {
        Quercus quercus = this;
        synchronized (quercus) {
            if (this._moduleContext == null) {
                this._moduleContext = this.createModuleContext(loader);
            }
        }
        return this._moduleContext;
    }

    protected ModuleContext createModuleContext(ClassLoader loader) {
        return new ModuleContext(loader);
    }

    public ModuleContext getModuleContext() {
        return this._moduleContext;
    }

    public QuercusSessionManager getQuercusSessionManager() {
        return this._sessionManager;
    }

    public boolean isCompile() {
        return this._pageManager.isCompile();
    }

    public boolean isPro() {
        return false;
    }

    public boolean isResin() {
        return false;
    }

    public boolean isUnicodeSemantics() {
        boolean value = this.getIniBoolean("unicode.semantics");
        return value;
    }

    public boolean isAllowUrlInclude() {
        return this.getIniBoolean("allow_url_include");
    }

    public boolean isAllowUrlFopen() {
        return this.getIniBoolean("allow_url_fopen");
    }

    public StringValue createString(String v) {
        if (this.isUnicodeSemantics()) {
            return new UnicodeBuilderValue(v);
        }
        return new StringBuilderValue(v);
    }

    public void setCompile(boolean isCompile) {
        this._pageManager.setCompile(isCompile);
    }

    public void setLazyCompile(boolean isCompile) {
        this._pageManager.setLazyCompile(isCompile);
    }

    public void setCompileFailover(boolean isCompileFailover) {
        this._pageManager.setCompileFailover(isCompileFailover);
    }

    public String getScriptEncoding() {
        if (this._scriptEncoding != null) {
            return this._scriptEncoding;
        }
        if (this.isUnicodeSemantics()) {
            return "utf-8";
        }
        return "iso-8859-1";
    }

    public void setScriptEncoding(String encoding) {
        this._scriptEncoding = encoding;
    }

    public String getMysqlVersion() {
        return this._mySqlVersion;
    }

    public void setMysqlVersion(String version) {
        this._mySqlVersion = version;
    }

    public String getPhpVersion() {
        return this._phpVersion;
    }

    public void setPhpVersion(String version) {
        this._phpVersion = version;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setDatabase(DataSource database) {
        this._database = database;
    }

    public DataSource getDatabase() {
        return this._database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource findDatabase(String driver, String url) {
        if (this._database != null) {
            return this._database;
        }
        try {
            HashMap<String, DataSource> hashMap = this._databaseMap;
            synchronized (hashMap) {
                String key = driver + ";" + url;
                DataSource database = this._databaseMap.get(key);
                if (database != null) {
                    return database;
                }
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cls = loader.loadClass(driver);
                Object ds = cls.newInstance();
                database = ds instanceof DataSource ? (DataSource)ds : new JavaSqlDriverWrapper((Driver)ds, url);
                this._databaseMap.put(key, database);
                return database;
            }
        }
        catch (ClassNotFoundException e) {
            throw new QuercusModuleException(e);
        }
        catch (InstantiationException e) {
            throw new QuercusModuleException(e);
        }
        catch (IllegalAccessException e) {
            throw new QuercusModuleException(e);
        }
    }

    public void markForPoolRemoval(Connection conn) {
    }

    public Connection getConnection(Connection conn) {
        return conn;
    }

    public Statement getStatement(Statement stmt) {
        return stmt;
    }

    public void setStrict(boolean isStrict) {
        this._isStrict = isStrict;
    }

    public boolean isStrict() {
        return this._isStrict;
    }

    public int getPageCacheEntries() {
        return this._pageManager.getPageCacheEntries();
    }

    public void setPageCacheEntries(int entries) {
        this._pageManager.setPageCacheEntries(entries);
    }

    public void setRequireSource(boolean isRequireSource) {
        this._isRequireSource = isRequireSource;
    }

    public boolean isRequireSource() {
        return this._isRequireSource;
    }

    public void setConnectionPool(boolean isEnable) {
        this._isConnectionPool = isEnable;
    }

    public boolean isConnectionPool() {
        return this._isConnectionPool;
    }

    public void addModule(QuercusModule module) throws ConfigException {
        try {
            this.introspectPhpModuleClass(module.getClass());
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void addJavaClass(String name, Class type) throws ConfigException {
        try {
            if (type.isAnnotationPresent(ClassImplementation.class)) {
                this.introspectJavaImplClass(name, type, null);
            } else {
                this.introspectJavaClass(name, type, null, null);
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void addJavaClass(String phpName, String className) {
        Class<?> type;
        try {
            type = Class.forName(className, false, this._loader);
        }
        catch (ClassNotFoundException e) {
            throw new QuercusRuntimeException(L.l("`{0}' not valid: {1}", (Object)className, (Object)e.toString()), e);
        }
        this.addJavaClass(phpName, type);
    }

    public void addImplClass(String name, Class type) throws ConfigException {
        try {
            this.introspectJavaImplClass(name, type, null);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClassDef getJavaClassDefinition(Class type, String className) {
        JavaClassDef def;
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            def = this._javaClassWrappers.get(className);
            if (def == null) {
                try {
                    def = this.getModuleContext().getJavaClassDefinition(type, className);
                    this._javaClassWrappers.put(className, def);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new QuercusRuntimeException(e);
                }
            }
        }
        def.init();
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaClassDef getJavaClassDefinition(String className) {
        JavaClassDef def;
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            def = this._javaClassWrappers.get(className);
            if (def == null) {
                try {
                    def = this.getModuleContext().getJavaClassDefinition(className);
                    this._javaClassWrappers.put(className, def);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new QuercusRuntimeException(e);
                }
            }
        }
        def.init();
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDef findJavaClassWrapper(String name) {
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            ClassDef def = this._javaClassWrappers.get(name);
            if (def != null) {
                return def;
            }
            return this._lowerJavaClassWrappers.get(name.toLowerCase());
        }
    }

    public void setIniFile(Path path) {
        Env env;
        Value result;
        if (path.canRead() && (result = FileModule.parse_ini_file(env = new Env(this), path, false)) instanceof ArrayValue) {
            ArrayValue array = (ArrayValue)result;
            for (Map.Entry<Value, Value> entry : array.entrySet()) {
                this.setIni(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    public IniDefinitions getIniDefinitions() {
        return this._iniDefinitions;
    }

    public IdentityHashMap<String, Value> getIniMap(boolean create) {
        if (this._iniMap == null && create) {
            this._iniMap = new IdentityHashMap();
        }
        return this._iniMap;
    }

    public void setIni(String name, StringValue value) {
        this._iniDefinitions.get(name).set(this, (Value)value);
    }

    public void setIni(String name, String value) {
        this._iniDefinitions.get(name).set(this, value);
    }

    public boolean getIniBoolean(String name) {
        return this._iniDefinitions.get(name).getAsBoolean(this);
    }

    public long getIniLong(String name) {
        return this._iniDefinitions.get(name).getAsLongValue(this).toLong();
    }

    public void setServerEnv(String name, String value) {
        this.setServerEnv(this.createString(name), this.createString(value));
    }

    public void setServerEnv(StringValue name, StringValue value) {
        this._serverEnvMap.put(name, value);
    }

    public Value getServerEnv(StringValue name) {
        return this._serverEnvMap.get(name);
    }

    public HashMap<Value, Value> getServerEnvMap() {
        return this._serverEnvMap;
    }

    public Path getIncludeCache(StringValue include, String includePath, Path pwd, Path scriptPwd) {
        IncludeKey key = new IncludeKey(include, includePath, pwd, scriptPwd);
        Path path = (Path)this._includeCache.get((Object)key);
        return path;
    }

    public void putIncludeCache(StringValue include, String includePath, Path pwd, Path scriptPwd, Path path) {
        IncludeKey key = new IncludeKey(include, includePath, pwd, scriptPwd);
        this._includeCache.put((Object)key, (Object)path);
    }

    public long getDefCacheHitCount() {
        return this._defCacheHitCount;
    }

    public long getDefCacheMissCount() {
        return this._defCacheMissCount;
    }

    public void clearDefinitionCache() {
    }

    public boolean includeExists(Path path) {
        return this._pageManager.precompileExists(path);
    }

    public QuercusPage parse(Path path) throws IOException {
        return this._pageManager.parse(path);
    }

    public QuercusPage parse(Path path, String fileName, int line) throws IOException {
        return this._pageManager.parse(path, fileName, line);
    }

    public QuercusPage parse(ReadStream is) throws IOException {
        return new InterpretedPage(QuercusParser.parse(this, is));
    }

    public QuercusProgram parseCode(String code) throws IOException {
        QuercusProgram program = (QuercusProgram)this._evalCache.get((Object)code);
        if (program == null) {
            program = QuercusParser.parseEval(this, code);
            this._evalCache.put((Object)code, (Object)program);
        }
        return program;
    }

    public QuercusProgram parseEvalExpr(String code) throws IOException {
        QuercusProgram program = (QuercusProgram)this._evalCache.get((Object)code);
        if (program == null) {
            program = QuercusParser.parseEvalExpr(this, code);
            this._evalCache.put((Object)code, (Object)program);
        }
        return program;
    }

    public AbstractFunction parseFunction(String name, String args, String code) throws IOException {
        return QuercusParser.parseFunction(this, name, args, code);
    }

    public AbstractFunction findFunction(String name) {
        AbstractFunction fun = this._funMap.get(name);
        if (fun == null && !this.isStrict()) {
            fun = this._lowerFunMap.get(name.toLowerCase());
        }
        return fun;
    }

    public AbstractFunction findFunctionImpl(String name) {
        AbstractFunction fun = this._funMap.get(name);
        return fun;
    }

    public AbstractFunction findLowerFunctionImpl(String lowerName) {
        AbstractFunction fun = this._lowerFunMap.get(lowerName);
        return fun;
    }

    public ArrayValue getDefinedFunctions() {
        ArrayValueImpl internal = new ArrayValueImpl();
        for (String name : this._funMap.keySet()) {
            internal.put(name);
        }
        return internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFunctionId(String name) {
        if (!this.isStrict()) {
            name = name.toLowerCase();
        }
        IntMap intMap = this._functionNameMap;
        synchronized (intMap) {
            int id = this._functionNameMap.get((Object)name);
            if (id < 0) {
                id = this._functionNameMap.size();
                this._functionNameMap.put((Object)name, id);
                if (this._functionMap.length <= id) {
                    AbstractFunction[] functionMap = new AbstractFunction[id + 256];
                    System.arraycopy(this._functionMap, 0, functionMap, 0, this._functionMap.length);
                    this._functionMap = functionMap;
                }
                this._functionMap[id] = new UndefinedFunction(name);
            }
            return id;
        }
    }

    public int findFunctionId(String name) {
        if (!this.isStrict()) {
            name = name.toLowerCase();
        }
        return this._functionNameMap.get((Object)name);
    }

    public int getFunctionIdCount() {
        return this._functionNameMap.size();
    }

    public AbstractFunction[] getFunctionMap() {
        return this._functionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClassId(String name) {
        name = name.toLowerCase();
        IntMap intMap = this._classNameMap;
        synchronized (intMap) {
            int id = this._classNameMap.get((Object)name);
            if (id < 0) {
                id = this._classNameMap.size();
                this._classNameMap.put((Object)name, id);
                if (this._classMap.length <= id) {
                    ClassDef[] classMap = new ClassDef[id + 256];
                    System.arraycopy(this._classMap, 0, classMap, 0, this._classMap.length);
                    this._classMap = classMap;
                }
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findClassId(String name) {
        IntMap intMap = this._classNameMap;
        synchronized (intMap) {
            return this._classNameMap.get((Object)name);
        }
    }

    public int getClassIdCount() {
        return this._classNameMap.size();
    }

    public ClassDef[] getClassDefMap() {
        return this._classMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConstantId(String name) {
        name = name.toLowerCase();
        IntMap intMap = this._constantNameMap;
        synchronized (intMap) {
            int id = this._constantNameMap.get((Object)name);
            if (id < 0) {
                id = this._constantNameMap.size();
                this._constantNameMap.put((Object)name, id);
            }
            return id;
        }
    }

    public int getConstantIdSize() {
        return this._constantNameMap.size();
    }

    public static boolean isSuperGlobal(String name) {
        return _superGlobals.contains(name);
    }

    public QuercusClass getStdClass() {
        return this._moduleContext.getStdClass();
    }

    public ClassDef findClass(String name) {
        return this._moduleContext.findClass(name);
    }

    public HashMap<String, ClassDef> getClassMap() {
        return this._moduleContext.getClassMap();
    }

    public QuercusModule findModule(String name) {
        ModuleInfo moduleInfo = this._modules.get(name);
        return moduleInfo == null ? null : moduleInfo.getModule();
    }

    public HashSet<ModuleStartupListener> getModuleStartupListeners() {
        return this._moduleStartupListeners;
    }

    public boolean isExtensionLoaded(String name) {
        return this._extensionSet.contains(name);
    }

    public HashSet<String> getLoadedExtensions() {
        return this._extensionSet;
    }

    public Value getExtensionFuncs(String name) {
        ArrayValue value = null;
        for (ModuleInfo moduleInfo : this._modules.values()) {
            HashSet<String> extensionSet = moduleInfo.getLoadedExtensions();
            if (!extensionSet.contains(name)) continue;
            for (String functionName : moduleInfo.getFunctions().keySet()) {
                if (value == null) {
                    value = new ArrayValueImpl();
                }
                value.put(functionName);
            }
        }
        if (value != null) {
            return value;
        }
        return BooleanValue.FALSE;
    }

    public Collection<ModuleInfo> getModules() {
        return this._modules.values();
    }

    public HashMap<String, Value> getConstMap() {
        return this._constMap;
    }

    public void init() {
        this.initStaticFunctions();
        this.initStaticClasses();
        this.initStaticClassServices();
        this._workDir = this.getWorkDir();
        this._iniDefinitions.addAll(_ini);
        this._includeCache = new TimedCache(this.getIncludeCacheMax(), this.getIncludeCacheTimeout());
        this.initLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringValue intern(String name) {
        HashMap<String, StringValue> hashMap = this._internMap;
        synchronized (hashMap) {
            StringValue value = this._internMap.get(name);
            if (value == null) {
                name = name.intern();
                value = new StringBuilderValue(name);
                this._internMap.put(name, value);
            }
            return value;
        }
    }

    public Value getConstant(String name) {
        return this._constMap.get(name);
    }

    public String createStaticName() {
        return ("s" + this._staticId++).intern();
    }

    public SessionArrayValue loadSession(Env env, String sessionId) {
        long now = Alarm.getCurrentTime();
        SessionArrayValue session = this._sessionManager.getSession(env, sessionId, now);
        if (session == null) {
            session = this._sessionManager.createSession(env, sessionId, now);
        }
        return session;
    }

    public void saveSession(Env env, SessionArrayValue session) {
        this._sessionManager.saveSession(env, session);
    }

    public void destroySession(String sessionId) {
        this._sessionManager.removeSession(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSpecial(String key) {
        HashMap<String, Object> hashMap = this._specialMap;
        synchronized (hashMap) {
            return this._specialMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpecial(String key, Object value) {
        HashMap<String, Object> hashMap = this._specialMap;
        synchronized (hashMap) {
            this._specialMap.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStaticFunctions() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            String quercusModule = "META-INF/services/com.caucho.quercus.QuercusModule";
            Enumeration<URL> urls = loader.getResources(quercusModule);
            HashSet<URL> urlSet = new HashSet<URL>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                urlSet.add(url);
            }
            for (URL url : urlSet) {
                InputStream is = null;
                ReadStream rs = null;
                try {
                    is = url.openStream();
                    rs = new ReadStream((StreamImpl)new VfsStream(is, null));
                    this.parseServicesModule(rs);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private void parseServicesModule(ReadStream in) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        String line;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while ((line = in.readLine()) != null) {
            int p = line.indexOf(35);
            if (p >= 0) {
                line = line.substring(0, p);
            }
            if ((line = line.trim()).length() <= 0) continue;
            String className = line;
            try {
                Class<?> cl;
                try {
                    cl = Class.forName(className, false, loader);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException(L.l("'{0}' not valid {1}", (Object)className, (Object)e.toString()));
                }
                this.introspectPhpModuleClass(cl);
            }
            catch (Throwable e) {
                log.info("Failed loading " + className + "\n" + e.toString());
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectPhpModuleClass(Class cl) throws IllegalAccessException, InstantiationException, ConfigException {
        HashMap<String, ModuleInfo> hashMap = this._modules;
        synchronized (hashMap) {
            if (this._modules.get(cl.getName()) != null) {
                return;
            }
            log.finest("Quercus loading module " + cl.getName());
            QuercusModule module = (QuercusModule)cl.newInstance();
            ModuleContext context = this.getLocalContext();
            ModuleInfo info = context.addModule(cl.getName(), module);
            this._modules.put(cl.getName(), info);
            if (info.getModule() instanceof ModuleStartupListener) {
                this._moduleStartupListeners.add((ModuleStartupListener)info.getModule());
            }
            for (String ext : info.getLoadedExtensions()) {
                this._extensionSet.add(ext);
            }
            HashMap<String, Value> map = info.getConstMap();
            if (map != null) {
                this._constMap.putAll(map);
            }
            this._iniDefinitions.addAll(info.getIniDefinitions());
            IntMap intMap = this._functionNameMap;
            synchronized (intMap) {
                for (Map.Entry<String, AbstractFunction> entry : info.getFunctions().entrySet()) {
                    String funName = entry.getKey();
                    AbstractFunction fun = entry.getValue();
                    this._funMap.put(funName, fun);
                    this._lowerFunMap.put(funName.toLowerCase(), fun);
                    int id = this.getFunctionId(funName);
                    this._functionMap[id] = fun;
                }
            }
        }
    }

    public static Value objectToValue(Object obj) {
        if (obj == null) {
            return NullValue.NULL;
        }
        if (Byte.class.equals(obj.getClass()) || Short.class.equals(obj.getClass()) || Integer.class.equals(obj.getClass()) || Long.class.equals(obj.getClass())) {
            return LongValue.create(((Number)obj).longValue());
        }
        if (Float.class.equals(obj.getClass()) || Double.class.equals(obj.getClass())) {
            return DoubleValue.create(((Number)obj).doubleValue());
        }
        if (String.class.equals(obj.getClass())) {
            return new StringBuilderValue((String)obj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStaticClassServices() {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            String quercusModule = "META-INF/services/com.caucho.quercus.QuercusClass";
            Enumeration<URL> urls = loader.getResources(quercusModule);
            HashSet<URL> urlSet = new HashSet<URL>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                urlSet.add(url);
            }
            for (URL url : urlSet) {
                InputStream is = null;
                ReadStream rs = null;
                try {
                    is = url.openStream();
                    rs = new ReadStream((StreamImpl)new VfsStream(is, null));
                    this.parseClassServicesModule(rs);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    private void parseClassServicesModule(ReadStream in) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, ConfigException, NoSuchMethodException, InvocationTargetException {
        String line;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while ((line = in.readLine()) != null) {
            int p = line.indexOf(35);
            if (p >= 0) {
                line = line.substring(0, p);
            }
            if ((line = line.trim()).length() == 0) continue;
            String[] args = line.split(" ");
            String className = args[0];
            try {
                Class<?> cl = Class.forName(className, false, loader);
                String phpClassName = null;
                String extension = null;
                String definedBy = null;
                for (int i = 1; i < args.length; ++i) {
                    if ("as".equals(args[i])) {
                        if (++i >= args.length) {
                            throw new IOException(L.l("expecting Quercus class name after '{0}' in definition for class {1}", (Object)"as", (Object)className));
                        }
                        phpClassName = args[i];
                        continue;
                    }
                    if ("provides".equals(args[i])) {
                        if (++i >= args.length) {
                            throw new IOException(L.l("expecting name of extension after '{0}' in definition for class {1}", (Object)"extension", (Object)className));
                        }
                        extension = args[i];
                        continue;
                    }
                    if ("definedBy".equals(args[i])) {
                        if (++i >= args.length) {
                            throw new IOException(L.l("expecting name of class implementing JavaClassDef after '{0}' in definition for class {1}", (Object)"definedBy", (Object)className));
                        }
                        definedBy = args[i];
                        continue;
                    }
                    throw new IOException(L.l("unknown token '{0}' in definition for class {1} ", (Object)args[i], (Object)className));
                }
                if (phpClassName == null) {
                    phpClassName = className.substring(className.lastIndexOf(46) + 1);
                }
                Class<?> javaClassDefClass = definedBy != null ? Class.forName(definedBy, false, loader) : null;
                this.introspectJavaClass(phpClassName, cl, extension, javaClassDefClass);
            }
            catch (Exception e) {
                log.info("Failed loading " + className + "\n" + e.toString());
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectJavaClass(String name, Class type, String extension, Class javaClassDefClass) throws IllegalAccessException, InstantiationException, ConfigException, NoSuchMethodException, InvocationTargetException {
        ModuleContext context = this.getLocalContext();
        JavaClassDef def = context.addClass(name, type, extension, javaClassDefClass);
        HashMap<String, JavaClassDef> hashMap = this._javaClassWrappers;
        synchronized (hashMap) {
            this._javaClassWrappers.put(name, def);
            this._lowerJavaClassWrappers.put(name.toLowerCase(), def);
        }
        if (extension != null) {
            this._extensionSet.add(extension);
        }
    }

    private void introspectJavaImplClass(String name, Class type, String extension) throws IllegalAccessException, InstantiationException, ConfigException {
        if (log.isLoggable(Level.FINEST)) {
            if (extension == null) {
                log.finest(L.l("Quercus loading class {0} with type {1}", (Object)name, (Object)type.getName()));
            } else {
                log.finest(L.l("Quercus loading class {0} with type {1} providing extension {2}", (Object)name, (Object)type.getName(), (Object)extension));
            }
        }
        ModuleContext context = this.getLocalContext();
        try {
            JavaClassDef def = context.addClass(name, type, extension, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private void initStaticClasses() {
    }

    protected void initLocal() {
        String[] paths;
        StringBuilder sb = new StringBuilder(".");
        Path pwd = this.getPwd();
        for (String path : paths = new String[]{"/usr/share/php", "/usr/lib/php", "/usr/local/lib/php", "/usr/share/pear", "/usr/lib/pear", "/usr/local/lib/pear"}) {
            if (!pwd.lookup(path).isDirectory()) continue;
            sb.append(":").append(pwd.lookup(path).getPath());
        }
        this.setIni("include_path", sb.toString());
    }

    public void start() {
    }

    public Env createEnv(QuercusPage page, WriteStream out, HttpServletRequest request, HttpServletResponse response) {
        return new Env(this, page, out, request, response);
    }

    public void close() {
        this._sessionManager.close();
        this._pageManager.close();
    }

    public static Value exnConstructor(Env env, Value obj, String msg) {
        if (obj != null) {
            obj.putField(env, "message", (Value)new UnicodeValueImpl(msg));
        }
        return NullValue.NULL;
    }

    static {
        _superGlobals.add("GLOBALS");
        _superGlobals.add("_COOKIE");
        _superGlobals.add("_ENV");
        _superGlobals.add("_FILES");
        _superGlobals.add("_GET");
        _superGlobals.add("_POST");
        _superGlobals.add("_SERVER");
        _superGlobals.add("_SESSION");
        _superGlobals.add("_REQUEST");
        INI_INCLUDE_PATH = _ini.add("include_path", ".", 7);
        INI_REGISTER_LONG_ARRAYS = _ini.add("register_long_arrays", true, 2);
        INI_ALWAYS_POPULATE_RAW_POST_DATA = _ini.add("always_populate_raw_post_data", false, 2);
        INI_UNICODE_SEMANTICS = _ini.add("unicode.semantics", false, 4);
        INI_UNICODE_FALLBACK_ENCODING = _ini.add("unicode.fallback_encoding", "utf-8", 7);
        INI_UNICODE_FROM_ERROR_MODE = _ini.add("unicode.from_error_mode", "2", 7);
        INI_UNICODE_FROM_ERROR_SUBST_CHAR = _ini.add("unicode.from_error_subst_char", "3f", 7);
        INI_UNICODE_HTTP_INPUT_ENCODING = _ini.add("unicode.http_input_encoding", null, 7);
        INI_UNICODE_OUTPUT_ENCODING = _ini.add("unicode.output_encoding", null, 7);
        INI_UNICODE_RUNTIME_ENCODING = _ini.add("unicode.runtime_encoding", null, 7);
        INI_UNICODE_SCRIPT_ENCODING = _ini.add("unicode.script_encoding", null, 7);
    }

    static class IncludeKey {
        private final StringValue _include;
        private final String _includePath;
        private final Path _pwd;
        private final Path _scriptPwd;

        IncludeKey(StringValue include, String includePath, Path pwd, Path scriptPwd) {
            this._include = include;
            this._includePath = includePath;
            this._pwd = pwd;
            this._scriptPwd = scriptPwd;
        }

        public int hashCode() {
            int hash = 37;
            hash = 65537 * hash + this._include.hashCode();
            hash = 65537 * hash + this._includePath.hashCode();
            hash = 65537 * hash + this._pwd.hashCode();
            hash = 65537 * hash + this._scriptPwd.hashCode();
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IncludeKey)) {
                return false;
            }
            IncludeKey key = (IncludeKey)o;
            return this._include.equals(key._include) && this._includePath.equals(key._includePath) && this._pwd.equals((Object)key._pwd) && this._scriptPwd.equals((Object)key._scriptPwd);
        }
    }
}

