/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaInvoker;
import com.caucho.quercus.env.MethodMap;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.program.AbstractFunction;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackObjectMethod
extends Callback {
    private static final L10N L = new L10N(CallbackObjectMethod.class);
    private final Value _obj;
    private final String _methodName;
    private final int _hash;
    private final char[] _name;
    private final AbstractFunction _fun;

    public CallbackObjectMethod(Env env, Value obj, String methodName) {
        this._obj = obj;
        this._methodName = methodName;
        this._hash = MethodMap.hash(methodName);
        this._name = this._methodName.toCharArray();
        QuercusClass cl = env.findClass(this._obj.getClassName());
        this._fun = cl.findFunction(this._methodName);
    }

    @Override
    public Value call(Env env) {
        if (!this.isValid()) {
            return this.error(env);
        }
        return this._fun.callMethod(env, this._obj);
    }

    @Override
    public Value call(Env env, Value a1) {
        if (!this.isValid()) {
            return this.error(env);
        }
        return this._fun.callMethod(env, this._obj, a1);
    }

    @Override
    public Value call(Env env, Value a1, Value a2) {
        if (!this.isValid()) {
            return this.error(env);
        }
        return this._fun.callMethod(env, this._obj, a1, a2);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3) {
        if (!this.isValid()) {
            return this.error(env);
        }
        return this._fun.callMethod(env, this._obj, a1, a2, a3);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4) {
        if (!this.isValid()) {
            return this.error(env);
        }
        return this._fun.callMethod(env, this._obj, a1, a2, a3, a4);
    }

    @Override
    public Value call(Env env, Value a1, Value a2, Value a3, Value a4, Value a5) {
        if (!this.isValid()) {
            return this.error(env);
        }
        return this._fun.callMethod(env, this._obj, a1, a2, a3, a4, a5);
    }

    @Override
    public Value call(Env env, Value[] args) {
        if (!this.isValid()) {
            return this.error(env);
        }
        return this._fun.callMethod(env, this._obj, args);
    }

    @Override
    public void varDumpImpl(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        out.print(this.getClass().getName());
        out.print('[');
        out.print(this._methodName);
        out.print(']');
    }

    @Override
    public boolean isValid() {
        return this._fun != null;
    }

    @Override
    public String getCallbackName() {
        return this._methodName;
    }

    @Override
    public boolean isInternal() {
        return this._fun instanceof JavaInvoker;
    }

    private Value error(Env env) {
        env.warning(L.l("{0}::{1}() is an invalid callback method", (Object)this._obj.getClassName(), (Object)this._methodName));
        return NullValue.NULL;
    }
}

