/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.env;

import com.caucho.quercus.env.ArrayDelegate;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.CountDelegate;
import com.caucho.quercus.env.DoubleValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.FieldVisibility;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.ArrayModule;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectValue
extends Value {
    protected transient QuercusClass _quercusClass;
    protected String _className;
    protected String _incompleteObjectName;

    protected ObjectValue(QuercusClass quercusClass) {
        this._quercusClass = quercusClass;
        this._className = quercusClass.getName();
    }

    protected void setQuercusClass(QuercusClass cl) {
        this._quercusClass = cl;
        this._className = cl.getName();
    }

    public QuercusClass getQuercusClass() {
        return this._quercusClass;
    }

    public boolean isIncompleteObject() {
        return this._incompleteObjectName != null;
    }

    public String getIncompleteObjectName() {
        return this._incompleteObjectName;
    }

    public void setIncompleteObjectName(String name) {
        this._incompleteObjectName = name;
    }

    public void initObject(Env env, QuercusClass cls) {
        this.setQuercusClass(cls);
        this._incompleteObjectName = null;
    }

    @Override
    public String getClassName() {
        return this._className;
    }

    public abstract Set<? extends Map.Entry<Value, Value>> entrySet();

    public String getName() {
        return this._className;
    }

    public String getParentClassName() {
        return this._quercusClass.getParentName();
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public String getType() {
        return "object";
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public boolean isA(String name) {
        return this._quercusClass.isA(name);
    }

    @Override
    public long toLong() {
        return 1L;
    }

    @Override
    public double toDouble() {
        return this.toLong();
    }

    @Override
    public Value get(Value key) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.get(this, key);
        }
        return super.get(key);
    }

    @Override
    public Value put(Value key, Value value) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.put(this, key, value);
        }
        return super.put(key, value);
    }

    @Override
    public Value put(Value value) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.put(this, value);
        }
        return super.put(value);
    }

    @Override
    public boolean isset(Value key) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.isset(this, key);
        }
        return super.isset(key);
    }

    @Override
    public Value remove(Value key) {
        ArrayDelegate delegate = this._quercusClass.getArrayDelegate();
        if (delegate != null) {
            return delegate.unset(this, key);
        }
        return super.remove(key);
    }

    @Override
    public Iterator<Map.Entry<Value, Value>> getIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getIterator(env, this);
        }
        return super.getIterator(env);
    }

    @Override
    public Iterator<Value> getKeyIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getKeyIterator(env, this);
        }
        return super.getKeyIterator(env);
    }

    @Override
    public Iterator<Value> getValueIterator(Env env) {
        TraversableDelegate delegate = this._quercusClass.getTraversableDelegate();
        if (delegate != null) {
            return delegate.getValueIterator(env, this);
        }
        return super.getValueIterator(env);
    }

    @Override
    public int getCount(Env env) {
        CountDelegate delegate = this._quercusClass.getCountDelegate();
        if (delegate != null) {
            return delegate.count(this);
        }
        return super.getSize();
    }

    public Value putField(String key, String value) {
        Env env = Env.getInstance();
        return this.putThisField(env, env.createString(key), env.createString(value));
    }

    public Value putField(Env env, String key, String value) {
        return this.putThisField(env, env.createString(key), env.createString(value));
    }

    public Value putField(String key, long value) {
        Env env = Env.getInstance();
        return this.putThisField(env, env.createString(key), LongValue.create(value));
    }

    public Value putField(Env env, String key, long value) {
        return this.putThisField(env, env.createString(key), LongValue.create(value));
    }

    @Override
    public Value putField(Env env, String key, Value value) {
        return this.putThisField(env, env.createString(key), value);
    }

    @Override
    public void initField(StringValue key, Value value, FieldVisibility visibility) {
        this.putThisField(Env.getInstance(), key, value);
    }

    public Value putField(String key, double value) {
        Env env = Env.getInstance();
        return this.putThisField(env, env.createString(key), DoubleValue.create(value));
    }

    @Override
    public boolean eq(Value rValue) {
        if ((rValue = rValue.toValue()) instanceof ObjectValue) {
            return this.cmpObject((ObjectValue)rValue) == 0;
        }
        return super.eq(rValue);
    }

    public int cmpObject(ObjectValue rValue) {
        Set<? extends Map.Entry<Value, Value>> bSet;
        if (rValue == this) {
            return 0;
        }
        int result = this.getName().compareTo(rValue.getName());
        if (result != 0) {
            return result;
        }
        Set<? extends Map.Entry<Value, Value>> aSet = this.entrySet();
        if (((Object)aSet).equals(bSet = rValue.entrySet())) {
            return 0;
        }
        if (aSet.size() > bSet.size()) {
            return 1;
        }
        if (aSet.size() < bSet.size()) {
            return -1;
        }
        TreeSet<? extends Map.Entry<Value, Value>> aTree = new TreeSet<Map.Entry<Value, Value>>(aSet);
        TreeSet<? extends Map.Entry<Value, Value>> bTree = new TreeSet<Map.Entry<Value, Value>>(bSet);
        Iterator<? extends Map.Entry<Value, Value>> iterA = aTree.iterator();
        Iterator<? extends Map.Entry<Value, Value>> iterB = bTree.iterator();
        while (iterA.hasNext()) {
            Map.Entry<Value, Value> a = iterA.next();
            Map.Entry<Value, Value> b = iterB.next();
            result = a.getKey().cmp(b.getKey());
            if (result != 0) {
                return result;
            }
            result = a.getValue().cmp(b.getValue());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public void varDumpObject(Env env, WriteStream out, int depth, IdentityHashMap<Value, String> valueSet) throws IOException {
        Map.Entry<Value, Value> entry;
        int size = this.getSize();
        if (this.isIncompleteObject()) {
            ++size;
        }
        out.println("object(" + this.getName() + ") (" + size + ") {");
        if (this.isIncompleteObject()) {
            this.printDepth(out, 2 * (depth + 1));
            out.println("[\"__Quercus_Incomplete_Class_name\"]=>");
            this.printDepth(out, 2 * (depth + 1));
            StringValue value = env.createString(this.getIncompleteObjectName());
            value.varDump(env, out, depth + 1, valueSet);
            out.println();
        }
        ArrayValueImpl sortedEntries = new ArrayValueImpl();
        Iterator<Map.Entry<Value, Value>> iter = this.getIterator(env);
        while (iter.hasNext()) {
            entry = iter.next();
            sortedEntries.put(entry.getKey(), entry.getValue());
        }
        ArrayModule.ksort(env, sortedEntries, 2L);
        iter = sortedEntries.getIterator(env);
        while (iter.hasNext()) {
            entry = iter.next();
            Value key = entry.getKey();
            Value value = entry.getValue();
            this.printDepth(out, 2 * depth);
            out.println("[\"" + key + "\"]=>");
            this.printDepth(out, 2 * ++depth);
            value.varDump(env, out, depth, valueSet);
            out.println();
            --depth;
        }
        this.printDepth(out, 2 * depth);
        out.print("}");
    }
}

