/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.ExprFactory;

public class AssignExpr
extends Expr {
    protected final AbstractVarExpr _var;
    protected final Expr _value;

    public AssignExpr(Location location, AbstractVarExpr var, Expr value) {
        super(location);
        this._var = var;
        this._value = value;
    }

    public AssignExpr(AbstractVarExpr var, Expr value) {
        this._var = var;
        this._value = value;
    }

    public Expr createCopy(ExprFactory factory) {
        return factory.createCopy(this);
    }

    public boolean isAssign() {
        return true;
    }

    public Value eval(Env env) {
        Value value = this._value.evalCopy(env);
        this._var.evalAssign(env, value);
        return value;
    }

    public Value evalCopy(Env env) {
        return this.eval(env).copy();
    }

    public Value evalRef(Env env) {
        Value value = this._value.eval(env);
        this._var.evalAssign(env, value);
        return value;
    }

    public String toString() {
        return this._var + "=" + this._value;
    }
}

