/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;

public class FieldGetExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(FieldGetExpr.class);
    protected final Expr _objExpr;
    protected final StringValue _name;

    public FieldGetExpr(Location location, Expr objExpr, StringValue name) {
        super(location);
        this._objExpr = objExpr;
        this._name = name;
    }

    public FieldGetExpr(Expr objExpr, StringValue name) {
        this._objExpr = objExpr;
        this._name = name;
    }

    public Value eval(Env env) {
        Value obj = this._objExpr.eval(env);
        return obj.getField(env, this._name);
    }

    public Value evalArg(Env env) {
        Value value = this._objExpr.evalArg(env);
        return value.getFieldArg(env, this._name);
    }

    public Value evalDirty(Env env) {
        Value obj = this._objExpr.eval(env);
        return obj.getFieldRef(env, this._name).toValue();
    }

    public Value evalRef(Env env) {
        Value value = this._objExpr.evalObject(env);
        return value.getFieldRef(env, this._name);
    }

    public Value evalCopy(Env env) {
        Value obj = this._objExpr.eval(env);
        return obj.getField(env, this._name).copy();
    }

    public void evalAssign(Env env, Value value) {
        Value obj = this._objExpr.evalObject(env);
        obj.putField(env, this._name, value);
    }

    public Value evalArray(Env env) {
        Value obj = this._objExpr.evalObject(env);
        return obj.getFieldArray(env, this._name);
    }

    public Value evalObject(Env env) {
        Value obj = this._objExpr.evalObject(env);
        return obj.getFieldObject(env, this._name);
    }

    public void evalUnset(Env env) {
        Value obj = this._objExpr.eval(env);
        obj.unsetField(this._name);
    }

    public String toString() {
        return this._objExpr + "->" + this._name;
    }
}

