/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.QuercusClass;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;
import com.caucho.util.L10N;

public class LateStaticBindingFieldVarGetExpr
extends AbstractVarExpr {
    private static final L10N L = new L10N(LateStaticBindingFieldVarGetExpr.class);
    protected final Expr _varName;

    public LateStaticBindingFieldVarGetExpr(Location location, Expr varName) {
        super(location);
        this._varName = varName;
    }

    public LateStaticBindingFieldVarGetExpr(Expr varName) {
        this._varName = varName;
    }

    public Value eval(Env env) {
        QuercusClass cl = env.getCallingClass();
        if (cl == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cl.getStaticField(env, this._varName.evalString(env)).toValue();
    }

    public Value evalCopy(Env env) {
        QuercusClass cl = env.getCallingClass();
        if (cl == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cl.getStaticField(env, this._varName.evalString(env)).copy();
    }

    public Value evalArg(Env env) {
        QuercusClass cl = env.getCallingClass();
        if (cl == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cl.getStaticField(env, this._varName.evalString(env));
    }

    public Value evalArray(Env env) {
        QuercusClass cl = env.getCallingClass();
        if (cl == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cl.getStaticField(env, this._varName.evalString(env)).getArray();
    }

    public Value evalObject(Env env) {
        QuercusClass cl = env.getCallingClass();
        if (cl == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cl.getStaticField(env, this._varName.evalString(env)).getObject(env);
    }

    public Value evalRef(Env env) {
        QuercusClass cl = env.getCallingClass();
        if (cl == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return NullValue.NULL;
        }
        return cl.getStaticField(env, this._varName.evalString(env));
    }

    public void evalAssign(Env env, Value value) {
        QuercusClass cl = env.getCallingClass();
        if (cl == null) {
            env.error(this.getLocation(), L.l("no calling class found"));
            return;
        }
        cl.getStaticField(env, this._varName.evalString(env)).set(value);
    }

    public void evalUnset(Env env) {
        env.error(this.getLocation(), L.l("{0}::${1}: Cannot unset static variables.", (Object)env.getCallingClass().getName(), (Object)this._varName));
    }

    public String toString() {
        return "static::$" + this._varName;
    }
}

