/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.expr;

import com.caucho.quercus.Location;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.AbstractVarExpr;
import com.caucho.quercus.expr.Expr;

public class VarVarExpr
extends AbstractVarExpr {
    private static final NullValue NULL = NullValue.create();
    protected final Expr _var;

    public VarVarExpr(Location location, Expr var) {
        super(location);
        this._var = var;
    }

    public VarVarExpr(Expr var) {
        this._var = var;
    }

    public Expr getExpr() {
        return this._var;
    }

    public Value eval(Env env) {
        String varName = this._var.evalString(env).intern();
        Value value = env.getValue(varName);
        if (value != null) {
            return value;
        }
        return NULL;
    }

    public Value evalCopy(Env env) {
        String varName = this._var.evalString(env).intern();
        Value value = env.getValue(varName);
        if (value != null) {
            return value.copy();
        }
        return NULL;
    }

    public void evalAssign(Env env, Value value) {
        String varName = this._var.evalString(env).intern();
        env.getVar(varName).set(value);
    }

    public void evalUnset(Env env) {
        String varName = this._var.evalString(env).intern();
        env.unsetVar(varName);
    }

    public Value evalRef(Env env) {
        String varName = this._var.evalString(env).intern();
        Var value = env.getVar(varName);
        if (value != null) {
            return value;
        }
        return NULL;
    }

    public Value evalArg(Env env) {
        String varName = this._var.evalString(env).intern();
        Var value = env.getVar(varName);
        if (value != null) {
            return value;
        }
        return NULL;
    }

    public Value evalArray(Env env) {
        String varName = this._var.evalString(env).intern();
        Var value = env.getVar(varName);
        if (value != null) {
            return ((Value)value).getArray();
        }
        ArrayValueImpl array = new ArrayValueImpl();
        env.setVar(varName, array);
        return array;
    }

    public String toString() {
        return "$" + this._var;
    }
}

