/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.JavaValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.util.L10N;

public class JavaMarshal
extends Marshal {
    private static final L10N L = new L10N(JavaMarshal.class);
    protected final JavaClassDef _def;
    protected final boolean _isNotNull;
    protected final boolean _isUnmarshalNullAsFalse;

    public JavaMarshal(JavaClassDef def, boolean isNotNull) {
        this(def, isNotNull, false);
    }

    public JavaMarshal(JavaClassDef def, boolean isNotNull, boolean isUnmarshalNullAsFalse) {
        this._def = def;
        this._isNotNull = isNotNull;
        this._isUnmarshalNullAsFalse = isUnmarshalNullAsFalse;
    }

    public Object marshal(Env env, Expr expr, Class argClass) {
        Value value = expr.eval(env);
        return this.marshal(env, value, argClass);
    }

    public Object marshal(Env env, Value value, Class argClass) {
        if (!value.isset()) {
            if (this._isNotNull) {
                env.warning(L.l("null is an unexpected argument, expected {0}", (Object)JavaMarshal.shortName(argClass)));
            }
            return null;
        }
        Object obj = value.toJavaObject();
        if (obj == null) {
            if (this._isNotNull) {
                env.warning(L.l("null is an unexpected argument, expected {0}", (Object)JavaMarshal.shortName(argClass)));
            }
            return null;
        }
        if (!argClass.isAssignableFrom(obj.getClass())) {
            env.warning(L.l("'{0}' of type '{1}' is an unexpected argument, expected {2}", (Object)value, (Object)JavaMarshal.shortName(obj.getClass()), (Object)JavaMarshal.shortName(argClass)));
            return null;
        }
        return obj;
    }

    public Value unmarshal(Env env, Object value) {
        return env.wrapJava(value, this._def, this._isUnmarshalNullAsFalse);
    }

    protected static final String shortName(Class cl) {
        String name = cl.getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            return name.substring(p + 1);
        }
        return name;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        Class type = this._def.getType();
        if (argValue instanceof JavaValue && type.isAssignableFrom(argValue.toJavaObject().getClass())) {
            return 0;
        }
        return 400;
    }

    public final Class getExpectedClass() {
        return this._def.getType();
    }
}

