/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.function;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.function.Marshal;

public class StringValueMarshal
extends Marshal {
    public static final Marshal MARSHAL = new StringValueMarshal();

    public boolean isReadOnly() {
        return true;
    }

    public boolean isValue() {
        return true;
    }

    public Object marshal(Env env, Expr expr, Class expectedClass) {
        return expr.eval(env).toStringValue();
    }

    public Object marshal(Env env, Value value, Class expectedClass) {
        return value.toStringValue();
    }

    public Value unmarshal(Env env, Object value) {
        if (value instanceof StringValue) {
            return (StringValue)value;
        }
        if (value instanceof Value) {
            return ((Value)value).toStringValue();
        }
        if (value != null) {
            return env.createString(String.valueOf(value));
        }
        return null;
    }

    protected int getMarshalingCostImpl(Value argValue) {
        if (argValue.isString()) {
            if (argValue.isUnicode()) {
                return 100;
            }
            if (argValue.isBinary()) {
                return 101;
            }
            return 0;
        }
        if (!argValue.isArray() && !argValue.isObject()) {
            return 300;
        }
        return 400;
    }

    public Class getExpectedClass() {
        return StringValue.class;
    }
}

