/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Callback;
import com.caucho.quercus.env.DefaultValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.env.Var;
import com.caucho.quercus.expr.Expr;
import com.caucho.quercus.expr.FunctionExpr;
import com.caucho.quercus.expr.IncludeExpr;
import com.caucho.quercus.expr.IncludeOnceExpr;
import com.caucho.quercus.expr.MethodCallExpr;
import com.caucho.quercus.lib.file.FileModule;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.quercus.module.IniDefinition;
import com.caucho.quercus.module.IniDefinitions;
import com.caucho.util.L10N;
import java.util.logging.Logger;

public class ErrorModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ErrorModule.class);
    private static final Logger log = Logger.getLogger(ErrorModule.class.getName());
    private static final IniDefinitions _iniDefinitions = new IniDefinitions();
    public static final int E_ERROR = 1;
    public static final int E_WARNING = 2;
    public static final int E_PARSE = 4;
    public static final int E_NOTICE = 8;
    public static final int E_CORE_ERROR = 16;
    public static final int E_CORE_WARNING = 32;
    public static final int E_COMPILE_ERROR = 64;
    public static final int E_COMPILE_WARNING = 128;
    public static final int E_USER_ERROR = 256;
    public static final int E_USER_WARNING = 512;
    public static final int E_USER_NOTICE = 1024;
    public static final int E_ALL = 6143;
    public static final int E_STRICT = 2048;
    public static final int E_RECOVERABLE_ERROR = 4096;
    private long _errorReporting = 6135L;
    static final IniDefinition INI_ERROR_REPORING = _iniDefinitions.add("error_reporing", null, 7);
    static final IniDefinition INI_DISPLAY_ERRORS = _iniDefinitions.add("display_errors", "1", 7);
    static final IniDefinition INI_DISPLAY_STARTUP_ERRORS = _iniDefinitions.add("display_startup_errors", false, 7);
    static final IniDefinition INI_LOG_ERRORS = _iniDefinitions.add("log_errors", false, 7);
    static final IniDefinition INI_LOG_ERRORS_MAX_LEN = _iniDefinitions.add("log_errors_max_len", 1024L, 7);
    static final IniDefinition INI_IGNORE_REPEATED_ERRORS = _iniDefinitions.add("ignore_repeated_errors", false, 7);
    static final IniDefinition INI_IGNORE_REPEATED_SOURCE = _iniDefinitions.add("ignore_repeated_source", false, 7);
    static final IniDefinition INI_REPORT_MEMLEAKS = _iniDefinitions.add("report_memleaks", true, 7);
    static final IniDefinition INI_TRACK_ERRORS = _iniDefinitions.add("track_errors", false, 7);
    static final IniDefinition INI_HTML_ERRORS = _iniDefinitions.add("html_errors", true, 7);
    static final IniDefinition INI_DOCREF_ROOT = _iniDefinitions.add("docref_root", "", 7);
    static final IniDefinition INI_DOCREF_EXT = _iniDefinitions.add("docref_ext", "", 7);
    static final IniDefinition INI_ERROR_PREPEND_STRING = _iniDefinitions.add("error_prepend_string", null, 7);
    static final IniDefinition INI_ERROR_APPEND_STRING = _iniDefinitions.add("error_append_string", null, 7);
    static final IniDefinition INI_ERROR_LOG = _iniDefinitions.add("error_log", null, 7);
    static final IniDefinition INI_WARN_PLUS_OVERLOADING = _iniDefinitions.add("warn_plus_overloading", null, 7);

    public IniDefinitions getIniDefinitions() {
        return _iniDefinitions;
    }

    public Value die(Env env, @Optional String msg) {
        if (msg != null) {
            return env.die(msg);
        }
        return env.die();
    }

    public static Value debug_backtrace(Env env) {
        ArrayValueImpl result = new ArrayValueImpl();
        Exception e = new Exception();
        e.fillInStackTrace();
        StackTraceElement[] stack = e.getStackTrace();
        int depth = 0;
        for (int i = 1; i < stack.length; ++i) {
            ArrayValueImpl call;
            String fileName;
            String path;
            StackTraceElement elt = stack[i];
            String name = elt.getMethodName();
            String className = elt.getClassName();
            if (name.equals("executeTop")) {
                return result;
            }
            if (className.startsWith("_quercus._") && name.equals("call")) {
                path = ErrorModule.unmangleFile(className);
                fileName = env.getPwd().lookup("./" + path).getNativePath();
                String fun = ErrorModule.findFunction(stack, i);
                if (fun.equals("debug_backtrace")) continue;
                call = new ArrayValueImpl();
                ((ArrayValue)result).put(call);
                call.put("file", fileName);
                call.put("line", env.getSourceLine(className, elt.getLineNumber()));
                call.put("function", fun);
                call.put(env.createString("args"), new ArrayValueImpl());
                continue;
            }
            if (className.startsWith("_quercus._") && name.equals("callMethod")) {
                path = ErrorModule.unmangleFile(className);
                fileName = env.getPwd().lookup("./" + path).getNativePath();
                ArrayValueImpl call2 = new ArrayValueImpl();
                ((ArrayValue)result).put(call2);
                call2.put("file", fileName);
                call2.put("line", env.getSourceLine(className, elt.getLineNumber()));
                call2.put("function", ErrorModule.unmangleFunction(className));
                call2.put("class", ErrorModule.unmangleClass(className));
                call2.put("type", "->");
                call2.put(env.createString("args"), new ArrayValueImpl());
                continue;
            }
            if (className.startsWith("_quercus._") && name.equals("execute")) {
                String methodName = stack[i - 1].getMethodName();
                String path2 = ErrorModule.unmangleFile(className);
                String fileName2 = env.getPwd().lookup("./" + path2).getNativePath();
                call = new ArrayValueImpl();
                call.put("file", fileName2);
                call.put("line", env.getSourceLine(className, elt.getLineNumber()));
                if (methodName.equals("includeOnce")) {
                    call.put("function", "include_once");
                    ((ArrayValue)result).put(call);
                    continue;
                }
                if (methodName.equals("include")) {
                    call.put("function", "include");
                    ((ArrayValue)result).put(call);
                    continue;
                }
                String fun = ErrorModule.findFunction(stack, i);
                if (fun.equals("debug_backtrace")) continue;
                call.put("function", fun);
                ((ArrayValue)result).put(call);
                continue;
            }
            if (className.equals("com.caucho.quercus.expr.FunctionExpr") && name.equals("evalImpl")) {
                if (stack[i - 1].getMethodName().equals("evalArguments")) continue;
                ErrorModule.addInterpreted(env, result, depth++);
                continue;
            }
            if (className.equals("com.caucho.quercus.expr.MethodCallExpr") && name.equals("eval")) {
                if (stack[i - 1].getMethodName().equals("evalArguments")) continue;
                ErrorModule.addInterpreted(env, result, depth++);
                continue;
            }
            if (className.equals("com.caucho.quercus.expr.NewExpr") && name.equals("eval")) {
                if (stack[i - 1].getMethodName().equals("evalArguments")) continue;
                ErrorModule.addInterpreted(env, result, depth++);
                continue;
            }
            if (className.equals("com.caucho.quercus.expr.IncludeExpr") && name.equals("eval")) {
                ErrorModule.addInterpreted(env, result, depth++);
                continue;
            }
            if (className.equals("com.caucho.quercus.expr.IncludeOnceExpr") && name.equals("eval")) {
                ErrorModule.addInterpreted(env, result, depth++);
                continue;
            }
            if (className.startsWith("com.caucho.quercus") || name.equals("invoke") || name.equals("invoke0")) continue;
            ArrayValueImpl call3 = new ArrayValueImpl();
            ((ArrayValue)result).put(call3);
            call3.put("file", elt.getFileName());
            call3.put("line", elt.getLineNumber());
            call3.put("function", elt.getMethodName());
            call3.put("class", elt.getClassName());
            call3.put(env.createString("args"), new ArrayValueImpl());
        }
        return result;
    }

    private static String findFunction(StackTraceElement[] stack, int i) {
        String className = stack[i].getClassName();
        if (i == 0) {
            return ErrorModule.unmangleFunction(className);
        }
        String prevClassName = stack[i - 1].getClassName();
        String prevMethodName = stack[i - 1].getMethodName();
        if (prevClassName.startsWith("_quercus._") && prevMethodName.startsWith("call")) {
            return ErrorModule.unmangleFunction(prevClassName);
        }
        return prevMethodName;
    }

    private static void addInterpreted(Env env, ArrayValue result, int i) {
        Expr expr = env.peekCall(i);
        if (expr instanceof FunctionExpr) {
            FunctionExpr callExpr = (FunctionExpr)expr;
            String functionName = callExpr.getName();
            if ("debug_backtrace".equals(functionName)) {
                return;
            }
            ArrayValueImpl call = new ArrayValueImpl();
            result.put(call);
            if (callExpr.getFileName() != null) {
                call.put(env.createString("file"), env.createString(callExpr.getFileName()));
                call.put(env.createString("line"), new LongValue(callExpr.getLine()));
            }
            call.put(env.createString("function"), env.createString(callExpr.getName()));
            ArrayValueImpl args = new ArrayValueImpl(env.peekArgs(i));
            call.put(env.createString("args"), args);
        } else if (expr instanceof MethodCallExpr) {
            MethodCallExpr callExpr = (MethodCallExpr)expr;
            ArrayValueImpl call = new ArrayValueImpl();
            result.put(call);
            if (callExpr.getFileName() != null) {
                call.put(env.createString("file"), env.createString(callExpr.getFileName()));
                call.put(env.createString("line"), new LongValue(callExpr.getLine()));
            }
            call.put(env.createString("function"), env.createString(callExpr.getName()));
            call.put(env.createString("class"), env.createString(env.peekCallThis(i).getClassName()));
            call.put(env.createString("type"), env.createString("->"));
            call.put(env.createString("args"), new ArrayValueImpl());
        } else if (expr instanceof IncludeExpr) {
            ArrayValueImpl call = new ArrayValueImpl();
            result.put(call);
            if (expr.getFileName() != null) {
                call.put(env.createString("file"), env.createString(expr.getFileName()));
                call.put(env.createString("line"), new LongValue(expr.getLine()));
            }
            call.put(env.createString("function"), env.createString("include"));
        } else if (expr instanceof IncludeOnceExpr) {
            boolean isRequire = ((IncludeOnceExpr)expr).isRequire();
            ArrayValueImpl call = new ArrayValueImpl();
            result.put(call);
            if (expr.getFileName() != null) {
                call.put(env.createString("file"), env.createString(expr.getFileName()));
                call.put(env.createString("line"), LongValue.create(expr.getLine()));
            }
            String name = isRequire ? "require_once" : "include_once";
            call.put(env.createString("function"), env.createString(name));
        }
    }

    private static ArrayValueImpl evalArgsArray(Env env, FunctionExpr callExpr) {
        ArrayValueImpl args = new ArrayValueImpl();
        Value[] argsValues = callExpr.evalArguments(env);
        if (argsValues != null) {
            for (int index = 0; index < argsValues.length; ++index) {
                Var ref = argsValues[index].toRefVar();
                args.put(ref);
            }
        }
        return args;
    }

    private static String unmangleFile(String className) {
        int i = "_quercus".length();
        int end = className.indexOf(36);
        if (end < 0) {
            end = className.length();
        }
        StringBuilder sb = new StringBuilder();
        while (i < end) {
            char ch = className.charAt(i);
            if (ch == '.' && className.charAt(i + 1) == '_') {
                sb.append('/');
                ++i;
            } else if (ch != '_') {
                sb.append(ch);
            } else if (className.charAt(i + 1) == '_') {
                sb.append('.');
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    private static String unmangleFunction(String className) {
        int p = className.lastIndexOf("$fun_");
        if (p > 0) {
            if ((p = (className = className.substring(p + "$fun_".length())).lastIndexOf(95)) > 0) {
                return className.substring(0, p);
            }
            return className;
        }
        return className;
    }

    private static String unmangleClass(String className) {
        int i;
        int p = className.lastIndexOf("$quercus_");
        int q = className.lastIndexOf("$");
        if (p > 0 && p < q) {
            className = className.substring(p + "$quercus_".length(), q);
        }
        if ((i = className.lastIndexOf("_")) >= 0) {
            return className.substring(0, i);
        }
        return className;
    }

    public Value exit(Env env, @Optional Value msg) {
        return env.exit(msg);
    }

    public static boolean error_log(Env env, StringValue message, @Optional(value="0") int type, @Optional StringValue destination, @Optional StringValue extraHeaders) {
        if (type == 3) {
            Value numBytes = FileModule.file_put_contents(env, destination, message, 8, null);
            if (numBytes == BooleanValue.FALSE) {
                return false;
            }
            return numBytes.toLong() == (long)message.length();
        }
        if (type == 2) {
            return false;
        }
        if (type == 1) {
            return false;
        }
        log.warning(message.toString());
        return true;
    }

    public static long error_reporting(Env env, @Optional Value levelV) {
        if (levelV instanceof DefaultValue) {
            return env.getErrorMask();
        }
        return env.setErrorMask(levelV.toInt());
    }

    public static boolean restore_error_handler(Env env) {
        env.restoreErrorHandler();
        return true;
    }

    public static boolean set_error_handler(Env env, Callback fun, @Optional(value="E_ALL") int errorMask) {
        env.setErrorHandler(errorMask, fun);
        return true;
    }

    public static Value set_exception_handler(Env env, Callback fun) {
        return env.setExceptionHandler(fun);
    }

    public static Value restore_exception_handler(Env env) {
        env.restoreExceptionHandler();
        return BooleanValue.TRUE;
    }

    public static Value trigger_error(Env env, String msg, @Optional(value="E_USER_NOTICE") int code) {
        switch (code) {
            case 1024: {
                env.error(10, "", msg);
                return BooleanValue.TRUE;
            }
            case 512: {
                env.error(9, "", msg);
                return BooleanValue.TRUE;
            }
            case 256: {
                env.error(8, "", msg);
                return BooleanValue.TRUE;
            }
        }
        env.warning(L.l("'0x{0}' is an invalid error type", (Object)Integer.toHexString(code)));
        return BooleanValue.FALSE;
    }

    public Value user_error(Env env, String msg, @Optional(value="E_USER_NOTICE") int code) {
        return ErrorModule.trigger_error(env, msg, code);
    }
}

